/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc.aot;

import java.util.HashSet;
import java.util.Set;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.SpringProxy;
import org.springframework.aot.hint.MemberCategory;
import org.springframework.aot.hint.RuntimeHints;
import org.springframework.beans.factory.aot.BeanRegistrationAotContribution;
import org.springframework.beans.factory.aot.BeanRegistrationAotProcessor;
import org.springframework.beans.factory.config.ConstructorArgumentValues;
import org.springframework.beans.factory.support.RegisteredBean;
import org.springframework.core.DecoratingProxy;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.data.projection.TargetAware;
import org.springframework.data.repository.core.support.RepositoryFactoryBeanSupport;
import org.springframework.data.rest.core.config.Projection;
import org.springframework.data.util.AnnotatedTypeScanner;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;

class ProjectionAotProcessor
implements BeanRegistrationAotProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProjectionAotProcessor.class);
    private static final Class<?>[] ADDITIONAL_INTERFACES = new Class[]{TargetAware.class, SpringProxy.class, DecoratingProxy.class};
    private final Set<String> packagesSeen = new HashSet<String>();

    ProjectionAotProcessor() {
    }

    public @Nullable BeanRegistrationAotContribution processAheadOfTime(RegisteredBean registeredBean) {
        if (!ClassUtils.isAssignable(RepositoryFactoryBeanSupport.class, (Class)registeredBean.getBeanClass())) {
            return null;
        }
        ConstructorArgumentValues.ValueHolder holder = registeredBean.getMergedBeanDefinition().getConstructorArgumentValues().getIndexedArgumentValue(0, String.class);
        if (holder == null || holder.getValue() == null) {
            throw new IllegalStateException("Constructor argument 0 of '%s' must be a String representing the repository interface to scan for projections.".formatted(registeredBean.getBeanClass().getName()));
        }
        String repositoryInterface = (String)holder.getValue();
        String packageToScan = ClassUtils.getPackageName((String)repositoryInterface);
        LOGGER.debug("Detecting projection interfaces in {}", (Object)packageToScan);
        if (this.packagesSeen.contains(packageToScan)) {
            return null;
        }
        this.packagesSeen.add(packageToScan);
        return (context, code) -> {
            ClassLoader classLoader = registeredBean.getBeanFactory().getBeanClassLoader();
            RuntimeHints hints = context.getRuntimeHints();
            DefaultResourceLoader resourceLoader = new DefaultResourceLoader(classLoader);
            AnnotatedTypeScanner scanner = new AnnotatedTypeScanner(new Class[]{Projection.class});
            scanner.setResourceLoader((ResourceLoader)resourceLoader);
            scanner.findTypes(new String[]{packageToScan}).forEach(it -> {
                LOGGER.debug("Registering proxy config and resource for projection interface {}.", (Object)it.getName());
                hints.reflection().registerType(it, new MemberCategory[]{MemberCategory.INVOKE_PUBLIC_METHODS});
                hints.resources().registerResource(ProjectionAotProcessor.getResource(it, (ResourceLoader)resourceLoader));
                hints.proxies().registerJdkProxy((Class[])ObjectUtils.addObjectToArray((Object[])ADDITIONAL_INTERFACES, (Object)it, (int)0));
            });
        };
    }

    private static Resource getResource(Class<?> type, ResourceLoader loader) {
        String resourcePath = "classpath:" + ClassUtils.convertClassNameToResourcePath((String)type.getName()) + ".class";
        return loader.getResource(resourcePath);
    }
}

