/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc.config;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jmolecules.ddd.types.AggregateRoot;
import org.jmolecules.ddd.types.Identifier;
import org.jspecify.annotations.Nullable;
import org.springframework.core.ResolvableType;
import org.springframework.core.convert.ConversionFailedException;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.GenericConverter;
import org.springframework.data.rest.core.AggregateReference;
import org.springframework.data.rest.core.AssociationAggregateReference;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.web.util.UriComponents;

class StringToAggregateReferenceConverter
implements GenericConverter {
    private static final boolean JMOLECULES_PRESENT = ClassUtils.isPresent((String)"org.jmolecules.spring.IdentifierToPrimitivesConverter", (ClassLoader)StringToAggregateReferenceConverter.class.getClassLoader());
    private static final @Nullable Class<?> ASSOCIATION_AGGREGATE_REFERENCE_TYPE = StringToAggregateReferenceConverter.tryToLoadAssociationReferenceClass();
    private final Supplier<ConversionService> conversionService;

    StringToAggregateReferenceConverter(Supplier<ConversionService> conversionService) {
        Assert.notNull(conversionService, (String)"ConversionService must not be null!");
        this.conversionService = conversionService;
    }

    private static @Nullable Class<?> tryToLoadAssociationReferenceClass() {
        ClassLoader classLoader = StringToAggregateReferenceConverter.class.getClassLoader();
        if (!ClassUtils.isPresent((String)"org.jmolecules.ddd.types.Association", (ClassLoader)classLoader)) {
            return null;
        }
        try {
            return ClassUtils.forName((String)"org.springframework.data.rest.core.AssociationAggregateReference", (ClassLoader)classLoader);
        }
        catch (ClassNotFoundException o_O) {
            return null;
        }
    }

    public Set<GenericConverter.ConvertiblePair> getConvertibleTypes() {
        return Set.of(new GenericConverter.ConvertiblePair(String.class, AggregateReference.class));
    }

    public AggregateReference<?, ?> convert(@Nullable Object source, TypeDescriptor sourceType, TypeDescriptor targetType) {
        if (source == null) {
            throw new ConversionFailedException(sourceType, targetType, source, (Throwable)new IllegalArgumentException("Source value must not be null"));
        }
        try {
            URI uri = new URI(source.toString());
            ResolvableType resolvableType = targetType.getResolvableType();
            TypeDescriptor aggregateDescriptor = new TypeDescriptor(resolvableType.getGeneric(new int[]{0}), null, targetType.getAnnotations());
            TypeDescriptor identifierDescriptor = new TypeDescriptor(resolvableType.getGeneric(new int[]{1}), null, targetType.getAnnotations());
            Function<Object, Object> aggregateResolver = it -> this.conversionService.get().convert(it, sourceType, aggregateDescriptor);
            Function<Object, Object> identifierResolver = it -> this.conversionService.get().convert(it, sourceType, identifierDescriptor);
            AggregateReference result = new AggregateReference(uri, aggregateResolver, identifierResolver);
            return JMOLECULES_PRESENT && resolvableType.toClass().equals(ASSOCIATION_AGGREGATE_REFERENCE_TYPE) ? StringToAggregateReferenceConverter.withJMolecules(result) : result;
        }
        catch (URISyntaxException e) {
            throw new ConversionFailedException(sourceType, targetType, source, (Throwable)e);
        }
    }

    private static AggregateReference<?, ?> withJMolecules(AggregateReference<?, ?> source) {
        return new ResolvingAssociationAggregateReference(source);
    }

    private static class ResolvingAssociationAggregateReference<T extends AggregateRoot<T, ID>, ID extends Identifier>
    implements AssociationAggregateReference<T, ID> {
        private final AggregateReference<T, ID> delegate;

        ResolvingAssociationAggregateReference(AggregateReference<T, ID> delegate) {
            this.delegate = delegate;
        }

        public URI getUri() {
            return this.delegate.getUri();
        }

        public @Nullable ID resolveId() {
            return (ID)((Identifier)this.delegate.resolveId());
        }

        public @Nullable T resolveAggregate() {
            return (T)((AggregateRoot)this.delegate.resolveAggregate());
        }

        public AssociationAggregateReference<T, ID> withIdSource(Function<UriComponents, Object> extractor) {
            return new ResolvingAssociationAggregateReference<T, ID>(this.delegate.withIdSource(extractor));
        }
    }
}

