/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc;

import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.springframework.data.core.TypeInformation;
import org.springframework.data.domain.Sort;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.repository.query.Param;
import org.springframework.data.repository.support.RepositoryInvoker;
import org.springframework.data.rest.core.mapping.MethodResourceMapping;
import org.springframework.data.rest.core.mapping.ResourceMappings;
import org.springframework.data.rest.core.mapping.ResourceMetadata;
import org.springframework.data.rest.core.mapping.SearchResourceMappings;
import org.springframework.data.rest.webmvc.ControllerUtils;
import org.springframework.data.rest.webmvc.HttpHeadersPreparer;
import org.springframework.data.rest.webmvc.RepositoryRestController;
import org.springframework.data.rest.webmvc.RepositorySearchesResource;
import org.springframework.data.rest.webmvc.RepresentationModelAssemblers;
import org.springframework.data.rest.webmvc.ResourceNotFoundException;
import org.springframework.data.rest.webmvc.ResourceStatus;
import org.springframework.data.rest.webmvc.RootResourceInformation;
import org.springframework.data.rest.webmvc.support.DefaultedPageable;
import org.springframework.data.rest.webmvc.support.RepositoryEntityLinks;
import org.springframework.hateoas.CollectionModel;
import org.springframework.hateoas.EntityModel;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.Links;
import org.springframework.hateoas.RepresentationModel;
import org.springframework.hateoas.server.core.AnnotationAttribute;
import org.springframework.hateoas.server.core.MethodParameters;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@RepositoryRestController
class RepositorySearchController {
    private static final String SEARCH = "/search";
    private static final String BASE_MAPPING = "/{repository}/search";
    private final RepositoryEntityLinks entityLinks;
    private final ResourceMappings mappings;
    private final ResourceStatus resourceStatus;

    public RepositorySearchController(RepositoryEntityLinks entityLinks, ResourceMappings mappings, HttpHeadersPreparer headersPreparer) {
        Assert.notNull((Object)((Object)entityLinks), (String)"EntityLinks must not be null");
        Assert.notNull((Object)mappings, (String)"ResourceMappings must not be null");
        this.entityLinks = entityLinks;
        this.mappings = mappings;
        this.resourceStatus = ResourceStatus.of(headersPreparer);
    }

    @RequestMapping(value={"/{repository}/search"}, method={RequestMethod.OPTIONS})
    public HttpEntity<?> optionsForSearches(RootResourceInformation resourceInformation) {
        RepositorySearchController.verifySearchesExposed(resourceInformation);
        HttpHeaders headers = new HttpHeaders();
        headers.setAllow(Collections.singleton(HttpMethod.GET));
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(headers)).build();
    }

    @RequestMapping(value={"/{repository}/search"}, method={RequestMethod.HEAD})
    public HttpEntity<?> headForSearches(RootResourceInformation resourceInformation) {
        RepositorySearchController.verifySearchesExposed(resourceInformation);
        return ResponseEntity.noContent().build();
    }

    @ResponseBody
    @RequestMapping(value={"/{repository}/search"}, method={RequestMethod.GET})
    public RepositorySearchesResource listSearches(RootResourceInformation resourceInformation) {
        RepositorySearchController.verifySearchesExposed(resourceInformation);
        Links queryMethodLinks = this.entityLinks.linksToSearchResources(resourceInformation.getDomainType());
        if (queryMethodLinks.isEmpty()) {
            throw new ResourceNotFoundException();
        }
        return (RepositorySearchesResource)((RepositorySearchesResource)new RepositorySearchesResource(resourceInformation.getDomainType()).add((Iterable)queryMethodLinks)).add(ControllerUtils.getDefaultSelfLink());
    }

    @ResponseBody
    @RequestMapping(value={"/{repository}/search/{search}"}, method={RequestMethod.GET})
    public ResponseEntity<?> executeSearch(RootResourceInformation resourceInformation, @RequestParam MultiValueMap<String, Object> parameters, @PathVariable String search, DefaultedPageable pageable, Sort sort, @RequestHeader HttpHeaders headers, RepresentationModelAssemblers assemblers) {
        Method method = this.checkExecutability(resourceInformation, search);
        Optional<Object> result = this.executeQueryMethod(resourceInformation.getRequiredInvoker(), parameters, method, pageable, sort);
        SearchResourceMappings searchMappings = resourceInformation.getSearchMappings();
        MethodResourceMapping methodMapping = searchMappings.getExportedMethodMappingForPath(search);
        if (methodMapping == null) {
            throw new ResourceNotFoundException();
        }
        Class domainType = methodMapping.getReturnedDomainType();
        return this.toModel(result, domainType, headers, resourceInformation, assemblers);
    }

    protected ResponseEntity<?> toModel(Optional<Object> source, Class<?> domainType, HttpHeaders headers, RootResourceInformation information, RepresentationModelAssemblers assemblers) {
        return source.map(it -> {
            if (it instanceof Iterable) {
                Iterable iterable = (Iterable)it;
                return ResponseEntity.ok(assemblers.toCollectionModel(iterable, domainType));
            }
            if (ClassUtils.isPrimitiveOrWrapper(it.getClass())) {
                return ResponseEntity.ok((Object)it);
            }
            PersistentEntity<?, ?> entity = information.getPersistentEntity();
            if (!entity.getType().isInstance(it)) {
                return ResponseEntity.ok((Object)it);
            }
            return this.resourceStatus.getStatusAndHeaders(headers, it, entity).toResponseEntity(() -> assemblers.toFullResource(it));
        }).orElseThrow(ResourceNotFoundException::new);
    }

    @ResponseBody
    @RequestMapping(value={"/{repository}/search/{search}"}, method={RequestMethod.GET}, produces={"application/x-spring-data-compact+json"})
    public RepresentationModel<?> executeSearchCompact(RootResourceInformation resourceInformation, @RequestHeader HttpHeaders headers, @RequestParam MultiValueMap<String, Object> parameters, @PathVariable String repository, @PathVariable String search, DefaultedPageable pageable, Sort sort, RepresentationModelAssemblers assemblers) {
        CollectionModel model;
        Method method = this.checkExecutability(resourceInformation, search);
        Optional<Object> result = this.executeQueryMethod(resourceInformation.getRequiredInvoker(), parameters, method, pageable, sort);
        ResourceMetadata metadata = resourceInformation.getResourceMetadata();
        ResponseEntity<?> entity = this.toModel(result, metadata.getDomainType(), headers, resourceInformation, assemblers);
        Object resource = entity.getBody();
        ArrayList<Link> links = new ArrayList<Link>();
        if (resource instanceof CollectionModel && (model = (CollectionModel)resource).getContent() != null) {
            for (Object obj : model.getContent()) {
                if (null == obj || !(obj instanceof EntityModel)) continue;
                EntityModel res = (EntityModel)obj;
                links.add(resourceInformation.resourceLink(res));
            }
        } else if (resource instanceof EntityModel) {
            EntityModel res = (EntityModel)resource;
            links.add(resourceInformation.resourceLink(res));
        }
        return CollectionModel.empty(links);
    }

    @RequestMapping(value={"/{repository}/search/{search}"}, method={RequestMethod.OPTIONS})
    public ResponseEntity<Object> optionsForSearch(RootResourceInformation information, @PathVariable String search) {
        this.checkExecutability(information, search);
        HttpHeaders headers = new HttpHeaders();
        headers.setAllow(Collections.singleton(HttpMethod.GET));
        return new ResponseEntity(headers, (HttpStatusCode)HttpStatus.OK);
    }

    @RequestMapping(value={"/{repository}/search/{search}"}, method={RequestMethod.HEAD})
    public ResponseEntity<Object> headForSearch(RootResourceInformation information, @PathVariable String search) {
        this.checkExecutability(information, search);
        return new ResponseEntity((HttpStatusCode)HttpStatus.NO_CONTENT);
    }

    private Method checkExecutability(RootResourceInformation resourceInformation, String searchName) {
        SearchResourceMappings searchMapping = RepositorySearchController.verifySearchesExposed(resourceInformation);
        Method method = searchMapping.getMappedMethod(searchName);
        if (method == null) {
            throw new ResourceNotFoundException();
        }
        return method;
    }

    private Optional<Object> executeQueryMethod(RepositoryInvoker invoker, @RequestParam MultiValueMap<String, Object> parameters, Method method, DefaultedPageable pageable, Sort sort) {
        LinkedMultiValueMap result = new LinkedMultiValueMap(parameters);
        MethodParameters methodParameters = new MethodParameters(method, new AnnotationAttribute(Param.class));
        List parameterList = methodParameters.getParameters();
        List parameterTypeInformations = TypeInformation.of(method.getDeclaringClass()).getParameterTypes(method);
        parameters.entrySet().forEach(entry -> methodParameters.getParameter((String)entry.getKey()).ifPresent(parameter -> {
            int parameterIndex = parameterList.indexOf(parameter);
            TypeInformation domainType = ((TypeInformation)parameterTypeInformations.get(parameterIndex)).getRequiredActualType();
            ResourceMetadata metadata = this.mappings.getMetadataFor(domainType.getType());
            if (metadata != null && metadata.isExported() && parameter.getParameterName() != null) {
                result.put((Object)parameter.getParameterName(), RepositorySearchController.prepareUris((List)entry.getValue()));
            }
        }));
        return invoker.invokeQueryMethod(method, (MultiValueMap)result, pageable.getPageable(), sort);
    }

    private static SearchResourceMappings verifySearchesExposed(RootResourceInformation resourceInformation) {
        SearchResourceMappings resourceMappings = resourceInformation.getSearchMappings();
        if (!resourceMappings.isExported()) {
            throw new ResourceNotFoundException();
        }
        return resourceMappings;
    }

    private static List<Object> prepareUris(List<Object> source) {
        if (source == null || source.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Object> result = new ArrayList<Object>(source.size());
        for (Object element : source) {
            try {
                result.add(new URI(element.toString()));
            }
            catch (URISyntaxException o_O) {
                result.add(element);
            }
        }
        return result;
    }
}

