/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc.json;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.core.MethodParameter;
import org.springframework.data.domain.Sort;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.context.PersistentEntities;
import org.springframework.data.repository.support.Repositories;
import org.springframework.data.rest.webmvc.json.MappedJackson3Properties;
import org.springframework.data.rest.webmvc.json.WrappedJackson3Properties;
import org.springframework.data.rest.webmvc.mapping.Associations;
import org.springframework.data.rest.webmvc.support.DomainClassResolver;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.context.request.NativeWebRequest;
import tools.jackson.databind.ObjectMapper;

public class Jackson3MappingAwareSortTranslator
implements org.springframework.data.rest.webmvc.json.SortTranslator {
    private final Repositories repositories;
    private final DomainClassResolver domainClassResolver;
    private final SortTranslator sortTranslator;

    public Jackson3MappingAwareSortTranslator(ObjectMapper objectMapper, Repositories repositories, DomainClassResolver domainClassResolver, PersistentEntities persistentEntities, Associations associations) {
        Assert.notNull((Object)repositories, (String)"Repositories must not be null");
        Assert.notNull((Object)domainClassResolver, (String)"DomainClassResolver must not be null");
        Assert.notNull((Object)associations, (String)"Associations must not be null");
        this.repositories = repositories;
        this.domainClassResolver = domainClassResolver;
        this.sortTranslator = new SortTranslator(persistentEntities, objectMapper, associations);
    }

    @Override
    public Sort translateSort(Sort input, MethodParameter parameter, NativeWebRequest webRequest) {
        Assert.notNull((Object)input, (String)"Sort must not be null");
        Assert.notNull((Object)parameter, (String)"MethodParameter must not be null");
        Assert.notNull((Object)webRequest, (String)"NativeWebRequest must not be null");
        Class<?> domainClass = this.domainClassResolver.resolve(parameter.getMethod(), webRequest);
        if (domainClass == null) {
            return input;
        }
        PersistentEntity persistentEntity = this.repositories.getPersistentEntity(domainClass);
        return this.sortTranslator.translateSort(input, persistentEntity);
    }

    public static class SortTranslator {
        private static final String DELIMITERS = "_\\.";
        private static final String ALL_UPPERCASE = "[A-Z0-9._$]+";
        private static final Pattern SPLITTER = Pattern.compile("(?:[%s]?([%s]*?[^%s]+))".replaceAll("%s", "_\\."));
        private final PersistentEntities entities;
        private final ObjectMapper objectMapper;
        private final Associations associations;

        public SortTranslator(PersistentEntities entities, ObjectMapper objectMapper, Associations associations) {
            Assert.notNull((Object)entities, (String)"PersistentEntities must not be null");
            Assert.notNull((Object)objectMapper, (String)"ObjectMapper must not be null");
            Assert.notNull((Object)associations, (String)"Associations must not be null");
            this.entities = entities;
            this.objectMapper = objectMapper;
            this.associations = associations;
        }

        public Sort translateSort(Sort input, PersistentEntity<?, ?> rootEntity) {
            Assert.notNull((Object)input, (String)"Sort must not be null");
            Assert.notNull(rootEntity, (String)"PersistentEntity must not be null");
            ArrayList<Sort.Order> filteredOrders = new ArrayList<Sort.Order>();
            for (Sort.Order order : input) {
                ArrayList<String> iteratorSource = new ArrayList<String>();
                Matcher matcher = SPLITTER.matcher("_" + order.getProperty());
                while (matcher.find()) {
                    iteratorSource.add(matcher.group(1));
                }
                String mappedPropertyPath = this.getMappedPropertyPath(rootEntity, iteratorSource);
                if (mappedPropertyPath == null) continue;
                filteredOrders.add(order.withProperty(mappedPropertyPath));
            }
            return filteredOrders.isEmpty() ? Sort.unsorted() : Sort.by(filteredOrders);
        }

        private String getMappedPropertyPath(PersistentEntity<?, ?> rootEntity, List<String> iteratorSource) {
            List<String> persistentPropertyPath = this.mapPropertyPath(rootEntity, iteratorSource);
            if (persistentPropertyPath.isEmpty()) {
                return null;
            }
            return StringUtils.collectionToDelimitedString(persistentPropertyPath, (String)".");
        }

        private List<String> mapPropertyPath(PersistentEntity<?, ?> rootEntity, List<String> iteratorSource) {
            ArrayList<String> persistentPropertyPath = new ArrayList<String>(iteratorSource.size());
            TypedSegment typedSegment = TypedSegment.create(this.entities, this.objectMapper, rootEntity);
            for (String field : iteratorSource) {
                String fieldName;
                String string = fieldName = field.matches(ALL_UPPERCASE) ? field : StringUtils.uncapitalize((String)field);
                if (!typedSegment.hasPersistentPropertyForField(fieldName)) {
                    return Collections.emptyList();
                }
                List<PersistentProperty<?>> persistentProperties = typedSegment.getPersistentProperties(fieldName);
                for (PersistentProperty<?> persistentProperty : persistentProperties) {
                    if (this.associations.isLinkableAssociation(persistentProperty)) {
                        return Collections.emptyList();
                    }
                    persistentPropertyPath.add(persistentProperty.getName());
                }
                typedSegment = typedSegment.next(persistentProperties.get(persistentProperties.size() - 1));
            }
            return persistentPropertyPath;
        }
    }

    static class TypedSegment {
        private final PersistentEntities persistentEntities;
        private final ObjectMapper objectMapper;
        private final Optional<PersistentEntity<?, ? extends PersistentProperty<?>>> currentType;
        private final MappedJackson3Properties currentProperties;
        private final WrappedJackson3Properties currentWrappedProperties;

        private TypedSegment(TypedSegment previous, Optional<PersistentEntity<?, ? extends PersistentProperty<?>>> persistentEntity) {
            this(previous.persistentEntities, previous.objectMapper, persistentEntity);
        }

        private TypedSegment(PersistentEntities persistentEntities, ObjectMapper objectMapper, Optional<PersistentEntity<?, ? extends PersistentProperty<?>>> persistentEntity) {
            this.persistentEntities = persistentEntities;
            this.objectMapper = objectMapper;
            this.currentType = persistentEntity;
            this.currentProperties = persistentEntity.map(it -> MappedJackson3Properties.forSerialization(it, objectMapper)).orElseGet(() -> MappedJackson3Properties.none());
            this.currentWrappedProperties = persistentEntity.map(it -> WrappedJackson3Properties.fromJacksonProperties(persistentEntities, it, objectMapper)).orElseGet(() -> WrappedJackson3Properties.none());
        }

        public static TypedSegment create(PersistentEntities persistentEntities, ObjectMapper objectMapper, PersistentEntity<?, ?> rootEntity) {
            Assert.notNull((Object)persistentEntities, (String)"PersistentEntities must not be null");
            Assert.notNull((Object)objectMapper, (String)"ObjectMapper must not be null");
            Assert.notNull(rootEntity, (String)"PersistentEntity must not be null");
            return new TypedSegment(persistentEntities, objectMapper, Optional.of(rootEntity));
        }

        public TypedSegment next(PersistentProperty<?> persistentProperty) {
            Assert.notNull(persistentProperty, (String)"PersistentProperty must not be null");
            return new TypedSegment(this, this.persistentEntities.getPersistentEntity(persistentProperty.getType()));
        }

        private boolean hasPersistentPropertyForField(String fieldName) {
            return this.currentType != null && (this.currentProperties.hasPersistentPropertyForField(fieldName) || this.currentWrappedProperties.hasPersistentPropertiesForField(fieldName));
        }

        private List<? extends PersistentProperty<?>> getPersistentProperties(String fieldName) {
            if (this.currentWrappedProperties.hasPersistentPropertiesForField(fieldName)) {
                return this.currentWrappedProperties.getPersistentProperties(fieldName);
            }
            return Collections.singletonList(this.currentProperties.getPersistentProperty(fieldName));
        }
    }
}

