/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc.json;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.deser.ContextualDeserializer;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.module.SimpleDeserializers;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.module.SimpleSerializers;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.util.ArrayList;
import org.jspecify.annotations.Nullable;
import org.springframework.data.rest.webmvc.json.EnumTranslator;
import org.springframework.data.rest.webmvc.json.JsonSchema;
import org.springframework.data.rest.webmvc.json.JsonSchemaPropertyCustomizer;
import org.springframework.data.util.TypeInformation;
import org.springframework.util.Assert;

public class JacksonSerializers
extends SimpleModule {
    private static final long serialVersionUID = 4396776390917947147L;

    public JacksonSerializers(EnumTranslator translator) {
        Assert.notNull((Object)translator, (String)"EnumTranslator must not be null");
        SimpleSerializers serializers = new SimpleSerializers();
        serializers.addSerializer(Enum.class, (JsonSerializer)new EnumTranslatingSerializer(translator));
        this.setSerializers(serializers);
        SimpleDeserializers deserializers = new SimpleDeserializers();
        deserializers.addDeserializer(Enum.class, (JsonDeserializer)new EnumTranslatingDeserializer(translator));
        this.setDeserializers(deserializers);
    }

    public static class EnumTranslatingSerializer
    extends StdSerializer<Enum>
    implements JsonSchemaPropertyCustomizer {
        private static final long serialVersionUID = -6706924011396258646L;
        private final EnumTranslator translator;

        public EnumTranslatingSerializer(EnumTranslator translator) {
            super(Enum.class);
            Assert.notNull((Object)translator, (String)"EnumTranslator must not be null");
            this.translator = translator;
        }

        public void serialize(Enum value, JsonGenerator gen, SerializerProvider provider) throws IOException {
            gen.writeString(this.translator.asText(value));
        }

        @Override
        public JsonSchema.JsonSchemaProperty customize(JsonSchema.JsonSchemaProperty property, TypeInformation<?> type) {
            ArrayList<String> values = new ArrayList<String>();
            for (Object value : type.getType().getEnumConstants()) {
                values.add(this.translator.asText((Enum)value));
            }
            return ((JsonSchema.EnumProperty)property).withValues(values);
        }
    }

    public static class EnumTranslatingDeserializer
    extends StdDeserializer<Enum>
    implements ContextualDeserializer {
        private static final long serialVersionUID = 5305284644923180079L;
        private final EnumTranslator translator;
        private final @Nullable BeanProperty property;

        public EnumTranslatingDeserializer(EnumTranslator translator) {
            this(translator, null);
        }

        public EnumTranslatingDeserializer(EnumTranslator translator, @Nullable BeanProperty property) {
            super(Enum.class);
            Assert.notNull((Object)translator, (String)"EnumTranslator must not be null");
            this.translator = translator;
            this.property = property;
        }

        public JsonDeserializer<?> createContextual(DeserializationContext ctxt, BeanProperty property) throws JsonMappingException {
            return new EnumTranslatingDeserializer(this.translator, property);
        }

        public @Nullable Enum deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            if (this.property == null) {
                throw new IllegalStateException("Can only translate enum with property information");
            }
            return this.translator.fromText(EnumTranslatingDeserializer.getActualType(this.property.getType()).getRawClass(), p.getText());
        }

        private static JavaType getActualType(JavaType type) {
            return type.isContainerType() ? type.getContentType() : type;
        }
    }
}

