/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc.convert;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.List;
import org.springframework.hateoas.CollectionModel;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.Links;
import org.springframework.hateoas.RepresentationModel;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.http.converter.HttpMessageNotWritableException;

public class UriListHttpMessageConverter
implements HttpMessageConverter<RepresentationModel<?>> {
    private static final List<MediaType> MEDIA_TYPES = new ArrayList<MediaType>();

    public boolean canRead(Class<?> clazz, MediaType mediaType) {
        return null != mediaType && RepresentationModel.class.isAssignableFrom(clazz) && mediaType.getSubtype().contains("uri-list");
    }

    public boolean canWrite(Class<?> clazz, MediaType mediaType) {
        return this.canRead(clazz, mediaType);
    }

    public List<MediaType> getSupportedMediaTypes() {
        return MEDIA_TYPES;
    }

    public RepresentationModel<?> read(Class<? extends RepresentationModel<?>> clazz, HttpInputMessage inputMessage) throws IOException, HttpMessageNotReadableException {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(inputMessage.getBody()));){
            Links links = reader.lines().map(Link::of).reduce(Links.NONE, (rec$, xva$0) -> rec$.and(new Link[]{xva$0}), Links::and);
            CollectionModel collectionModel = CollectionModel.empty((Iterable)links);
            return collectionModel;
        }
    }

    public void write(RepresentationModel<?> resource, MediaType contentType, HttpOutputMessage outputMessage) throws IOException, HttpMessageNotWritableException {
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(outputMessage.getBody()));
        for (Link link : resource.getLinks()) {
            writer.write(link.getHref());
            writer.newLine();
        }
        writer.flush();
    }

    static {
        MEDIA_TYPES.add(MediaType.parseMediaType((String)"text/uri-list"));
    }
}

