/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc.json;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.springframework.core.convert.ConversionService;
import org.springframework.data.mapping.context.PersistentEntities;
import org.springframework.data.rest.webmvc.json.BindContextFactory;
import org.springframework.data.rest.webmvc.json.JacksonBindContext;
import org.springframework.data.rest.webmvc.json.patch.BindContext;
import org.springframework.util.Assert;

public class PersistentEntitiesBindContextFactory
implements BindContextFactory {
    private final PersistentEntities entities;
    private final ConversionService conversionService;

    public PersistentEntitiesBindContextFactory(PersistentEntities entities, ConversionService conversionService) {
        Assert.notNull((Object)entities, (String)"PersistentEntities must not be null!");
        this.entities = entities;
        this.conversionService = conversionService;
    }

    @Override
    public BindContext getBindContextFor(ObjectMapper mapper) {
        return new JacksonBindContext(this.entities, this.conversionService, mapper);
    }
}

