/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc.support;

import lombok.NonNull;
import org.springframework.data.domain.Pageable;

public final class DefaultedPageable {
    @NonNull
    private final Pageable pageable;
    private final boolean isDefault;

    public boolean isDefault() {
        return this.isDefault;
    }

    public Pageable unpagedIfDefault() {
        return this.isDefault ? Pageable.unpaged() : this.pageable;
    }

    public DefaultedPageable(@NonNull Pageable pageable, boolean isDefault) {
        if (pageable == null) {
            throw new IllegalArgumentException("pageable is marked non-null but is null");
        }
        this.pageable = pageable;
        this.isDefault = isDefault;
    }

    @NonNull
    public Pageable getPageable() {
        return this.pageable;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DefaultedPageable)) {
            return false;
        }
        DefaultedPageable other = (DefaultedPageable)o;
        Pageable this$pageable = this.getPageable();
        Pageable other$pageable = other.getPageable();
        if (this$pageable == null ? other$pageable != null : !this$pageable.equals(other$pageable)) {
            return false;
        }
        return this.isDefault() == other.isDefault();
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Pageable $pageable = this.getPageable();
        result = result * 59 + ($pageable == null ? 43 : $pageable.hashCode());
        result = result * 59 + (this.isDefault() ? 79 : 97);
        return result;
    }

    public String toString() {
        return "DefaultedPageable(pageable=" + this.getPageable() + ", isDefault=" + this.isDefault() + ")";
    }
}

