/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc;

import java.util.Collections;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.repository.support.Repositories;
import org.springframework.data.rest.core.config.RepositoryRestConfiguration;
import org.springframework.data.rest.core.mapping.RepositoryResourceMappings;
import org.springframework.data.rest.core.mapping.ResourceMapping;
import org.springframework.data.rest.core.mapping.ResourceMetadata;
import org.springframework.data.rest.webmvc.BasePathAwareController;
import org.springframework.data.rest.webmvc.BaseUri;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.LinkRelation;
import org.springframework.hateoas.RepresentationModel;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@BasePathAwareController
public class ProfileController {
    public static final String PROFILE_ROOT_MAPPING = "/profile";
    public static final String RESOURCE_PROFILE_MAPPING = "/profile/{repository}";
    private final RepositoryRestConfiguration configuration;
    private final RepositoryResourceMappings mappings;
    private final Repositories repositories;

    @Autowired
    public ProfileController(RepositoryRestConfiguration configuration, RepositoryResourceMappings mappings, Repositories repositories) {
        Assert.notNull((Object)configuration, (String)"RepositoryRestConfiguration must not be null!");
        Assert.notNull((Object)mappings, (String)"RepositoryResourceMappings must not be null!");
        Assert.notNull((Object)repositories, (String)"Repositories must not be null!");
        this.configuration = configuration;
        this.mappings = mappings;
        this.repositories = repositories;
    }

    @RequestMapping(value={"/profile"}, method={RequestMethod.OPTIONS})
    public HttpEntity<?> profileOptions() {
        HttpHeaders headers = new HttpHeaders();
        headers.setAllow(Collections.singleton(HttpMethod.GET));
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(headers)).build();
    }

    @RequestMapping(value={"/profile"}, method={RequestMethod.GET})
    HttpEntity<RepresentationModel<?>> listAllFormsOfMetadata() {
        RepresentationModel profile = new RepresentationModel();
        profile.add(Link.of((String)ProfileController.getRootPath(this.configuration)).withSelfRel());
        for (Class domainType : this.repositories) {
            ResourceMetadata mapping = this.mappings.getMetadataFor(domainType);
            if (!mapping.isExported()) continue;
            profile.add(Link.of((String)ProfileController.getPath(this.configuration, (ResourceMapping)mapping), (LinkRelation)mapping.getRel()));
        }
        return ResponseEntity.ok((Object)profile);
    }

    public static String getRootPath(RepositoryRestConfiguration configuration) {
        BaseUri baseUri = new BaseUri(configuration.getBaseUri());
        return baseUri.getUriComponentsBuilder().path(PROFILE_ROOT_MAPPING).build().toString();
    }

    public static String getPath(RepositoryRestConfiguration configuration, ResourceMapping mapping) {
        String path = ProfileController.getRootPath(configuration);
        return mapping == null ? path : path + mapping.getPath();
    }
}

