/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc.support;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Locale;
import javax.validation.ConstraintViolation;
import org.springframework.context.MessageSource;

public class ConstraintViolationMessage {
    private final ConstraintViolation<?> violation;
    private final String message;

    public ConstraintViolationMessage(ConstraintViolation<?> violation, MessageSource msgSrc, Locale locale) {
        this.violation = violation;
        this.message = msgSrc.getMessage(violation.getMessageTemplate(), new Object[]{violation.getLeafBean().getClass().getSimpleName(), violation.getPropertyPath().toString(), violation.getInvalidValue()}, violation.getMessage(), locale);
    }

    @JsonProperty(value="entity")
    public String getEntity() {
        return this.violation.getRootBean().getClass().getName();
    }

    @JsonProperty(value="message")
    public String getMessage() {
        return this.message;
    }

    @JsonProperty(value="invalidValue")
    public String getInvalidValue() {
        return String.format("%s", this.violation.getInvalidValue());
    }

    @JsonProperty(value="property")
    public String getProperty() {
        return this.violation.getPropertyPath().toString();
    }
}

