/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc.json;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.springframework.context.NoSuchMessageException;
import org.springframework.context.support.MessageSourceAccessor;
import org.springframework.data.rest.core.config.EnumTranslationConfiguration;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class EnumTranslator
implements EnumTranslationConfiguration {
    private final MessageSourceAccessor messageSourceAccessor;
    private boolean enableDefaultTranslation;
    private boolean parseEnumNameAsFallback;

    public EnumTranslator(MessageSourceAccessor messageSourceAccessor) {
        Assert.notNull((Object)messageSourceAccessor, (String)"MessageSourceAccessor must not be null!");
        this.messageSourceAccessor = messageSourceAccessor;
        this.enableDefaultTranslation = true;
        this.parseEnumNameAsFallback = true;
    }

    public void setEnableDefaultTranslation(boolean enableDefaultTranslation) {
        this.enableDefaultTranslation = enableDefaultTranslation;
    }

    public void setParseEnumNameAsFallback(boolean parseEnumNameAsFallback) {
        this.parseEnumNameAsFallback = parseEnumNameAsFallback;
    }

    public String asText(Enum<?> value) {
        Assert.notNull(value, (String)"Enum value must not be null!");
        String code = String.format("%s.%s", value.getDeclaringClass().getName(), value.name());
        try {
            return this.messageSourceAccessor.getMessage(code);
        }
        catch (NoSuchMessageException o_O) {
            return this.enableDefaultTranslation ? this.toDefault(value) : value.name();
        }
    }

    public List<String> getValues(Class<? extends Enum<?>> type) {
        ArrayList<String> result = new ArrayList<String>();
        for (Enum<?> value : type.getEnumConstants()) {
            result.add(this.asText(value));
        }
        return result;
    }

    public <T extends Enum<?>> T fromText(Class<T> type, String text) {
        if (!StringUtils.hasText((String)text)) {
            return null;
        }
        Assert.notNull(type, (String)"Enum type must not be null!");
        T value = this.resolveEnum(type, text, true);
        if (value != null) {
            return value;
        }
        value = this.fromDefault(type, text);
        if (value != null && this.enableDefaultTranslation && this.asText((Enum<?>)value).equals(text)) {
            return value;
        }
        return this.parseEnumNameAsFallback ? (T)this.resolveEnum(type, text, false) : null;
    }

    private <T extends Enum<?>> T resolveEnum(Class<T> type, String text, boolean resolve) {
        for (Enum value : (Enum[])type.getEnumConstants()) {
            String resolved;
            String string = resolved = resolve ? this.asText(value) : value.name();
            if (resolved == null || !resolved.equals(text)) continue;
            return (T)value;
        }
        return null;
    }

    private String toDefault(Enum<?> value) {
        return StringUtils.capitalize((String)value.name().toLowerCase(Locale.US).replaceAll("_", " "));
    }

    private <T extends Enum<?>> T fromDefault(Class<T> type, String text) {
        return this.resolveEnum(type, text.toUpperCase(Locale.US).replaceAll(" ", "_"), true);
    }
}

