/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc;

import java.util.List;
import java.util.Set;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.data.rest.core.config.RepositoryRestConfiguration;
import org.springframework.data.rest.core.mapping.ResourceMappings;
import org.springframework.data.rest.webmvc.BasePathAwareHandlerMapping;
import org.springframework.data.rest.webmvc.BaseUri;
import org.springframework.data.rest.webmvc.RepositoryRestController;
import org.springframework.data.rest.webmvc.support.JpaHelper;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.context.request.WebRequestInterceptor;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;

public class RepositoryRestHandlerMapping
extends BasePathAwareHandlerMapping {
    private final ResourceMappings mappings;
    private final RepositoryRestConfiguration configuration;
    private JpaHelper jpaHelper;

    public RepositoryRestHandlerMapping(ResourceMappings mappings, RepositoryRestConfiguration config) {
        super(config);
        Assert.notNull((Object)mappings, (String)"ResourceMappings must not be null!");
        Assert.notNull((Object)config, (String)"RepositoryRestConfiguration must not be null!");
        this.mappings = mappings;
        this.configuration = config;
    }

    public void setJpaHelper(JpaHelper jpaHelper) {
        this.jpaHelper = jpaHelper;
    }

    protected HandlerMethod lookupHandlerMethod(String lookupPath, HttpServletRequest request) throws Exception {
        HandlerMethod handlerMethod = super.lookupHandlerMethod(lookupPath, request);
        if (handlerMethod == null) {
            return null;
        }
        String repositoryLookupPath = new BaseUri(this.configuration.getBaseUri()).getRepositoryLookupPath(lookupPath);
        if (!StringUtils.hasText((String)repositoryLookupPath)) {
            return handlerMethod;
        }
        return this.mappings.exportsTopLevelResourceFor(RepositoryRestHandlerMapping.getRepositoryBasePath(repositoryLookupPath)) ? handlerMethod : null;
    }

    protected HandlerMethod handleNoMatch(Set<RequestMappingInfo> requestMappingInfos, String lookupPath, HttpServletRequest request) throws ServletException {
        return null;
    }

    @Override
    protected boolean isHandler(Class<?> beanType) {
        return AnnotationUtils.findAnnotation(beanType, RepositoryRestController.class) != null;
    }

    protected void extendInterceptors(List<Object> interceptors) {
        if (null != this.jpaHelper) {
            for (WebRequestInterceptor o : this.jpaHelper.getInterceptors()) {
                interceptors.add(o);
            }
        }
    }

    private static String getRepositoryBasePath(String repositoryLookupPath) {
        int secondSlashIndex = repositoryLookupPath.indexOf(47, repositoryLookupPath.startsWith("/") ? 1 : 0);
        return secondSlashIndex == -1 ? repositoryLookupPath : repositoryLookupPath.substring(0, secondSlashIndex);
    }
}

