/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.core.CollectionFactory;
import org.springframework.core.convert.ConversionService;
import org.springframework.data.auditing.AuditableBeanWrapperFactory;
import org.springframework.data.mapping.Association;
import org.springframework.data.mapping.IdentifierAccessor;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.PersistentPropertyAccessor;
import org.springframework.data.mapping.SimpleAssociationHandler;
import org.springframework.data.repository.support.Repositories;
import org.springframework.data.repository.support.RepositoryInvoker;
import org.springframework.data.rest.core.event.AfterLinkDeleteEvent;
import org.springframework.data.rest.core.event.AfterLinkSaveEvent;
import org.springframework.data.rest.core.event.BeforeLinkDeleteEvent;
import org.springframework.data.rest.core.event.BeforeLinkSaveEvent;
import org.springframework.data.rest.core.mapping.ResourceMapping;
import org.springframework.data.rest.core.mapping.ResourceMetadata;
import org.springframework.data.rest.core.util.Function;
import org.springframework.data.rest.webmvc.AbstractRepositoryRestController;
import org.springframework.data.rest.webmvc.ControllerUtils;
import org.springframework.data.rest.webmvc.PersistentEntityResource;
import org.springframework.data.rest.webmvc.PersistentEntityResourceAssembler;
import org.springframework.data.rest.webmvc.RepositoryRestController;
import org.springframework.data.rest.webmvc.ResourceNotFoundException;
import org.springframework.data.rest.webmvc.RootResourceInformation;
import org.springframework.data.rest.webmvc.support.BackendId;
import org.springframework.data.web.PagedResourcesAssembler;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.Resource;
import org.springframework.hateoas.ResourceSupport;
import org.springframework.hateoas.Resources;
import org.springframework.hateoas.mvc.ControllerLinkBuilder;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@RepositoryRestController
class RepositoryPropertyReferenceController
extends AbstractRepositoryRestController
implements ApplicationEventPublisherAware {
    private static final String BASE_MAPPING = "/{repository}/{id}/{property}";
    private static final Collection<HttpMethod> AUGMENTING_METHODS = Arrays.asList(HttpMethod.PATCH, HttpMethod.POST);
    private final Repositories repositories;
    private final ConversionService conversionService;
    private ApplicationEventPublisher publisher;

    @Autowired
    public RepositoryPropertyReferenceController(Repositories repositories, @Qualifier(value="defaultConversionService") ConversionService conversionService, PagedResourcesAssembler<Object> assembler, AuditableBeanWrapperFactory auditableBeanWrapperFactory) {
        super(assembler, auditableBeanWrapperFactory);
        this.repositories = repositories;
        this.conversionService = conversionService;
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.publisher = applicationEventPublisher;
    }

    @RequestMapping(value={"/{repository}/{id}/{property}"}, method={RequestMethod.GET})
    public ResponseEntity<ResourceSupport> followPropertyReference(RootResourceInformation repoRequest, @BackendId Serializable id, @PathVariable String property, final PersistentEntityResourceAssembler assembler) throws Exception {
        final HttpHeaders headers = new HttpHeaders();
        Function<ReferencedProperty, ResourceSupport> handler = new Function<ReferencedProperty, ResourceSupport>(){

            public ResourceSupport apply(ReferencedProperty prop) {
                if (null == prop.propertyValue) {
                    throw new ResourceNotFoundException();
                }
                if (prop.property.isCollectionLike()) {
                    ArrayList<PersistentEntityResource> resources = new ArrayList<PersistentEntityResource>();
                    for (Object obj : (Iterable)prop.propertyValue) {
                        resources.add(assembler.toResource(obj));
                    }
                    return new Resources(resources, new Link[0]);
                }
                if (prop.property.isMap()) {
                    HashMap resources = new HashMap();
                    for (Map.Entry entry : ((Map)prop.propertyValue).entrySet()) {
                        resources.put(entry.getKey(), assembler.toResource(entry.getValue()));
                    }
                    return new Resource(resources, new Link[0]);
                }
                PersistentEntityResource resource = assembler.toResource(prop.propertyValue);
                headers.set("Content-Location", resource.getId().getHref());
                return resource;
            }
        };
        ResourceSupport responseResource = this.doWithReferencedProperty(repoRequest, id, property, handler, HttpMethod.GET);
        return ControllerUtils.toResponseEntity(HttpStatus.OK, headers, responseResource);
    }

    @RequestMapping(value={"/{repository}/{id}/{property}"}, method={RequestMethod.DELETE})
    public ResponseEntity<? extends ResourceSupport> deletePropertyReference(RootResourceInformation repoRequest, @BackendId Serializable id, @PathVariable String property) throws Exception {
        final RepositoryInvoker repoMethodInvoker = repoRequest.getInvoker();
        Function<ReferencedProperty, ResourceSupport> handler = new Function<ReferencedProperty, ResourceSupport>(){

            public Resource<?> apply(ReferencedProperty prop) throws HttpRequestMethodNotSupportedException {
                if (null == prop.propertyValue) {
                    return null;
                }
                if (prop.property.isCollectionLike()) {
                    throw new HttpRequestMethodNotSupportedException("DELETE");
                }
                if (prop.property.isMap()) {
                    throw new HttpRequestMethodNotSupportedException("DELETE");
                }
                prop.accessor.setProperty(prop.property, null);
                RepositoryPropertyReferenceController.this.publisher.publishEvent((ApplicationEvent)new BeforeLinkDeleteEvent(prop.accessor.getBean(), prop.propertyValue));
                Object result = repoMethodInvoker.invokeSave(prop.accessor.getBean());
                RepositoryPropertyReferenceController.this.publisher.publishEvent((ApplicationEvent)new AfterLinkDeleteEvent(result, prop.propertyValue));
                return null;
            }
        };
        this.doWithReferencedProperty(repoRequest, id, property, handler, HttpMethod.DELETE);
        return ControllerUtils.toEmptyResponse(HttpStatus.NO_CONTENT);
    }

    @RequestMapping(value={"/{repository}/{id}/{property}/{propertyId}"}, method={RequestMethod.GET})
    public ResponseEntity<ResourceSupport> followPropertyReference(RootResourceInformation repoRequest, @BackendId Serializable id, @PathVariable String property, final @PathVariable String propertyId, final PersistentEntityResourceAssembler assembler) throws Exception {
        final HttpHeaders headers = new HttpHeaders();
        Function<ReferencedProperty, ResourceSupport> handler = new Function<ReferencedProperty, ResourceSupport>(){

            public ResourceSupport apply(ReferencedProperty prop) {
                if (null == prop.propertyValue) {
                    throw new ResourceNotFoundException();
                }
                if (prop.property.isCollectionLike()) {
                    for (Object obj : (Iterable)prop.propertyValue) {
                        IdentifierAccessor accessor = prop.entity.getIdentifierAccessor(obj);
                        if (!propertyId.equals(accessor.getIdentifier().toString())) continue;
                        PersistentEntityResource resource = assembler.toResource(obj);
                        headers.set("Content-Location", resource.getId().getHref());
                        return resource;
                    }
                } else if (prop.property.isMap()) {
                    for (Map.Entry entry : ((Map)prop.propertyValue).entrySet()) {
                        IdentifierAccessor accessor = prop.entity.getIdentifierAccessor(entry.getValue());
                        if (!propertyId.equals(accessor.getIdentifier().toString())) continue;
                        PersistentEntityResource resource = assembler.toResource(entry.getValue());
                        headers.set("Content-Location", resource.getId().getHref());
                        return resource;
                    }
                } else {
                    return new Resource(prop.propertyValue, new Link[0]);
                }
                throw new ResourceNotFoundException();
            }
        };
        ResourceSupport responseResource = this.doWithReferencedProperty(repoRequest, id, property, handler, HttpMethod.GET);
        return ControllerUtils.toResponseEntity(HttpStatus.OK, headers, responseResource);
    }

    @RequestMapping(value={"/{repository}/{id}/{property}"}, method={RequestMethod.GET}, produces={"application/x-spring-data-compact+json", "text/uri-list"})
    public ResponseEntity<ResourceSupport> followPropertyReferenceCompact(RootResourceInformation repoRequest, @BackendId Serializable id, @PathVariable String property, PersistentEntityResourceAssembler assembler) throws Exception {
        ResponseEntity<ResourceSupport> response = this.followPropertyReference(repoRequest, id, property, assembler);
        if (response.getStatusCode() != HttpStatus.OK) {
            return response;
        }
        ResourceMetadata repoMapping = repoRequest.getResourceMetadata();
        PersistentProperty persistentProp = repoRequest.getPersistentEntity().getPersistentProperty(property);
        ResourceMapping propertyMapping = repoMapping.getMappingFor(persistentProp);
        ResourceSupport resource = (ResourceSupport)response.getBody();
        ArrayList<Link> links = new ArrayList<Link>();
        ControllerLinkBuilder linkBuilder = ControllerLinkBuilder.linkTo(((RepositoryPropertyReferenceController)ControllerLinkBuilder.methodOn(RepositoryPropertyReferenceController.class, (Object[])new Object[0])).followPropertyReference(repoRequest, id, property, assembler));
        if (resource instanceof Resource) {
            Object content = ((Resource)resource).getContent();
            if (content instanceof Iterable) {
                for (Resource res : (Iterable)content) {
                    links.add(linkBuilder.withRel(propertyMapping.getRel()));
                }
            } else if (content instanceof Map) {
                Map map = (Map)content;
                for (Map.Entry entry : map.entrySet()) {
                    Link l = new Link(((Resource)entry.getValue()).getLink("self").getHref(), entry.getKey().toString());
                    links.add(l);
                }
            }
        } else {
            links.add(linkBuilder.withRel(propertyMapping.getRel()));
        }
        return ControllerUtils.toResponseEntity(HttpStatus.OK, null, new Resource(ControllerUtils.EMPTY_RESOURCE_LIST, links));
    }

    @RequestMapping(value={"/{repository}/{id}/{property}"}, method={RequestMethod.PATCH, RequestMethod.PUT, RequestMethod.POST}, consumes={"application/json", "application/x-spring-data-compact+json", "text/uri-list"})
    public ResponseEntity<? extends ResourceSupport> createPropertyReference(RootResourceInformation resourceInformation, final HttpMethod requestMethod, @RequestBody(required=false) Resources<Object> incoming, @BackendId Serializable id, @PathVariable String property) throws Exception {
        final Resources source = incoming == null ? new Resources(Collections.emptyList(), new Link[0]) : incoming;
        final RepositoryInvoker invoker = resourceInformation.getInvoker();
        Function<ReferencedProperty, ResourceSupport> handler = new Function<ReferencedProperty, ResourceSupport>(){

            public ResourceSupport apply(ReferencedProperty prop) throws HttpRequestMethodNotSupportedException {
                Class propertyType = prop.property.getType();
                if (prop.property.isCollectionLike()) {
                    Collection collection = AUGMENTING_METHODS.contains(requestMethod) ? (Collection)prop.propertyValue : CollectionFactory.createCollection((Class)propertyType, (int)0);
                    for (Link l : source.getLinks()) {
                        collection.add(RepositoryPropertyReferenceController.this.loadPropertyValue(prop.propertyType, l));
                    }
                    prop.accessor.setProperty(prop.property, (Object)collection);
                } else if (prop.property.isMap()) {
                    Map map = AUGMENTING_METHODS.contains(requestMethod) ? (Map)prop.propertyValue : CollectionFactory.createMap((Class)propertyType, (int)0);
                    for (Link l : source.getLinks()) {
                        map.put(l.getRel(), RepositoryPropertyReferenceController.this.loadPropertyValue(prop.propertyType, l));
                    }
                    prop.accessor.setProperty(prop.property, (Object)map);
                } else {
                    if (HttpMethod.PATCH.equals((Object)requestMethod)) {
                        throw new HttpRequestMethodNotSupportedException(HttpMethod.PATCH.name(), new String[]{"PATCH"}, "Cannot PATCH a reference to this singular property since the property type is not a List or a Map.");
                    }
                    if (source.getLinks().size() != 1) {
                        throw new IllegalArgumentException("Must send only 1 link to update a property reference that isn't a List or a Map.");
                    }
                    Object propVal = RepositoryPropertyReferenceController.this.loadPropertyValue(prop.propertyType, (Link)source.getLinks().get(0));
                    prop.accessor.setProperty(prop.property, propVal);
                }
                RepositoryPropertyReferenceController.this.publisher.publishEvent((ApplicationEvent)new BeforeLinkSaveEvent(prop.accessor.getBean(), prop.propertyValue));
                Object result = invoker.invokeSave(prop.accessor.getBean());
                RepositoryPropertyReferenceController.this.publisher.publishEvent((ApplicationEvent)new AfterLinkSaveEvent(result, prop.propertyValue));
                return null;
            }
        };
        this.doWithReferencedProperty(resourceInformation, id, property, handler, requestMethod);
        return ControllerUtils.toEmptyResponse(HttpStatus.NO_CONTENT);
    }

    @RequestMapping(value={"/{repository}/{id}/{property}/{propertyId}"}, method={RequestMethod.DELETE})
    public ResponseEntity<ResourceSupport> deletePropertyReferenceId(RootResourceInformation repoRequest, @BackendId Serializable id, @PathVariable String property, final @PathVariable String propertyId) throws Exception {
        final RepositoryInvoker invoker = repoRequest.getInvoker();
        Function<ReferencedProperty, ResourceSupport> handler = new Function<ReferencedProperty, ResourceSupport>(){

            public ResourceSupport apply(ReferencedProperty prop) {
                if (null == prop.propertyValue) {
                    return null;
                }
                if (prop.property.isCollectionLike()) {
                    Collection coll = (Collection)prop.propertyValue;
                    Iterator itr = coll.iterator();
                    while (itr.hasNext()) {
                        Object obj = itr.next();
                        IdentifierAccessor accessor = prop.entity.getIdentifierAccessor(obj);
                        String s = accessor.getIdentifier().toString();
                        if (!propertyId.equals(s)) continue;
                        itr.remove();
                    }
                } else if (prop.property.isMap()) {
                    Map m = (Map)prop.propertyValue;
                    Iterator itr = m.keySet().iterator();
                    while (itr.hasNext()) {
                        Object key = itr.next();
                        IdentifierAccessor accessor = prop.entity.getIdentifierAccessor(m.get(key));
                        String s = accessor.getIdentifier().toString();
                        if (!propertyId.equals(s)) continue;
                        itr.remove();
                    }
                } else {
                    prop.accessor.setProperty(prop.property, null);
                }
                RepositoryPropertyReferenceController.this.publisher.publishEvent((ApplicationEvent)new BeforeLinkDeleteEvent(prop.accessor.getBean(), prop.propertyValue));
                Object result = invoker.invokeSave(prop.accessor.getBean());
                RepositoryPropertyReferenceController.this.publisher.publishEvent((ApplicationEvent)new AfterLinkDeleteEvent(result, prop.propertyValue));
                return null;
            }
        };
        this.doWithReferencedProperty(repoRequest, id, property, handler, HttpMethod.DELETE);
        return ControllerUtils.toEmptyResponse(HttpStatus.NO_CONTENT);
    }

    private Object loadPropertyValue(Class<?> type, Link link) {
        String href = link.expand(new Object[0]).getHref();
        String id = href.substring(href.lastIndexOf(47) + 1);
        return this.conversionService.convert((Object)id, type);
    }

    private ResourceSupport doWithReferencedProperty(RootResourceInformation resourceInformation, Serializable id, String propertyPath, Function<ReferencedProperty, ResourceSupport> handler, HttpMethod method) throws Exception {
        ResourceMetadata metadata = resourceInformation.getResourceMetadata();
        PropertyDetector detector = new PropertyDetector(metadata, propertyPath);
        resourceInformation.getPersistentEntity().doWithAssociations((SimpleAssociationHandler)detector);
        if (detector.mapping == null || !detector.mapping.isExported()) {
            throw new ResourceNotFoundException();
        }
        PersistentProperty<?> property = detector.property;
        resourceInformation.verifySupportedMethod(method, property);
        RepositoryInvoker invoker = resourceInformation.getInvoker();
        Object domainObj = invoker.invokeFindOne(id);
        if (null == domainObj) {
            throw new ResourceNotFoundException();
        }
        PersistentPropertyAccessor accessor = property.getOwner().getPropertyAccessor(domainObj);
        return (ResourceSupport)handler.apply((Object)new ReferencedProperty(property, accessor.getProperty(property), accessor));
    }

    private static class PropertyDetector
    implements SimpleAssociationHandler {
        private final ResourceMetadata metadata;
        private final String path;
        PersistentProperty<?> property;
        ResourceMapping mapping;

        public PropertyDetector(ResourceMetadata metadata, String path) {
            this.metadata = metadata;
            this.path = path;
        }

        public void doWithAssociation(Association<? extends PersistentProperty<?>> association) {
            if (this.property != null) {
                return;
            }
            PersistentProperty property = association.getInverse();
            ResourceMapping propertyMapping = this.metadata.getMappingFor(property);
            if (propertyMapping != null && propertyMapping.getPath().matches(this.path)) {
                this.property = property;
                this.mapping = propertyMapping;
            }
        }
    }

    private class ReferencedProperty {
        final PersistentEntity<?, ?> entity;
        final PersistentProperty<?> property;
        final Class<?> propertyType;
        final Object propertyValue;
        final PersistentPropertyAccessor accessor;

        private ReferencedProperty(PersistentProperty<?> property, Object propertyValue, PersistentPropertyAccessor wrapper) {
            this.property = property;
            this.propertyValue = propertyValue;
            this.accessor = wrapper;
            this.propertyType = property.getActualType();
            this.entity = RepositoryPropertyReferenceController.this.repositories.getPersistentEntity(this.propertyType);
        }
    }
}

