/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc.support;

import org.springframework.data.rest.core.mapping.ResourceMappings;
import org.springframework.data.rest.core.mapping.ResourceMetadata;
import org.springframework.data.rest.core.projection.ProjectionDefinitions;
import org.springframework.data.rest.core.projection.ProjectionFactory;
import org.springframework.data.rest.webmvc.support.Projector;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class PersistentEntityProjector
implements Projector {
    private final ProjectionDefinitions projectionDefinitions;
    private final ProjectionFactory factory;
    private final String projection;
    private final ResourceMappings mappings;

    public PersistentEntityProjector(ProjectionDefinitions projectionDefinitions, ProjectionFactory factory, String projection, ResourceMappings mappings) {
        Assert.notNull((Object)projectionDefinitions, (String)"ProjectionDefinitions must not be null!");
        Assert.notNull((Object)factory, (String)"ProjectionFactory must not be null!");
        this.projectionDefinitions = projectionDefinitions;
        this.factory = factory;
        this.projection = projection;
        this.mappings = mappings;
    }

    @Override
    public Object project(Object source) {
        Assert.notNull((Object)source, (String)"Projection source must not be null!");
        if (!StringUtils.hasText((String)this.projection)) {
            return source;
        }
        Class projectionType = this.projectionDefinitions.getProjectionType(source.getClass(), this.projection);
        return projectionType == null ? source : this.factory.createProjection(source, projectionType);
    }

    @Override
    public Object projectExcerpt(Object source) {
        Class projection;
        Assert.notNull((Object)source, (String)"Projection source must not be null!");
        ResourceMetadata metadata = this.mappings.getMappingFor(source.getClass());
        Class clazz = projection = metadata == null ? null : metadata.getExcerptProjection();
        if (projection == null) {
            return this.project(source);
        }
        return projection == null ? source : this.factory.createProjection(source, projection);
    }

    @Override
    public boolean hasExcerptProjection(Class<?> type) {
        ResourceMetadata metadata = this.mappings.getMappingFor(type);
        return metadata == null ? false : metadata.getExcerptProjection() != null;
    }
}

