/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc.mapping;

import java.util.ArrayList;
import java.util.List;
import org.springframework.data.mapping.Association;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.SimpleAssociationHandler;
import org.springframework.data.mapping.context.PersistentEntities;
import org.springframework.data.mapping.model.MappingException;
import org.springframework.data.rest.core.Path;
import org.springframework.data.rest.webmvc.mapping.AssociationLinks;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.Links;
import org.springframework.util.Assert;

public class LinkCollectingAssociationHandler
implements SimpleAssociationHandler {
    private static final String AMBIGUOUS_ASSOCIATIONS = "Detected multiple association links with same relation type! Disambiguate association %s using @RestResource!";
    private final PersistentEntities entities;
    private final AssociationLinks associationLinks;
    private final Path basePath;
    private final List<Link> links;

    public LinkCollectingAssociationHandler(PersistentEntities entities, Path path, AssociationLinks associationLinks) {
        Assert.notNull((Object)entities, (String)"PersistentEntities must not be null!");
        Assert.notNull((Object)path, (String)"Path must not be null!");
        Assert.notNull((Object)associationLinks, (String)"AssociationLinks must not be null!");
        this.entities = entities;
        this.associationLinks = associationLinks;
        this.basePath = path;
        this.links = new ArrayList<Link>();
    }

    public List<Link> getLinks() {
        return this.links;
    }

    public void doWithAssociation(Association<? extends PersistentProperty<?>> association) {
        PersistentProperty property = association.getInverse();
        if (this.associationLinks.isLinkableAssociation(property)) {
            Links existingLinks = new Links(this.links);
            for (Link link : this.associationLinks.getLinksFor(association, this.basePath)) {
                if (existingLinks.hasLink(link.getRel())) {
                    throw new MappingException(String.format(AMBIGUOUS_ASSOCIATIONS, property.toString()));
                }
                this.links.add(link);
            }
        } else {
            PersistentEntity associationEntity = this.entities.getPersistentEntity(property.getActualType());
            associationEntity.doWithAssociations((SimpleAssociationHandler)this);
        }
    }
}

