/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc.util;

import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.core.MethodParameter;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.util.UriTemplate;
import org.springframework.web.util.UrlPathHelper;

public abstract class UriUtils {
    private static final UrlPathHelper URL_PATH_HELPER = new UrlPathHelper();

    private UriUtils() {
    }

    public static String findMappingVariable(String variable, MethodParameter parameter, NativeWebRequest request) {
        Assert.hasText((String)variable, (String)"Variable name must not be null or empty!");
        Assert.notNull((Object)parameter, (String)"Method parameter must not be null!");
        Assert.notNull((Object)request, (String)"Request must not be null!");
        String lookupPath = UriUtils.getCleanLookupPath(request);
        RequestMapping annotation = (RequestMapping)parameter.getMethodAnnotation(RequestMapping.class);
        for (String mapping : annotation.value()) {
            Map variables = new UriTemplate(mapping).match(lookupPath);
            String value = (String)variables.get(variable);
            if (value == null) continue;
            return value;
        }
        return null;
    }

    private static String getCleanLookupPath(NativeWebRequest request) {
        HttpServletRequest httpServletRequest = (HttpServletRequest)request.getNativeRequest(HttpServletRequest.class);
        String lookupPath = URL_PATH_HELPER.getLookupPathForRequest(httpServletRequest);
        return new org.springframework.hateoas.UriTemplate(lookupPath).expand(new Object[0]).toString();
    }
}

