/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc;

import javax.servlet.http.HttpServletRequest;
import org.springframework.core.MethodParameter;
import org.springframework.data.repository.core.RepositoryInformation;
import org.springframework.data.repository.support.Repositories;
import org.springframework.data.rest.core.mapping.ResourceMappings;
import org.springframework.data.rest.core.mapping.ResourceMetadata;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.method.support.ModelAndViewContainer;
import org.springframework.web.util.UrlPathHelper;

public class ResourceMetadataHandlerMethodArgumentResolver
implements HandlerMethodArgumentResolver {
    private final Repositories repositories;
    private final ResourceMappings mappings;

    public ResourceMetadataHandlerMethodArgumentResolver(Repositories repositories, ResourceMappings mappings) {
        Assert.notNull((Object)repositories, (String)"Repositories must not be null!");
        Assert.notNull((Object)mappings, (String)"ResourceMappings must not be null!");
        this.repositories = repositories;
        this.mappings = mappings;
    }

    public boolean supportsParameter(MethodParameter parameter) {
        return ClassUtils.isAssignable((Class)parameter.getParameterType(), RepositoryInformation.class);
    }

    public ResourceMetadata resolveArgument(MethodParameter parameter, ModelAndViewContainer mavContainer, NativeWebRequest webRequest, WebDataBinderFactory binderFactory) throws Exception {
        String[] parts;
        HttpServletRequest request = (HttpServletRequest)webRequest.getNativeRequest(HttpServletRequest.class);
        String requestUri = new UrlPathHelper().getLookupPathForRequest(request);
        if (requestUri.startsWith("/")) {
            requestUri = requestUri.substring(1);
        }
        if ((parts = requestUri.split("/")).length == 0) {
            return null;
        }
        return this.findRepositoryInfoFor(parts[0]);
    }

    private ResourceMetadata findRepositoryInfoFor(String pathSegment) {
        if (!StringUtils.hasText((String)pathSegment)) {
            return null;
        }
        for (Class domainType : this.repositories) {
            ResourceMetadata mapping = this.mappings.getMappingFor(domainType);
            if (!mapping.getPath().matches(pathSegment) || !mapping.isExported()) continue;
            return mapping;
        }
        return null;
    }
}

