/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc;

import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.model.BeanWrapper;
import org.springframework.data.repository.support.Repositories;
import org.springframework.data.rest.webmvc.PersistentEntityResource;
import org.springframework.hateoas.EntityLinks;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.ResourceAssembler;
import org.springframework.util.Assert;

public class PersistentEntityResourceAssembler<T>
implements ResourceAssembler<T, PersistentEntityResource<T>> {
    private final Repositories repositories;
    private final EntityLinks entityLinks;

    public PersistentEntityResourceAssembler(Repositories repositories, EntityLinks entityLinks) {
        Assert.notNull((Object)repositories, (String)"Repositories must not be null!");
        Assert.notNull((Object)entityLinks, (String)"EntityLinks must not be null!");
        this.repositories = repositories;
        this.entityLinks = entityLinks;
    }

    public PersistentEntityResource<T> toResource(T instance) {
        PersistentEntity entity = this.repositories.getPersistentEntity(instance.getClass());
        PersistentEntityResource<T> resource = PersistentEntityResource.wrap(entity, instance);
        resource.add(this.getSelfLinkFor(instance));
        return resource;
    }

    public Link getSelfLinkFor(Object instance) {
        PersistentEntity entity = this.repositories.getPersistentEntity(instance.getClass());
        BeanWrapper wrapper = BeanWrapper.create((Object)instance, null);
        Object id = wrapper.getProperty(entity.getIdProperty());
        return this.entityLinks.linkForSingleResource(entity.getType(), id).withSelfRel();
    }
}

