/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc;

import java.net.URI;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.MethodParameter;
import org.springframework.data.rest.webmvc.RepositoryRestConfiguration;
import org.springframework.data.rest.webmvc.RepositoryRestController;
import org.springframework.data.rest.webmvc.json.JsonSchemaController;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.method.support.ModelAndViewContainer;
import org.springframework.web.servlet.support.ServletUriComponentsBuilder;

public class BaseUriMethodArgumentResolver
implements HandlerMethodArgumentResolver {
    @Autowired(required=false)
    private RepositoryRestConfiguration config = RepositoryRestConfiguration.DEFAULT;

    public boolean supportsParameter(MethodParameter parameter) {
        return (RepositoryRestController.class.isAssignableFrom(parameter.getDeclaringClass()) || JsonSchemaController.class.isAssignableFrom(parameter.getDeclaringClass())) && parameter.getParameterType() == URI.class;
    }

    public Object resolveArgument(MethodParameter parameter, ModelAndViewContainer mavContainer, NativeWebRequest webRequest, WebDataBinderFactory binderFactory) throws Exception {
        HttpServletRequest servletRequest = (HttpServletRequest)webRequest.getNativeRequest(HttpServletRequest.class);
        if (null == this.config.getBaseUri()) {
            URI baseUri = ServletUriComponentsBuilder.fromServletMapping((HttpServletRequest)servletRequest).build().toUri();
            this.config.setBaseUri(baseUri);
        }
        return this.config.getBaseUri();
    }
}

