/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.relational.core.sql.render;

import java.util.function.Predicate;
import org.jspecify.annotations.Nullable;
import org.springframework.data.relational.core.sql.Visitable;
import org.springframework.data.relational.core.sql.render.DelegatingVisitor;

abstract class FilteredSubtreeVisitor
extends DelegatingVisitor {
    private final Predicate<Visitable> filter;
    private @Nullable Visitable currentSegment;

    FilteredSubtreeVisitor(Predicate<Visitable> filter) {
        this.filter = filter;
    }

    DelegatingVisitor.Delegation enterMatched(Visitable segment) {
        return DelegatingVisitor.Delegation.retain();
    }

    DelegatingVisitor.Delegation enterNested(Visitable segment) {
        return DelegatingVisitor.Delegation.retain();
    }

    DelegatingVisitor.Delegation leaveMatched(Visitable segment) {
        return DelegatingVisitor.Delegation.leave();
    }

    DelegatingVisitor.Delegation leaveNested(Visitable segment) {
        return DelegatingVisitor.Delegation.retain();
    }

    @Override
    public final DelegatingVisitor.Delegation doEnter(Visitable segment) {
        if (this.currentSegment == null) {
            if (this.filter.test(segment)) {
                this.currentSegment = segment;
                return this.enterMatched(segment);
            }
        } else {
            return this.enterNested(segment);
        }
        return DelegatingVisitor.Delegation.retain();
    }

    @Override
    public final DelegatingVisitor.Delegation doLeave(Visitable segment) {
        if (this.currentSegment == null) {
            return DelegatingVisitor.Delegation.leave();
        }
        if (segment == this.currentSegment) {
            this.currentSegment = null;
            return this.leaveMatched(segment);
        }
        return this.leaveNested(segment);
    }
}

