/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.relational.core.mapping;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BinaryOperator;
import java.util.function.Predicate;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.springframework.data.mapping.PersistentPropertyPath;
import org.springframework.data.relational.core.mapping.AggregatePathTableUtils;
import org.springframework.data.relational.core.mapping.AggregatePathTraversal;
import org.springframework.data.relational.core.mapping.ColumInfosBuilder;
import org.springframework.data.relational.core.mapping.RelationalPersistentEntity;
import org.springframework.data.relational.core.mapping.RelationalPersistentProperty;
import org.springframework.data.relational.core.sql.Column;
import org.springframework.data.relational.core.sql.SqlIdentifier;
import org.springframework.data.relational.core.sql.Table;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public interface AggregatePath
extends Iterable<AggregatePath>,
Comparable<AggregatePath> {
    public AggregatePath getParentPath();

    public AggregatePath append(RelationalPersistentProperty var1);

    public AggregatePath append(AggregatePath var1);

    public boolean isRoot();

    default public int getLength() {
        return 1 + (this.isRoot() ? 0 : this.getRequiredPersistentPropertyPath().getLength());
    }

    public boolean isWritable();

    public boolean isEntity();

    public boolean isEmbedded();

    public boolean isMultiValued();

    public boolean isQualified();

    public boolean isMap();

    public boolean isCollectionLike();

    public boolean isOrdered();

    public boolean hasIdProperty();

    public RelationalPersistentProperty getRequiredIdProperty();

    public PersistentPropertyPath<RelationalPersistentProperty> getRequiredPersistentPropertyPath();

    default public RelationalPersistentProperty getRequiredBaseProperty() {
        return (RelationalPersistentProperty)this.getRequiredPersistentPropertyPath().getBaseProperty();
    }

    default public RelationalPersistentProperty getRequiredLeafProperty() {
        return (RelationalPersistentProperty)this.getRequiredPersistentPropertyPath().getLeafProperty();
    }

    @Nullable
    public RelationalPersistentEntity<?> getLeafEntity();

    default public RelationalPersistentEntity<?> getRequiredLeafEntity() {
        RelationalPersistentEntity<?> entity = this.getLeafEntity();
        if (entity == null) {
            throw new IllegalStateException(String.format("Couldn't resolve leaf PersistentEntity for type %s", this.getRequiredLeafProperty().getActualType()));
        }
        return entity;
    }

    public String toDotPath();

    default public TableInfo getTableInfo() {
        return TableInfo.of(this);
    }

    default public ColumnInfo getColumnInfo() {
        return ColumnInfo.of(this);
    }

    @Nullable
    default public AggregatePath filter(Predicate<? super AggregatePath> predicate) {
        for (AggregatePath item : this) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    default public Stream<AggregatePath> stream() {
        return StreamSupport.stream(this.spliterator(), false);
    }

    public AggregatePath getIdDefiningParentPath();

    @Nullable
    public AggregatePath getTail();

    @Nullable
    public AggregatePath subtract(@Nullable AggregatePath var1);

    @Override
    default public int compareTo(AggregatePath other) {
        return this.toDotPath().compareTo(other.toDotPath());
    }

    public AggregatePath getSubPathBasedOn(Class<?> var1);

    public record TableInfo(SqlIdentifier qualifiedTableName, @Nullable SqlIdentifier tableAlias, ColumnInfos backReferenceColumnInfos, @Nullable ColumnInfo qualifierColumnInfo, @Nullable Class<?> qualifierColumnType, ColumnInfos idColumnInfos) {
        static TableInfo of(AggregatePath path) {
            SqlIdentifier keyColumn;
            AggregatePath tableOwner = AggregatePathTraversal.getTableOwningPath(path);
            RelationalPersistentEntity<?> leafEntity = tableOwner.getRequiredLeafEntity();
            SqlIdentifier qualifiedTableName = leafEntity.getQualifiedTableName();
            SqlIdentifier tableAlias = tableOwner.isRoot() ? null : AggregatePathTableUtils.constructTableAlias(tableOwner);
            ColumnInfos backReferenceColumnInfos = TableInfo.computeBackReferenceColumnInfos(path);
            ColumnInfo qualifierColumnInfo = null;
            if (!path.isRoot() && (keyColumn = path.getRequiredLeafProperty().getKeyColumn()) != null) {
                qualifierColumnInfo = new ColumnInfo(keyColumn, keyColumn);
            }
            Class<?> qualifierColumnType = null;
            if (!path.isRoot() && path.getRequiredLeafProperty().isQualified()) {
                qualifierColumnType = path.getRequiredLeafProperty().getQualifierColumnType();
            }
            ColumnInfos idColumnInfos = TableInfo.computeIdColumnInfos(tableOwner, leafEntity);
            return new TableInfo(qualifiedTableName, tableAlias, backReferenceColumnInfos, qualifierColumnInfo, qualifierColumnType, idColumnInfos);
        }

        private static ColumnInfos computeIdColumnInfos(AggregatePath tableOwner, RelationalPersistentEntity<?> leafEntity) {
            ColumnInfos idColumnInfos = ColumnInfos.empty();
            if (!leafEntity.hasIdProperty()) {
                return idColumnInfos;
            }
            RelationalPersistentProperty idProperty = (RelationalPersistentProperty)leafEntity.getRequiredIdProperty();
            AggregatePath idPath = tableOwner.append(idProperty);
            if (idProperty.isEntity()) {
                ColumInfosBuilder ciBuilder = new ColumInfosBuilder(idPath);
                idPath.getRequiredLeafEntity().doWithProperties(p -> {
                    AggregatePath idElementPath = idPath.append((RelationalPersistentProperty)p);
                    ciBuilder.add(idElementPath, ColumnInfo.of(idElementPath));
                });
                return ciBuilder.build();
            }
            ColumInfosBuilder ciBuilder = new ColumInfosBuilder(idPath.getParentPath());
            ciBuilder.add(idPath, ColumnInfo.of(idPath));
            return ciBuilder.build();
        }

        private static ColumnInfos computeBackReferenceColumnInfos(AggregatePath path) {
            AggregatePath tableOwner = AggregatePathTraversal.getTableOwningPath(path);
            if (tableOwner.isRoot()) {
                return ColumnInfos.empty();
            }
            AggregatePath idDefiningParentPath = tableOwner.getIdDefiningParentPath();
            RelationalPersistentProperty idProperty = (RelationalPersistentProperty)idDefiningParentPath.getRequiredLeafEntity().getIdProperty();
            AggregatePath basePath = idProperty != null && idProperty.isEntity() ? idDefiningParentPath.append(idProperty) : idDefiningParentPath;
            ColumInfosBuilder ciBuilder = new ColumInfosBuilder(basePath);
            if (idProperty != null && idProperty.isEntity()) {
                RelationalPersistentEntity<?> idEntity = basePath.getRequiredLeafEntity();
                idEntity.doWithProperties(p -> {
                    AggregatePath idElementPath = basePath.append((RelationalPersistentProperty)p);
                    SqlIdentifier name = idElementPath.getColumnInfo().name();
                    name = name.transform(n -> idDefiningParentPath.getTableInfo().qualifiedTableName.getReference() + "_" + n);
                    ciBuilder.add(idElementPath, name, name);
                });
            } else {
                RelationalPersistentProperty leafProperty = tableOwner.getRequiredLeafProperty();
                SqlIdentifier reverseColumnName = leafProperty.getReverseColumnName(idDefiningParentPath.getRequiredLeafEntity());
                SqlIdentifier alias = AggregatePathTableUtils.prefixWithTableAlias(path, reverseColumnName);
                if (idProperty != null) {
                    ciBuilder.add(idProperty, reverseColumnName, alias);
                } else {
                    ciBuilder.add(idDefiningParentPath, reverseColumnName, alias);
                }
            }
            return ciBuilder.build();
        }

        @Deprecated(forRemoval=true)
        public ColumnInfo reverseColumnInfo() {
            return this.backReferenceColumnInfos.unique();
        }

        public ColumnInfos effectiveIdColumnInfos() {
            return this.backReferenceColumnInfos.isEmpty() ? this.idColumnInfos : this.backReferenceColumnInfos;
        }
    }

    public record ColumnInfo(SqlIdentifier name, SqlIdentifier alias) {
        static ColumnInfo of(AggregatePath path) {
            Assert.notNull((Object)path, (String)"AggregatePath must not be null");
            Assert.isTrue((!path.isRoot() ? 1 : 0) != 0, () -> "Cannot obtain ColumnInfo for root path");
            Assert.isTrue((!path.isEmbedded() ? 1 : 0) != 0, () -> "Cannot obtain ColumnInfo for embedded path");
            SqlIdentifier columnName = path.getRequiredLeafProperty().getColumnName();
            return new ColumnInfo(columnName, AggregatePathTableUtils.prefixWithTableAlias(path, columnName));
        }
    }

    public static class ColumnInfos {
        private final Map<AggregatePath, ColumnInfo> columnInfos = new TreeMap<AggregatePath, ColumnInfo>();
        private final Map<Table, List<Column>> columnCache;

        ColumnInfos(Map<AggregatePath, ColumnInfo> columnInfos) {
            this.columnInfos.putAll(columnInfos);
            this.columnCache = new HashMap<Table, List<Column>>(columnInfos.size(), 1.0f);
        }

        public static ColumnInfos empty() {
            return new ColumnInfos(new HashMap<AggregatePath, ColumnInfo>());
        }

        public ColumnInfo unique() {
            Collection<ColumnInfo> values = this.columnInfos.values();
            Assert.state((values.size() == 1 ? 1 : 0) != 0, (String)"ColumnInfo is not unique");
            return values.iterator().next();
        }

        public ColumnInfo any() {
            Collection<ColumnInfo> values = this.columnInfos.values();
            return values.iterator().next();
        }

        public Map<AggregatePath, Column> toMap(Table table) {
            TreeMap<AggregatePath, Column> columns = new TreeMap<AggregatePath, Column>();
            this.columnInfos.forEach((? super K ag, ? super V ci) -> columns.put((AggregatePath)ag, table.column(ci.name())));
            return columns;
        }

        public List<Column> toColumnList(Table table) {
            return this.columnCache.computeIfAbsent(table, t -> this.toColumnList((AggregatePath __, ColumnInfo ci) -> t.column(ci.name)));
        }

        public List<Column> toColumnList(BiFunction<AggregatePath, ColumnInfo, Column> mappingFunction) {
            ArrayList<Column> result = new ArrayList<Column>(this.columnInfos.size());
            this.columnInfos.forEach((? super K ap, ? super V ci) -> result.add((Column)mappingFunction.apply((AggregatePath)ap, (ColumnInfo)ci)));
            return result;
        }

        public <T> T reduce(T identity, BiFunction<AggregatePath, ColumnInfo, T> accumulator, BinaryOperator<T> combiner) {
            Object result = identity;
            for (Map.Entry<AggregatePath, ColumnInfo> entry : this.columnInfos.entrySet()) {
                T mapped = accumulator.apply(entry.getKey(), entry.getValue());
                result = combiner.apply(result, mapped);
            }
            return result;
        }

        public void forEach(BiConsumer<AggregatePath, ColumnInfo> consumer) {
            this.columnInfos.forEach(consumer);
        }

        public <T> T any(BiFunction<AggregatePath, ColumnInfo, T> mapper) {
            Map.Entry<AggregatePath, ColumnInfo> any = this.columnInfos.entrySet().iterator().next();
            return mapper.apply(any.getKey(), any.getValue());
        }

        public ColumnInfo get(AggregatePath path) {
            return this.columnInfos.get(path);
        }

        public Iterable<AggregatePath> paths() {
            return this.columnInfos.keySet();
        }

        public boolean isEmpty() {
            return this.columnInfos.isEmpty();
        }

        public int size() {
            return this.columnInfos.size();
        }
    }
}

