/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.relational.core.sql.render;

import org.springframework.data.relational.core.sql.Between;
import org.springframework.data.relational.core.sql.Condition;
import org.springframework.data.relational.core.sql.Expression;
import org.springframework.data.relational.core.sql.Visitable;
import org.springframework.data.relational.core.sql.render.ConditionVisitor;
import org.springframework.data.relational.core.sql.render.DelegatingVisitor;
import org.springframework.data.relational.core.sql.render.ExpressionVisitor;
import org.springframework.data.relational.core.sql.render.FilteredSubtreeVisitor;
import org.springframework.data.relational.core.sql.render.PartRenderer;
import org.springframework.data.relational.core.sql.render.RenderContext;
import org.springframework.data.relational.core.sql.render.RenderTarget;
import org.springframework.lang.Nullable;

class BetweenVisitor
extends FilteredSubtreeVisitor {
    private final Between between;
    private final RenderContext context;
    private final RenderTarget target;
    private final StringBuilder part = new StringBuilder();
    private boolean renderedTestExpression = false;
    private boolean renderedPreamble = false;
    private boolean done = false;
    @Nullable
    private PartRenderer current;

    BetweenVisitor(Between condition, RenderContext context, RenderTarget target) {
        super(it -> it == condition);
        this.between = condition;
        this.context = context;
        this.target = target;
    }

    @Override
    DelegatingVisitor.Delegation enterNested(Visitable segment) {
        if (segment instanceof Expression) {
            ExpressionVisitor visitor = new ExpressionVisitor(this.context);
            this.current = visitor;
            return DelegatingVisitor.Delegation.delegateTo(visitor);
        }
        if (segment instanceof Condition) {
            ConditionVisitor visitor = new ConditionVisitor(this.context);
            this.current = visitor;
            return DelegatingVisitor.Delegation.delegateTo(visitor);
        }
        throw new IllegalStateException("Cannot provide visitor for " + String.valueOf(segment));
    }

    @Override
    DelegatingVisitor.Delegation leaveNested(Visitable segment) {
        if (this.current != null && !this.done) {
            if (this.renderedPreamble) {
                this.part.append(" AND ");
                this.part.append(this.current.getRenderedPart());
                this.done = true;
            }
            if (this.renderedTestExpression && !this.renderedPreamble) {
                this.part.append(' ');
                if (this.between.isNegated()) {
                    this.part.append("NOT ");
                }
                this.part.append("BETWEEN ");
                this.renderedPreamble = true;
                this.part.append(this.current.getRenderedPart());
            }
            if (!this.renderedTestExpression) {
                this.part.append(this.current.getRenderedPart());
                this.renderedTestExpression = true;
            }
            this.current = null;
        }
        return super.leaveNested(segment);
    }

    @Override
    DelegatingVisitor.Delegation leaveMatched(Visitable segment) {
        this.target.onRendered(this.part);
        return super.leaveMatched(segment);
    }
}

