/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.relational.core.mapping;

import org.springframework.data.relational.core.mapping.ForeignKeyNaming;
import org.springframework.data.relational.core.mapping.NamingStrategy;
import org.springframework.data.relational.core.mapping.RelationalPersistentEntity;
import org.springframework.data.relational.core.mapping.RelationalPersistentProperty;
import org.springframework.util.Assert;

public class DefaultNamingStrategy
implements NamingStrategy {
    public static NamingStrategy INSTANCE = new DefaultNamingStrategy(){

        @Override
        public void setForeignKeyNaming(ForeignKeyNaming foreignKeyNaming) {
            throw new UnsupportedOperationException("Cannot update immutable DefaultNamingStrategy");
        }
    };
    private ForeignKeyNaming foreignKeyNaming = ForeignKeyNaming.APPLY_RENAMING;

    public void setForeignKeyNaming(ForeignKeyNaming foreignKeyNaming) {
        Assert.notNull((Object)((Object)foreignKeyNaming), (String)"foreignKeyNaming must not be null");
        this.foreignKeyNaming = foreignKeyNaming;
    }

    @Override
    public String getReverseColumnName(RelationalPersistentProperty property) {
        return this.getColumnNameReferencing(property.getOwner());
    }

    @Override
    public String getReverseColumnName(RelationalPersistentEntity<?> parent) {
        return this.getColumnNameReferencing(parent);
    }

    private String getColumnNameReferencing(RelationalPersistentEntity<?> entity) {
        if (this.foreignKeyNaming == ForeignKeyNaming.IGNORE_RENAMING) {
            return this.getTableName(entity.getType());
        }
        return entity.getTableName().getReference();
    }
}

