/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.relational.core.dialect;

import org.springframework.data.relational.core.sql.IdentifierProcessing;
import org.springframework.data.relational.core.sql.SqlIdentifier;

public interface IdGeneration {
    public static final IdGeneration DEFAULT = new IdGeneration(){};

    public static IdGeneration create(final IdentifierProcessing identifierProcessing) {
        return new IdGeneration(){

            @Override
            public String createSequenceQuery(SqlIdentifier sequenceName) {
                return IdGeneration.createSequenceQuery(sequenceName.toSql(identifierProcessing));
            }
        };
    }

    default public boolean driverRequiresKeyColumnNames() {
        return false;
    }

    default public String getKeyColumnName(SqlIdentifier id) {
        return id.getReference();
    }

    default public boolean supportedForBatchOperations() {
        return true;
    }

    default public boolean sequencesSupported() {
        return true;
    }

    default public String createSequenceQuery(SqlIdentifier sequenceName) {
        String nameString = sequenceName.toString();
        return IdGeneration.createSequenceQuery(nameString);
    }

    public static String createSequenceQuery(String nameString) {
        return "SELECT NEXT VALUE FOR " + nameString;
    }
}

