/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.relational.core.sqlgeneration;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.PersistentPropertyPath;
import org.springframework.data.mapping.PersistentPropertyPaths;
import org.springframework.data.relational.core.dialect.Dialect;
import org.springframework.data.relational.core.dialect.RenderContextFactory;
import org.springframework.data.relational.core.mapping.AggregatePath;
import org.springframework.data.relational.core.mapping.RelationalMappingContext;
import org.springframework.data.relational.core.mapping.RelationalPersistentEntity;
import org.springframework.data.relational.core.mapping.RelationalPersistentProperty;
import org.springframework.data.relational.core.sql.AbstractSegment;
import org.springframework.data.relational.core.sql.AliasedExpression;
import org.springframework.data.relational.core.sql.AnalyticFunction;
import org.springframework.data.relational.core.sql.Comparison;
import org.springframework.data.relational.core.sql.Condition;
import org.springframework.data.relational.core.sql.Conditions;
import org.springframework.data.relational.core.sql.Expression;
import org.springframework.data.relational.core.sql.Expressions;
import org.springframework.data.relational.core.sql.Functions;
import org.springframework.data.relational.core.sql.InlineQuery;
import org.springframework.data.relational.core.sql.SQL;
import org.springframework.data.relational.core.sql.Select;
import org.springframework.data.relational.core.sql.SelectBuilder;
import org.springframework.data.relational.core.sql.SimpleFunction;
import org.springframework.data.relational.core.sql.StatementBuilder;
import org.springframework.data.relational.core.sql.Table;
import org.springframework.data.relational.core.sql.TableLike;
import org.springframework.data.relational.core.sql.render.SqlRenderer;
import org.springframework.data.relational.core.sqlgeneration.AliasFactory;
import org.springframework.data.relational.core.sqlgeneration.SqlGenerator;
import org.springframework.lang.Nullable;

public class SingleQuerySqlGenerator
implements SqlGenerator {
    private final RelationalMappingContext context;
    private final Dialect dialect;
    private final AliasFactory aliases;

    public SingleQuerySqlGenerator(RelationalMappingContext context, AliasFactory aliasFactory, Dialect dialect) {
        this.context = context;
        this.aliases = aliasFactory;
        this.dialect = dialect;
    }

    @Override
    public String findAll(RelationalPersistentEntity<?> aggregate, @Nullable Condition condition) {
        return this.createSelect(aggregate, condition);
    }

    String createSelect(RelationalPersistentEntity<?> aggregate, @Nullable Condition condition) {
        AggregatePath rootPath = this.context.getAggregatePath(aggregate);
        QueryMeta queryMeta = this.createInlineQuery(rootPath, condition);
        InlineQuery rootQuery = queryMeta.inlineQuery;
        ArrayList<Expression> columns = new ArrayList<Expression>(queryMeta.selectableExpressions);
        ArrayList<Expression> rownumbers = new ArrayList<Expression>();
        rownumbers.add(queryMeta.rowNumber);
        PersistentPropertyPaths entityPaths = this.context.findPersistentPropertyPaths(aggregate.getType(), PersistentProperty::isEntity);
        List<QueryMeta> inlineQueries = this.createInlineQueries(entityPaths);
        inlineQueries.forEach(qm -> {
            columns.addAll(qm.selectableExpressions);
            rownumbers.add(qm.rowNumber);
        });
        AbstractSegment totalRownumber = rownumbers.size() > 1 ? SingleQuerySqlGenerator.greatest(rownumbers).as("rn") : new AliasedExpression((Expression)rownumbers.get(0), "rn");
        columns.add((Expression)((Object)totalRownumber));
        InlineQuery inlineQuery = this.createMainSelect(columns, rootPath, rootQuery, inlineQueries);
        Expression rootId = SingleQuerySqlGenerator.just(this.aliases.getColumnAlias(rootPath.append((RelationalPersistentProperty)aggregate.getRequiredIdProperty())));
        List<Expression> selectList = SingleQuerySqlGenerator.getSelectList(queryMeta, inlineQueries, rootId);
        Select fullQuery = StatementBuilder.select(selectList).from((TableLike)inlineQuery).orderBy(rootId, SingleQuerySqlGenerator.just("rn")).build(false);
        return SqlRenderer.create(new RenderContextFactory(this.dialect).createRenderContext()).render(fullQuery);
    }

    private static List<Expression> getSelectList(QueryMeta queryMeta, List<QueryMeta> inlineQueries, Expression rootId) {
        ArrayList<Expression> expressions = new ArrayList<Expression>(inlineQueries.size() + queryMeta.simpleColumns.size() + 8);
        queryMeta.simpleColumns.forEach(e -> expressions.add(SingleQuerySqlGenerator.filteredColumnExpression(queryMeta.rowNumber.toString(), e.toString())));
        for (QueryMeta meta : inlineQueries) {
            meta.simpleColumns.forEach(e -> expressions.add(SingleQuerySqlGenerator.filteredColumnExpression(meta.rowNumber.toString(), e.toString())));
            if (meta.id != null) {
                expressions.add(meta.id);
            }
            if (meta.key == null) continue;
            expressions.add(meta.key);
        }
        expressions.add(rootId);
        return expressions;
    }

    private InlineQuery createMainSelect(List<Expression> columns, AggregatePath rootPath, InlineQuery rootQuery, List<QueryMeta> inlineQueries) {
        SelectBuilder.SelectJoin select = StatementBuilder.select(columns).from((TableLike)rootQuery);
        select = this.applyJoins(rootPath, inlineQueries, select);
        SelectBuilder.SelectOrdered buildSelect = this.applyWhereCondition(inlineQueries, select);
        return InlineQuery.create(buildSelect.build(false), "main");
    }

    private List<QueryMeta> createInlineQueries(PersistentPropertyPaths<?, RelationalPersistentProperty> paths) {
        ArrayList<QueryMeta> inlineQueries = new ArrayList<QueryMeta>();
        for (PersistentPropertyPath ppp : paths) {
            QueryMeta queryMeta = this.createInlineQuery(this.context.getAggregatePath((PersistentPropertyPath<? extends RelationalPersistentProperty>)ppp), null);
            inlineQueries.add(queryMeta);
        }
        return inlineQueries;
    }

    private QueryMeta createInlineQuery(AggregatePath basePath, @Nullable Condition condition) {
        RelationalPersistentEntity<?> entity = basePath.getRequiredLeafEntity();
        Table table = Table.create(entity.getQualifiedTableName());
        List<AggregatePath> paths = SingleQuerySqlGenerator.getAggregatePaths(basePath, entity);
        ArrayList<Expression> columns = new ArrayList<Expression>();
        String rowNumberAlias = this.aliases.getRowNumberAlias(basePath);
        AbstractSegment rownumber = basePath.isRoot() ? new AliasedExpression((Expression)SQL.literalOf(1), rowNumberAlias) : SingleQuerySqlGenerator.createRowNumberExpression(basePath, table, rowNumberAlias);
        columns.add((Expression)((Object)rownumber));
        String rowCountAlias = this.aliases.getRowCountAlias(basePath);
        AliasedExpression count = basePath.isRoot() ? new AliasedExpression((Expression)SQL.literalOf(1), rowCountAlias) : AnalyticFunction.create("count", Expressions.just("*")).partitionBy(table.column(basePath.getTableInfo().reverseColumnInfo().name())).as(rowCountAlias);
        columns.add(count);
        String backReferenceAlias = null;
        String keyAlias = null;
        if (!basePath.isRoot()) {
            backReferenceAlias = this.aliases.getBackReferenceAlias(basePath);
            columns.add(table.column(basePath.getTableInfo().reverseColumnInfo().name()).as(backReferenceAlias));
            keyAlias = this.aliases.getKeyAlias(basePath);
            AnalyticFunction keyExpression = basePath.isQualified() ? table.column(basePath.getTableInfo().qualifierColumnInfo().name()).as(keyAlias) : SingleQuerySqlGenerator.createRowNumberExpression(basePath, table, keyAlias);
            columns.add(keyExpression);
        }
        String id = this.getIdentifierProperty(paths);
        List<Expression> columnAliases = this.getColumnAliases(table, paths, columns);
        SelectBuilder.SelectFromAndJoin select = StatementBuilder.select(columns).from((TableLike)table);
        SelectBuilder.SelectFromAndJoin buildSelect = condition != null ? select.where(condition) : select;
        InlineQuery inlineQuery = InlineQuery.create(buildSelect.build(false), this.aliases.getTableAlias(basePath));
        return QueryMeta.of(basePath, inlineQuery, columnAliases, SingleQuerySqlGenerator.just(id), SingleQuerySqlGenerator.just(backReferenceAlias), SingleQuerySqlGenerator.just(keyAlias), SingleQuerySqlGenerator.just(rowNumberAlias), SingleQuerySqlGenerator.just(rowCountAlias));
    }

    private List<Expression> getColumnAliases(Table table, List<AggregatePath> paths, List<Expression> columns) {
        ArrayList<Expression> columnAliases = new ArrayList<Expression>();
        for (AggregatePath path : paths) {
            String alias = this.aliases.getColumnAlias(path);
            if (!path.getRequiredLeafProperty().isIdProperty()) {
                columnAliases.add(SingleQuerySqlGenerator.just(alias));
            }
            columns.add(table.column(path.getColumnInfo().name()).as(alias));
        }
        return columnAliases;
    }

    private static List<AggregatePath> getAggregatePaths(AggregatePath basePath, RelationalPersistentEntity<?> entity) {
        ArrayList<AggregatePath> paths = new ArrayList<AggregatePath>();
        Iterator iterator = entity.iterator();
        while (iterator.hasNext()) {
            RelationalPersistentProperty property = (RelationalPersistentProperty)iterator.next();
            if (property.isEntity()) continue;
            paths.add(basePath.append(property));
        }
        return paths;
    }

    @Nullable
    private String getIdentifierProperty(List<AggregatePath> paths) {
        for (AggregatePath path : paths) {
            if (!path.getRequiredLeafProperty().isIdProperty()) continue;
            return this.aliases.getColumnAlias(path);
        }
        return null;
    }

    private static AnalyticFunction createRowNumberExpression(AggregatePath basePath, Table table, String rowNumberAlias) {
        return AnalyticFunction.create("row_number", new Expression[0]).partitionBy(table.column(basePath.getTableInfo().reverseColumnInfo().name())).orderBy(table.column(basePath.getTableInfo().reverseColumnInfo().name())).as(rowNumberAlias);
    }

    private SelectBuilder.SelectJoin applyJoins(AggregatePath rootPath, List<QueryMeta> inlineQueries, SelectBuilder.SelectJoin select) {
        RelationalPersistentProperty rootIdProperty = rootPath.getRequiredIdProperty();
        AggregatePath rootIdPath = rootPath.append(rootIdProperty);
        for (QueryMeta queryMeta : inlineQueries) {
            AggregatePath path = queryMeta.basePath();
            String backReferenceAlias = this.aliases.getBackReferenceAlias(path);
            Comparison joinCondition = Conditions.isEqual(Expressions.just(this.aliases.getColumnAlias(rootIdPath)), Expressions.just(backReferenceAlias));
            select = select.leftOuterJoin(queryMeta.inlineQuery).on(joinCondition);
        }
        return select;
    }

    private SelectBuilder.SelectOrdered applyWhereCondition(List<QueryMeta> inlineQueries, SelectBuilder.SelectJoin select) {
        SelectBuilder.SelectWhere selectWhere = (SelectBuilder.SelectWhere)((Object)select);
        if (inlineQueries.isEmpty()) {
            return selectWhere;
        }
        Condition joins = null;
        for (int left = 0; left < inlineQueries.size(); ++left) {
            QueryMeta leftQueryMeta = inlineQueries.get(left);
            AggregatePath leftPath = leftQueryMeta.basePath;
            Expression leftRowNumber = SingleQuerySqlGenerator.just(this.aliases.getRowNumberAlias(leftPath));
            Expression leftRowCount = SingleQuerySqlGenerator.just(this.aliases.getRowCountAlias(leftPath));
            for (int right = left + 1; right < inlineQueries.size(); ++right) {
                QueryMeta rightQueryMeta = inlineQueries.get(right);
                AggregatePath rightPath = rightQueryMeta.basePath;
                Expression rightRowNumber = SingleQuerySqlGenerator.just(this.aliases.getRowNumberAlias(rightPath));
                Expression rightRowCount = SingleQuerySqlGenerator.just(this.aliases.getRowCountAlias(rightPath));
                Condition mutualJoin = Conditions.isEqual(leftRowNumber, rightRowNumber).or(Conditions.isNull(leftRowNumber)).or(Conditions.isNull(rightRowNumber)).or(Conditions.nest(Conditions.isGreater(leftRowNumber, rightRowCount).and(Conditions.isEqual(rightRowNumber, SQL.literalOf(1))))).or(Conditions.nest(Conditions.isGreater(rightRowNumber, leftRowCount).and(Conditions.isEqual(leftRowNumber, SQL.literalOf(1)))));
                mutualJoin = Conditions.nest(mutualJoin);
                joins = joins == null ? mutualJoin : joins.and(mutualJoin);
            }
        }
        return selectWhere.where(joins);
    }

    @Override
    public AliasFactory getAliasFactory() {
        return this.aliases;
    }

    private static Expression filteredColumnExpression(String rowNumberAlias, String alias) {
        return SingleQuerySqlGenerator.just(String.format("case when %s = rn THEN %s else null end as %s", rowNumberAlias, alias, alias));
    }

    private static Expression just(String alias) {
        if (alias == null) {
            return null;
        }
        return Expressions.just(alias);
    }

    private static SimpleFunction greatest(List<Expression> expressions) {
        ArrayList<SimpleFunction> guarded = new ArrayList<SimpleFunction>();
        for (Expression expression : expressions) {
            guarded.add(Functions.coalesce(expression, SQL.literalOf(1)));
        }
        return Functions.greatest(guarded);
    }

    record QueryMeta(AggregatePath basePath, InlineQuery inlineQuery, Collection<Expression> simpleColumns, Collection<Expression> selectableExpressions, Expression id, Expression backReference, Expression key, Expression rowNumber, Expression rowCount) {
        static QueryMeta of(AggregatePath basePath, InlineQuery inlineQuery, Collection<Expression> simpleColumns, Expression id, Expression backReference, Expression key, Expression rowNumber, Expression rowCount) {
            ArrayList<Expression> selectableExpressions = new ArrayList<Expression>(simpleColumns);
            selectableExpressions.add(rowNumber);
            if (id != null) {
                selectableExpressions.add(id);
            }
            if (backReference != null) {
                selectableExpressions.add(backReference);
            }
            if (key != null) {
                selectableExpressions.add(key);
            }
            return new QueryMeta(basePath, inlineQuery, simpleColumns, selectableExpressions, id, backReference, key, rowNumber, rowCount);
        }
    }
}

