/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.relational.core.sql.render;

import org.springframework.data.relational.core.sql.SimpleFunction;
import org.springframework.data.relational.core.sql.Visitable;
import org.springframework.data.relational.core.sql.render.DelegatingVisitor;
import org.springframework.data.relational.core.sql.render.PartRenderer;
import org.springframework.data.relational.core.sql.render.RenderContext;
import org.springframework.data.relational.core.sql.render.TypedSingleConditionRenderSupport;

class SimpleFunctionVisitor
extends TypedSingleConditionRenderSupport<SimpleFunction>
implements PartRenderer {
    private final StringBuilder part = new StringBuilder();
    private boolean needsComma = false;

    SimpleFunctionVisitor(RenderContext context) {
        super(context);
    }

    @Override
    DelegatingVisitor.Delegation leaveNested(Visitable segment) {
        if (this.hasDelegatedRendering()) {
            if (this.needsComma) {
                this.part.append(", ");
            }
            this.part.append(this.consumeRenderedPart());
            this.needsComma = true;
        }
        return super.leaveNested(segment);
    }

    @Override
    DelegatingVisitor.Delegation enterMatched(SimpleFunction segment) {
        this.part.append(segment.getFunctionName()).append("(");
        return super.enterMatched(segment);
    }

    @Override
    DelegatingVisitor.Delegation leaveMatched(SimpleFunction segment) {
        this.part.append(")");
        return super.leaveMatched(segment);
    }

    @Override
    public CharSequence getRenderedPart() {
        return this.part;
    }
}

