/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.relational.core.mapping;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.data.relational.core.mapping.NamingStrategy;
import org.springframework.data.relational.core.mapping.PersistentPropertyPathExtension;
import org.springframework.data.relational.core.mapping.RelationalPersistentEntity;
import org.springframework.data.relational.core.mapping.RelationalPersistentProperty;
import org.springframework.data.util.Lazy;
import org.springframework.util.Assert;
import org.springframework.util.ConcurrentReferenceHashMap;

class CachingNamingStrategy
implements NamingStrategy {
    private final NamingStrategy delegate;
    private final Map<RelationalPersistentProperty, String> columnNames = new ConcurrentHashMap<RelationalPersistentProperty, String>();
    private final Map<RelationalPersistentProperty, String> keyColumns = new ConcurrentHashMap<RelationalPersistentProperty, String>();
    private final Map<Class<?>, String> tableNames = new ConcurrentReferenceHashMap();
    private final Lazy<String> schema;

    CachingNamingStrategy(NamingStrategy delegate) {
        Assert.notNull((Object)delegate, (String)"Delegate must not be null");
        this.delegate = delegate;
        this.schema = Lazy.of(delegate::getSchema);
    }

    @Override
    public String getKeyColumn(RelationalPersistentProperty property) {
        return this.keyColumns.computeIfAbsent(property, this.delegate::getKeyColumn);
    }

    @Override
    public String getTableName(Class<?> type) {
        return this.tableNames.computeIfAbsent(type, this.delegate::getTableName);
    }

    @Override
    public String getReverseColumnName(PersistentPropertyPathExtension path) {
        return this.delegate.getReverseColumnName(path);
    }

    @Override
    public String getReverseColumnName(RelationalPersistentProperty property) {
        return this.delegate.getReverseColumnName(property);
    }

    @Override
    public String getReverseColumnName(RelationalPersistentEntity<?> owner) {
        return this.delegate.getReverseColumnName(owner);
    }

    @Override
    public String getSchema() {
        return (String)this.schema.get();
    }

    @Override
    public String getColumnName(RelationalPersistentProperty property) {
        return this.columnNames.computeIfAbsent(property, this.delegate::getColumnName);
    }
}

