/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.relational.core.conversion;

import org.springframework.data.relational.core.mapping.RelationalPersistentEntity;
import org.springframework.data.relational.core.mapping.RelationalPersistentProperty;

public enum IdValueSource {
    PROVIDED,
    GENERATED,
    NONE;


    public static <T> IdValueSource forInstance(Object instance, RelationalPersistentEntity<T> persistentEntity) {
        boolean idPropertyValueIsSet;
        Object idValue = persistentEntity.getIdentifierAccessor(instance).getIdentifier();
        RelationalPersistentProperty idProperty = (RelationalPersistentProperty)persistentEntity.getIdProperty();
        if (idProperty == null) {
            return NONE;
        }
        boolean bl = idPropertyValueIsSet = !(idValue == null || idProperty.getType() == Integer.TYPE && idValue.equals(0) || idProperty.getType() == Long.TYPE && idValue.equals(0L));
        if (idPropertyValueIsSet) {
            return PROVIDED;
        }
        return GENERATED;
    }
}

