/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.relational.core.dialect;

import java.util.Collection;
import java.util.Collections;
import org.springframework.data.relational.core.dialect.AbstractDialect;
import org.springframework.data.relational.core.dialect.LimitClause;
import org.springframework.data.relational.core.dialect.LockClause;
import org.springframework.data.relational.core.dialect.TimestampAtUtcToOffsetDateTimeConverter;
import org.springframework.data.relational.core.sql.IdentifierProcessing;
import org.springframework.data.relational.core.sql.LockOptions;

public class Db2Dialect
extends AbstractDialect {
    public static final Db2Dialect INSTANCE = new Db2Dialect();
    private static final LimitClause LIMIT_CLAUSE = new LimitClause(){

        @Override
        public String getLimit(long limit) {
            return "FETCH FIRST " + limit + " ROWS ONLY";
        }

        @Override
        public String getOffset(long offset) {
            return "OFFSET " + offset + " ROWS";
        }

        @Override
        public String getLimitOffset(long limit, long offset) {
            return String.format("OFFSET %d ROWS FETCH FIRST %d ROWS ONLY", offset, limit);
        }

        @Override
        public LimitClause.Position getClausePosition() {
            return LimitClause.Position.AFTER_ORDER_BY;
        }
    };

    protected Db2Dialect() {
    }

    @Override
    public LimitClause limit() {
        return LIMIT_CLAUSE;
    }

    @Override
    public LockClause lock() {
        return new LockClause(){

            @Override
            public String getLock(LockOptions lockOptions) {
                return "FOR UPDATE WITH RS USE AND KEEP EXCLUSIVE LOCKS";
            }

            @Override
            public LockClause.Position getClausePosition() {
                return LockClause.Position.AFTER_ORDER_BY;
            }
        };
    }

    @Override
    public IdentifierProcessing getIdentifierProcessing() {
        return IdentifierProcessing.ANSI;
    }

    @Override
    public Collection<Object> getConverters() {
        return Collections.singletonList(TimestampAtUtcToOffsetDateTimeConverter.INSTANCE);
    }
}

