/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.relational.core.conversion;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.springframework.data.relational.core.conversion.AggregateChange;
import org.springframework.data.relational.core.conversion.DbAction;
import org.springframework.data.relational.core.conversion.MutableAggregateChange;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

class DefaultAggregateChange<T>
implements MutableAggregateChange<T> {
    private final AggregateChange.Kind kind;
    private final Class<T> entityType;
    private final List<DbAction<?>> actions = new ArrayList();
    @Nullable
    private T entity;

    public DefaultAggregateChange(AggregateChange.Kind kind, Class<T> entityType, @Nullable T entity) {
        this.kind = kind;
        this.entityType = entityType;
        this.entity = entity;
    }

    @Override
    public void addAction(DbAction<?> action) {
        Assert.notNull(action, (String)"Action must not be null.");
        this.actions.add(action);
    }

    @Override
    public AggregateChange.Kind getKind() {
        return this.kind;
    }

    @Override
    public Class<T> getEntityType() {
        return this.entityType;
    }

    @Override
    public void setEntity(@Nullable T aggregateRoot) {
        if (aggregateRoot != null) {
            Assert.isInstanceOf(this.entityType, aggregateRoot, (String)String.format("AggregateRoot must be of type %s", this.entityType.getName()));
        }
        this.entity = aggregateRoot;
    }

    @Override
    public T getEntity() {
        return this.entity;
    }

    @Override
    public void forEachAction(Consumer<? super DbAction<?>> consumer) {
        Assert.notNull(consumer, (String)"Consumer must not be null.");
        this.actions.forEach(consumer);
    }
}

