/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.relational.core.sql.render;

import org.springframework.data.relational.core.sql.In;
import org.springframework.data.relational.core.sql.Visitable;
import org.springframework.data.relational.core.sql.render.DelegatingVisitor;
import org.springframework.data.relational.core.sql.render.RenderContext;
import org.springframework.data.relational.core.sql.render.RenderTarget;
import org.springframework.data.relational.core.sql.render.TypedSingleConditionRenderSupport;

class InVisitor
extends TypedSingleConditionRenderSupport<In> {
    private final RenderTarget target;
    private final StringBuilder part = new StringBuilder();
    private boolean needsComma = false;
    private boolean notIn = false;

    InVisitor(RenderContext context, RenderTarget target) {
        super(context);
        this.target = target;
    }

    @Override
    DelegatingVisitor.Delegation leaveNested(Visitable segment) {
        if (this.hasDelegatedRendering()) {
            CharSequence renderedPart = this.consumeRenderedPart();
            if (this.needsComma) {
                this.part.append(", ");
            }
            if (this.part.length() == 0) {
                this.part.append(renderedPart);
                if (this.notIn) {
                    this.part.append(" NOT");
                }
                this.part.append(" IN (");
            } else {
                this.part.append(renderedPart);
                this.needsComma = true;
            }
        }
        return super.leaveNested(segment);
    }

    @Override
    DelegatingVisitor.Delegation enterMatched(In segment) {
        this.notIn = segment.isNotIn();
        return super.enterMatched(segment);
    }

    @Override
    DelegatingVisitor.Delegation leaveMatched(In segment) {
        this.part.append(")");
        this.target.onRendered(this.part);
        return super.leaveMatched(segment);
    }
}

