/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.relational.core.sql.render;

import org.springframework.data.relational.core.sql.Column;
import org.springframework.data.relational.core.sql.Insert;
import org.springframework.data.relational.core.sql.Into;
import org.springframework.data.relational.core.sql.Values;
import org.springframework.data.relational.core.sql.Visitable;
import org.springframework.data.relational.core.sql.render.ColumnVisitor;
import org.springframework.data.relational.core.sql.render.DelegatingVisitor;
import org.springframework.data.relational.core.sql.render.IntoClauseVisitor;
import org.springframework.data.relational.core.sql.render.PartRenderer;
import org.springframework.data.relational.core.sql.render.RenderContext;
import org.springframework.data.relational.core.sql.render.ValuesVisitor;

class InsertStatementVisitor
extends DelegatingVisitor
implements PartRenderer {
    private StringBuilder builder = new StringBuilder();
    private StringBuilder into = new StringBuilder();
    private StringBuilder columns = new StringBuilder();
    private StringBuilder values = new StringBuilder();
    private IntoClauseVisitor intoClauseVisitor;
    private ColumnVisitor columnVisitor;
    private ValuesVisitor valuesVisitor;

    InsertStatementVisitor(RenderContext context) {
        this.intoClauseVisitor = new IntoClauseVisitor(context, it -> {
            if (this.into.length() != 0) {
                this.into.append(", ");
            }
            this.into.append(it);
        });
        this.columnVisitor = new ColumnVisitor(context, false, it -> {
            if (this.columns.length() != 0) {
                this.columns.append(", ");
            }
            this.columns.append(it);
        });
        this.valuesVisitor = new ValuesVisitor(context, this.values::append);
    }

    @Override
    public DelegatingVisitor.Delegation doEnter(Visitable segment) {
        if (segment instanceof Into) {
            return DelegatingVisitor.Delegation.delegateTo(this.intoClauseVisitor);
        }
        if (segment instanceof Column) {
            return DelegatingVisitor.Delegation.delegateTo(this.columnVisitor);
        }
        if (segment instanceof Values) {
            return DelegatingVisitor.Delegation.delegateTo(this.valuesVisitor);
        }
        return DelegatingVisitor.Delegation.retain();
    }

    @Override
    public DelegatingVisitor.Delegation doLeave(Visitable segment) {
        if (segment instanceof Insert) {
            this.builder.append("INSERT");
            this.builder.append(" INTO ").append((CharSequence)this.into);
            if (this.columns.length() != 0) {
                this.builder.append(" (").append((CharSequence)this.columns).append(")");
            }
            this.builder.append(" VALUES (").append((CharSequence)this.values).append(")");
            return DelegatingVisitor.Delegation.leave();
        }
        return DelegatingVisitor.Delegation.retain();
    }

    @Override
    public CharSequence getRenderedPart() {
        return this.builder;
    }
}

