/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.relational.repository.query;

import org.springframework.data.relational.core.mapping.RelationalPersistentEntity;
import org.springframework.data.relational.repository.query.RelationalEntityMetadata;
import org.springframework.util.Assert;

public class SimpleRelationalEntityMetadata<T>
implements RelationalEntityMetadata<T> {
    private final Class<T> type;
    private final RelationalPersistentEntity<?> tableEntity;

    public SimpleRelationalEntityMetadata(Class<T> type, RelationalPersistentEntity<?> tableEntity) {
        Assert.notNull(type, (String)"Type must not be null!");
        Assert.notNull(tableEntity, (String)"Table entity must not be null!");
        this.type = type;
        this.tableEntity = tableEntity;
    }

    public Class<T> getJavaType() {
        return this.type;
    }

    @Override
    public String getTableName() {
        return this.tableEntity.getTableName();
    }

    @Override
    public RelationalPersistentEntity<?> getTableEntity() {
        return this.tableEntity;
    }
}

