/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.relational.core.sql.render;

import java.util.Locale;
import java.util.function.Function;
import org.springframework.data.relational.core.sql.Column;
import org.springframework.data.relational.core.sql.Table;
import org.springframework.data.relational.core.sql.render.RenderNamingStrategy;
import org.springframework.util.Assert;

public abstract class NamingStrategies {
    private NamingStrategies() {
    }

    public static RenderNamingStrategy asIs() {
        return AsIs.INSTANCE;
    }

    public static RenderNamingStrategy mapWith(Function<String, String> mappingFunction) {
        return AsIs.INSTANCE.map(mappingFunction);
    }

    public static RenderNamingStrategy toUpper() {
        return NamingStrategies.toUpper(Locale.getDefault());
    }

    public static RenderNamingStrategy toUpper(Locale locale) {
        Assert.notNull((Object)locale, (String)"Locale must not be null");
        return AsIs.INSTANCE.map(it -> it.toUpperCase(locale));
    }

    public static RenderNamingStrategy toLower() {
        return NamingStrategies.toLower(Locale.getDefault());
    }

    public static RenderNamingStrategy toLower(Locale locale) {
        Assert.notNull((Object)locale, (String)"Locale must not be null");
        return AsIs.INSTANCE.map(it -> it.toLowerCase(locale));
    }

    static class DelegatingRenderNamingStrategy
    implements RenderNamingStrategy {
        private final RenderNamingStrategy delegate;
        private final Function<String, String> mappingFunction;

        @Override
        public String getName(Column column) {
            return this.mappingFunction.apply(this.delegate.getName(column));
        }

        @Override
        public String getReferenceName(Column column) {
            return this.mappingFunction.apply(this.delegate.getReferenceName(column));
        }

        @Override
        public String getName(Table table) {
            return this.mappingFunction.apply(this.delegate.getName(table));
        }

        @Override
        public String getReferenceName(Table table) {
            return this.mappingFunction.apply(this.delegate.getReferenceName(table));
        }

        public DelegatingRenderNamingStrategy(RenderNamingStrategy delegate, Function<String, String> mappingFunction) {
            this.delegate = delegate;
            this.mappingFunction = mappingFunction;
        }
    }

    static enum AsIs implements RenderNamingStrategy
    {
        INSTANCE;

    }
}

