/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.relational.core.sql;

import java.util.List;
import org.springframework.data.relational.core.sql.AbstractSegment;
import org.springframework.data.relational.core.sql.Aliased;
import org.springframework.data.relational.core.sql.Expression;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class SimpleFunction
extends AbstractSegment
implements Expression {
    private String functionName;
    private List<Expression> expressions;

    private SimpleFunction(String functionName, List<Expression> expressions) {
        super(expressions.toArray(new Expression[0]));
        this.functionName = functionName;
        this.expressions = expressions;
    }

    public static SimpleFunction create(String functionName, List<Expression> expressions) {
        Assert.hasText((String)functionName, (String)"Function name must not be null or empty");
        Assert.notNull(expressions, (String)"Expressions name must not be null");
        return new SimpleFunction(functionName, expressions);
    }

    public SimpleFunction as(String alias) {
        Assert.hasText((String)alias, (String)"Alias must not be null or empty");
        return new AliasedFunction(this.functionName, this.expressions, alias);
    }

    public String getFunctionName() {
        return this.functionName;
    }

    @Override
    public String toString() {
        return this.functionName + "(" + StringUtils.collectionToDelimitedString(this.expressions, (String)", ") + ")";
    }

    static class AliasedFunction
    extends SimpleFunction
    implements Aliased {
        private final String alias;

        AliasedFunction(String functionName, List<Expression> expressions, String alias) {
            super(functionName, expressions);
            this.alias = alias;
        }

        @Override
        public String getAlias() {
            return this.alias;
        }
    }
}

