/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.relational.core.sql;

import org.springframework.data.relational.core.sql.AbstractSegment;
import org.springframework.data.relational.core.sql.Aliased;
import org.springframework.data.relational.core.sql.AssignValue;
import org.springframework.data.relational.core.sql.Assignments;
import org.springframework.data.relational.core.sql.Comparison;
import org.springframework.data.relational.core.sql.Condition;
import org.springframework.data.relational.core.sql.Conditions;
import org.springframework.data.relational.core.sql.Expression;
import org.springframework.data.relational.core.sql.In;
import org.springframework.data.relational.core.sql.IsNull;
import org.springframework.data.relational.core.sql.Like;
import org.springframework.data.relational.core.sql.Named;
import org.springframework.data.relational.core.sql.Select;
import org.springframework.data.relational.core.sql.Table;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class Column
extends AbstractSegment
implements Expression,
Named {
    private final String name;
    private final Table table;

    Column(String name, Table table) {
        super(table);
        Assert.notNull((Object)name, (String)"Name must not be null");
        this.name = name;
        this.table = table;
    }

    public static Column create(String name, Table table) {
        Assert.hasText((String)name, (String)"Name must not be null or empty");
        Assert.notNull((Object)table, (String)"Table must not be null");
        return new Column(name, table);
    }

    public static Column aliased(String name, Table table, String alias) {
        Assert.hasText((String)name, (String)"Name must not be null or empty");
        Assert.notNull((Object)table, (String)"Table must not be null");
        Assert.hasText((String)alias, (String)"Alias must not be null or empty");
        return new AliasedColumn(name, table, alias);
    }

    public Column as(String alias) {
        Assert.hasText((String)alias, (String)"Alias must not be null or empty");
        return new AliasedColumn(this.name, this.table, alias);
    }

    public Column from(Table table) {
        Assert.notNull((Object)table, (String)"Table must not be null");
        return new Column(this.name, table);
    }

    public Comparison isEqualTo(Expression expression) {
        return Conditions.isEqual(this, expression);
    }

    public Comparison isNotEqualTo(Expression expression) {
        return Conditions.isNotEqual(this, expression);
    }

    public Comparison isLess(Expression expression) {
        return Conditions.isLess(this, expression);
    }

    public Comparison isLessOrEqualTo(Expression expression) {
        return Conditions.isLessOrEqualTo(this, expression);
    }

    public Comparison isGreater(Expression expression) {
        return Conditions.isGreater(this, expression);
    }

    public Comparison isGreaterOrEqualTo(Expression expression) {
        return Conditions.isGreaterOrEqualTo(this, expression);
    }

    public Like like(Expression expression) {
        return Conditions.like(this, expression);
    }

    public In in(Expression ... expression) {
        return Conditions.in((Expression)this, expression);
    }

    public In in(Select subselect) {
        return Conditions.in(this, subselect);
    }

    public In notIn(Expression ... expression) {
        return Conditions.notIn((Expression)this, expression);
    }

    public In notIn(Select subselect) {
        return Conditions.notIn(this, subselect);
    }

    public IsNull isNull() {
        return Conditions.isNull(this);
    }

    public Condition isNotNull() {
        return this.isNull().not();
    }

    public AssignValue set(Expression value) {
        return Assignments.value(this, value);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String getReferenceName() {
        return this.name;
    }

    @Nullable
    public Table getTable() {
        return this.table;
    }

    @Override
    public String toString() {
        return this.getPrefix() + this.name;
    }

    String getPrefix() {
        String prefix = "";
        if (this.table != null) {
            prefix = (this.table instanceof Aliased ? ((Aliased)((Object)this.table)).getAlias() : this.table.getName()) + ".";
        }
        return prefix;
    }

    static class AliasedColumn
    extends Column
    implements Aliased {
        private final String alias;

        private AliasedColumn(String name, Table table, String alias) {
            super(name, table);
            this.alias = alias;
        }

        @Override
        public String getAlias() {
            return this.alias;
        }

        @Override
        public String getReferenceName() {
            return this.getAlias();
        }

        @Override
        public Column from(Table table) {
            Assert.notNull((Object)table, (String)"Table must not be null");
            return new AliasedColumn(this.getName(), table, this.getAlias());
        }

        @Override
        public String toString() {
            return this.getPrefix() + this.getName() + " AS " + this.getAlias();
        }
    }
}

