/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.relational.core.conversion;

import java.util.Collections;
import java.util.Optional;
import java.util.function.Function;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.converter.ConverterRegistry;
import org.springframework.core.convert.support.ConfigurableConversionService;
import org.springframework.core.convert.support.DefaultConversionService;
import org.springframework.data.convert.CustomConversions;
import org.springframework.data.convert.EntityInstantiators;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.PersistentPropertyAccessor;
import org.springframework.data.mapping.PreferredConstructor;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mapping.model.ConvertingPropertyAccessor;
import org.springframework.data.mapping.model.ParameterValueProvider;
import org.springframework.data.relational.core.conversion.RelationalConverter;
import org.springframework.data.relational.core.mapping.RelationalPersistentEntity;
import org.springframework.data.relational.core.mapping.RelationalPersistentProperty;
import org.springframework.data.util.TypeInformation;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class BasicRelationalConverter
implements RelationalConverter {
    private final MappingContext<? extends RelationalPersistentEntity<?>, RelationalPersistentProperty> context;
    private final ConfigurableConversionService conversionService;
    private final EntityInstantiators entityInstantiators;
    private final CustomConversions conversions;

    public BasicRelationalConverter(MappingContext<? extends RelationalPersistentEntity<?>, ? extends RelationalPersistentProperty> context) {
        this(context, new CustomConversions(CustomConversions.StoreConversions.NONE, Collections.emptyList()), (ConfigurableConversionService)new DefaultConversionService(), new EntityInstantiators());
    }

    public BasicRelationalConverter(MappingContext<? extends RelationalPersistentEntity<?>, ? extends RelationalPersistentProperty> context, CustomConversions conversions) {
        this(context, conversions, (ConfigurableConversionService)new DefaultConversionService(), new EntityInstantiators());
    }

    private BasicRelationalConverter(MappingContext<? extends RelationalPersistentEntity<?>, ? extends RelationalPersistentProperty> context, CustomConversions conversions, ConfigurableConversionService conversionService, EntityInstantiators entityInstantiators) {
        Assert.notNull(context, (String)"MappingContext must not be null!");
        Assert.notNull((Object)conversions, (String)"CustomConversions must not be null!");
        this.context = context;
        this.conversionService = conversionService;
        this.entityInstantiators = entityInstantiators;
        this.conversions = conversions;
        conversions.registerConvertersIn((ConverterRegistry)this.conversionService);
    }

    @Override
    public ConversionService getConversionService() {
        return this.conversionService;
    }

    public CustomConversions getConversions() {
        return this.conversions;
    }

    @Override
    public MappingContext<? extends RelationalPersistentEntity<?>, ? extends RelationalPersistentProperty> getMappingContext() {
        return this.context;
    }

    @Override
    public <T> PersistentPropertyAccessor<T> getPropertyAccessor(PersistentEntity<T, ?> persistentEntity, T instance) {
        PersistentPropertyAccessor accessor = persistentEntity.getPropertyAccessor(instance);
        return new ConvertingPropertyAccessor(accessor, (ConversionService)this.conversionService);
    }

    @Override
    public <T> T createInstance(PersistentEntity<T, RelationalPersistentProperty> entity, Function<PreferredConstructor.Parameter<?, RelationalPersistentProperty>, Object> parameterValueProvider) {
        return (T)this.entityInstantiators.getInstantiatorFor(entity).createInstance(entity, new ConvertingParameterValueProvider(parameterValueProvider));
    }

    @Override
    @Nullable
    public Object readValue(@Nullable Object value, TypeInformation<?> type) {
        if (null == value) {
            return null;
        }
        if (this.conversions.hasCustomReadTarget(value.getClass(), type.getType())) {
            return this.conversionService.convert(value, type.getType());
        }
        return this.getPotentiallyConvertedSimpleRead(value, type.getType());
    }

    @Override
    @Nullable
    public Object writeValue(@Nullable Object value, TypeInformation<?> type) {
        if (value == null) {
            return null;
        }
        Class rawType = type.getType();
        RelationalPersistentEntity persistentEntity = (RelationalPersistentEntity)this.context.getPersistentEntity(value.getClass());
        if (persistentEntity != null) {
            Object id = persistentEntity.getIdentifierAccessor(value).getIdentifier();
            return this.writeValue(id, type);
        }
        if (rawType.isInstance(value)) {
            return this.getPotentiallyConvertedSimpleWrite(value);
        }
        return this.conversionService.convert(value, rawType);
    }

    @Nullable
    private Object getPotentiallyConvertedSimpleWrite(Object value) {
        Optional customTarget = this.conversions.getCustomWriteTarget(value.getClass());
        if (customTarget.isPresent()) {
            return this.conversionService.convert(value, (Class)customTarget.get());
        }
        return Enum.class.isAssignableFrom(value.getClass()) ? ((Enum)value).name() : value;
    }

    @Nullable
    private Object getPotentiallyConvertedSimpleRead(@Nullable Object value, @Nullable Class<?> target) {
        if (value == null || target == null || ClassUtils.isAssignableValue(target, (Object)value)) {
            return value;
        }
        if (Enum.class.isAssignableFrom(target)) {
            return Enum.valueOf(target, value.toString());
        }
        return this.conversionService.convert(value, target);
    }

    class ConvertingParameterValueProvider<P extends PersistentProperty<P>>
    implements ParameterValueProvider<P> {
        private final Function<PreferredConstructor.Parameter<?, P>, Object> delegate;

        public <T> T getParameterValue(PreferredConstructor.Parameter<T, P> parameter) {
            return (T)BasicRelationalConverter.this.readValue(this.delegate.apply(parameter), parameter.getType());
        }

        public ConvertingParameterValueProvider(Function<PreferredConstructor.Parameter<?, P>, Object> delegate) {
            this.delegate = delegate;
        }
    }
}

