/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.core;

import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.jspecify.annotations.Nullable;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.data.redis.core.Cursor;
import org.springframework.data.redis.core.ScanIteration;
import org.springframework.data.redis.core.ScanOptions;
import org.springframework.util.CollectionUtils;

public abstract class ScanCursor<T>
implements Cursor<T> {
    private CursorState state;
    private Cursor.CursorId id;
    private Iterator<T> delegate;
    private final ScanOptions scanOptions;
    private long position;

    public ScanCursor() {
        this(ScanOptions.NONE);
    }

    public ScanCursor(ScanOptions options) {
        this(Cursor.CursorId.initial(), options);
    }

    @Deprecated(since="3.3")
    public ScanCursor(long cursorId) {
        this(cursorId, ScanOptions.NONE);
    }

    public ScanCursor(Cursor.CursorId cursorId) {
        this(cursorId, ScanOptions.NONE);
    }

    @Deprecated(since="3.3")
    public ScanCursor(long cursorId, @Nullable ScanOptions options) {
        this(Cursor.CursorId.of(cursorId), options);
    }

    public ScanCursor(Cursor.CursorId cursorId, @Nullable ScanOptions options) {
        this.scanOptions = options != null ? options : ScanOptions.NONE;
        this.id = cursorId;
        this.state = CursorState.READY;
        this.delegate = Collections.emptyIterator();
    }

    private void scan(Cursor.CursorId cursorId) {
        try {
            this.processScanResult(this.doScan(cursorId, this.scanOptions));
        }
        catch (RuntimeException ex) {
            try {
                this.close();
            }
            catch (RuntimeException nested) {
                ex.addSuppressed(nested);
            }
            throw ex;
        }
    }

    @Deprecated(since="3.3")
    protected ScanIteration<T> doScan(long cursorId, ScanOptions options) {
        return this.doScan(Cursor.CursorId.of(cursorId), this.scanOptions);
    }

    protected ScanIteration<T> doScan(Cursor.CursorId cursorId, ScanOptions options) {
        return this.doScan(Long.parseLong(cursorId.getCursorId()), this.scanOptions);
    }

    public final ScanCursor<T> open() {
        if (!this.isReady()) {
            throw new InvalidDataAccessApiUsageException("Cursor already " + String.valueOf((Object)this.state) + "; Cannot (re)open it");
        }
        this.state = CursorState.OPEN;
        this.doOpen(this.getId());
        return this;
    }

    protected void doOpen(Cursor.CursorId cursorId) {
        this.scan(cursorId);
    }

    private void processScanResult(ScanIteration<T> result) {
        this.id = result.getId();
        if (this.isFinished(this.id)) {
            this.state = CursorState.FINISHED;
        }
        if (!CollectionUtils.isEmpty(result.getItems())) {
            this.delegate = result.iterator();
        } else {
            this.resetDelegate();
        }
    }

    protected boolean isFinished(Cursor.CursorId cursorId) {
        return Cursor.CursorId.isInitial(cursorId.getCursorId());
    }

    private void resetDelegate() {
        this.delegate = Collections.emptyIterator();
    }

    @Override
    public Cursor.CursorId getId() {
        return this.id;
    }

    @Override
    public long getCursorId() {
        return Long.parseUnsignedLong(this.getId().getCursorId());
    }

    public boolean hasNext() {
        this.assertCursorIsOpen();
        while (!this.delegate.hasNext() && !CursorState.FINISHED.equals((Object)this.state)) {
            this.scan(this.getId());
        }
        if (this.delegate.hasNext()) {
            return true;
        }
        return !this.isFinished(this.id);
    }

    private void assertCursorIsOpen() {
        if (this.isReady() || this.isClosed()) {
            throw new InvalidDataAccessApiUsageException("Cannot access closed cursor; Did you forget to call open()");
        }
    }

    public T next() {
        this.assertCursorIsOpen();
        if (!this.hasNext()) {
            throw new NoSuchElementException("No more elements available for cursor " + String.valueOf(this.id));
        }
        T next = this.moveNext(this.delegate);
        ++this.position;
        return next;
    }

    protected T moveNext(Iterator<T> source) {
        return source.next();
    }

    public void remove() {
        throw new UnsupportedOperationException("Remove is not supported");
    }

    public final void close() {
        try {
            this.doClose();
        }
        finally {
            this.state = CursorState.CLOSED;
        }
    }

    protected void doClose() {
    }

    @Override
    public boolean isClosed() {
        return this.state == CursorState.CLOSED;
    }

    protected final boolean isReady() {
        return this.state == CursorState.READY;
    }

    protected final boolean isOpen() {
        return this.state == CursorState.OPEN;
    }

    @Override
    public long getPosition() {
        return this.position;
    }

    static enum CursorState {
        READY,
        OPEN,
        FINISHED,
        CLOSED;

    }
}

