/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.jedis;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.NullUnmarked;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.data.redis.connection.RedisSetCommands;
import org.springframework.data.redis.connection.convert.Converters;
import org.springframework.data.redis.connection.jedis.JedisConnection;
import org.springframework.data.redis.connection.jedis.JedisConverters;
import org.springframework.data.redis.core.Cursor;
import org.springframework.data.redis.core.KeyBoundCursor;
import org.springframework.data.redis.core.ScanIteration;
import org.springframework.data.redis.core.ScanOptions;
import org.springframework.util.Assert;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.commands.SetPipelineBinaryCommands;
import redis.clients.jedis.params.ScanParams;
import redis.clients.jedis.resps.ScanResult;

@NullUnmarked
class JedisSetCommands
implements RedisSetCommands {
    private final JedisConnection connection;

    JedisSetCommands(@NonNull JedisConnection connection) {
        this.connection = connection;
    }

    @Override
    public Long sAdd(byte @NonNull [] key, byte[] ... values) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        Assert.notNull((Object)values, (String)"Values must not be null");
        Assert.noNullElements((Object[])values, (String)"Values must not contain null elements");
        return this.connection.invoke().just(Jedis::sadd, SetPipelineBinaryCommands::sadd, key, values);
    }

    @Override
    public Long sCard(byte @NonNull [] key) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        return this.connection.invoke().just(Jedis::scard, SetPipelineBinaryCommands::scard, key);
    }

    @Override
    public Set<byte @NonNull []> sDiff(byte[] ... keys) {
        Assert.notNull((Object)keys, (String)"Keys must not be null");
        Assert.noNullElements((Object[])keys, (String)"Keys must not contain null elements");
        return this.connection.invoke().just(Jedis::sdiff, SetPipelineBinaryCommands::sdiff, keys);
    }

    @Override
    public Long sDiffStore(byte @NonNull [] destKey, byte[] ... keys) {
        Assert.notNull((Object)destKey, (String)"Destination key must not be null");
        Assert.notNull((Object)keys, (String)"Source keys must not be null");
        Assert.noNullElements((Object[])keys, (String)"Source keys must not contain null elements");
        return this.connection.invoke().just(Jedis::sdiffstore, SetPipelineBinaryCommands::sdiffstore, destKey, keys);
    }

    @Override
    public Set<byte @NonNull []> sInter(byte[] ... keys) {
        Assert.notNull((Object)keys, (String)"Keys must not be null");
        Assert.noNullElements((Object[])keys, (String)"Keys must not contain null elements");
        return this.connection.invoke().just(Jedis::sinter, SetPipelineBinaryCommands::sinter, keys);
    }

    @Override
    public Long sInterStore(byte @NonNull [] destKey, byte[] ... keys) {
        Assert.notNull((Object)destKey, (String)"Destination key must not be null");
        Assert.notNull((Object)keys, (String)"Source keys must not be null");
        Assert.noNullElements((Object[])keys, (String)"Source keys must not contain null elements");
        return this.connection.invoke().just(Jedis::sinterstore, SetPipelineBinaryCommands::sinterstore, destKey, keys);
    }

    @Override
    public Long sInterCard(byte[] ... keys) {
        Assert.notNull((Object)keys, (String)"Keys must not be null");
        Assert.noNullElements((Object[])keys, (String)"Keys must not contain null elements");
        return this.connection.invoke().just(Jedis::sintercard, SetPipelineBinaryCommands::sintercard, keys);
    }

    @Override
    public Boolean sIsMember(byte @NonNull [] key, byte @NonNull [] value) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        Assert.notNull((Object)value, (String)"Value must not be null");
        return this.connection.invoke().just(Jedis::sismember, SetPipelineBinaryCommands::sismember, key, value);
    }

    @Override
    public List<@NonNull Boolean> sMIsMember(byte @NonNull [] key, byte[] ... values) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        Assert.notNull((Object)values, (String)"Values must not be null");
        Assert.noNullElements((Object[])values, (String)"Values must not contain null elements");
        return this.connection.invoke().just(Jedis::smismember, SetPipelineBinaryCommands::smismember, key, values);
    }

    @Override
    public Set<byte @NonNull []> sMembers(byte @NonNull [] key) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        return this.connection.invoke().just(Jedis::smembers, SetPipelineBinaryCommands::smembers, key);
    }

    @Override
    public Boolean sMove(byte @NonNull [] srcKey, byte @NonNull [] destKey, byte @NonNull [] value) {
        Assert.notNull((Object)srcKey, (String)"Source key must not be null");
        Assert.notNull((Object)destKey, (String)"Destination key must not be null");
        Assert.notNull((Object)value, (String)"Value must not be null");
        return (Boolean)this.connection.invoke().from(Jedis::smove, SetPipelineBinaryCommands::smove, srcKey, destKey, value).get(Converters::toBoolean);
    }

    @Override
    public byte[] sPop(byte @NonNull [] key) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        return this.connection.invoke().just(Jedis::spop, SetPipelineBinaryCommands::spop, key);
    }

    @Override
    public List<byte @NonNull []> sPop(byte @NonNull [] key, long count) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        return (List)this.connection.invoke().from(Jedis::spop, SetPipelineBinaryCommands::spop, key, count).get(ArrayList::new);
    }

    @Override
    public byte[] sRandMember(byte @NonNull [] key) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        return this.connection.invoke().just(Jedis::srandmember, SetPipelineBinaryCommands::srandmember, key);
    }

    @Override
    public List<byte @NonNull []> sRandMember(byte @NonNull [] key, long count) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        if (count > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Count must be less than Integer.MAX_VALUE for sRandMember in Jedis");
        }
        return this.connection.invoke().just(Jedis::srandmember, SetPipelineBinaryCommands::srandmember, key, (int)count);
    }

    @Override
    public Long sRem(byte @NonNull [] key, byte[] ... values) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        Assert.notNull((Object)values, (String)"Values must not be null");
        Assert.noNullElements((Object[])values, (String)"Values must not contain null elements");
        return this.connection.invoke().just(Jedis::srem, SetPipelineBinaryCommands::srem, key, values);
    }

    @Override
    public Set<byte[]> sUnion(byte[] ... keys) {
        Assert.notNull((Object)keys, (String)"Keys must not be null");
        Assert.noNullElements((Object[])keys, (String)"Keys must not contain null elements");
        return this.connection.invoke().just(Jedis::sunion, SetPipelineBinaryCommands::sunion, keys);
    }

    @Override
    public Long sUnionStore(byte @NonNull [] destKey, byte[] ... keys) {
        Assert.notNull((Object)destKey, (String)"Destination key must not be null");
        Assert.notNull((Object)keys, (String)"Source keys must not be null");
        Assert.noNullElements((Object[])keys, (String)"Source keys must not contain null elements");
        return this.connection.invoke().just(Jedis::sunionstore, SetPipelineBinaryCommands::sunionstore, destKey, keys);
    }

    @Override
    public Cursor<byte[]> sScan(byte @NonNull [] key, @NonNull ScanOptions options) {
        return this.sScan(key, Cursor.CursorId.initial(), options);
    }

    public Cursor<byte @NonNull []> sScan(byte @NonNull [] key, @NonNull Cursor.CursorId cursorId, @NonNull ScanOptions options) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        return new KeyBoundCursor<byte[]>(key, cursorId, options){

            @Override
            protected ScanIteration<byte[]> doScan(byte @NonNull [] key, @NonNull Cursor.CursorId cursorId, @NonNull ScanOptions options) {
                if (JedisSetCommands.this.isQueueing() || JedisSetCommands.this.isPipelined()) {
                    throw new InvalidDataAccessApiUsageException("'SSCAN' cannot be called in pipeline / transaction mode");
                }
                ScanParams params = JedisConverters.toScanParams(options);
                ScanResult result = JedisSetCommands.this.connection.getJedis().sscan(key, JedisConverters.toBytes(cursorId), params);
                return new ScanIteration<byte[]>(Cursor.CursorId.of(result.getCursor()), result.getResult());
            }

            @Override
            protected void doClose() {
                JedisSetCommands.this.connection.close();
            }
        }.open();
    }

    private boolean isPipelined() {
        return this.connection.isPipelined();
    }

    private boolean isQueueing() {
        return this.connection.isQueueing();
    }
}

