/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.jedis;

import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.NullUnmarked;
import org.jspecify.annotations.Nullable;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.data.domain.Range;
import org.springframework.data.redis.connection.Limit;
import org.springframework.data.redis.connection.RedisZSetCommands;
import org.springframework.data.redis.connection.convert.Converters;
import org.springframework.data.redis.connection.jedis.JedisConnection;
import org.springframework.data.redis.connection.jedis.JedisConverters;
import org.springframework.data.redis.connection.zset.Aggregate;
import org.springframework.data.redis.connection.zset.Tuple;
import org.springframework.data.redis.connection.zset.Weights;
import org.springframework.data.redis.core.Cursor;
import org.springframework.data.redis.core.KeyBoundCursor;
import org.springframework.data.redis.core.ScanIteration;
import org.springframework.data.redis.core.ScanOptions;
import org.springframework.util.Assert;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.Protocol;
import redis.clients.jedis.commands.SortedSetPipelineBinaryCommands;
import redis.clients.jedis.params.ScanParams;
import redis.clients.jedis.params.ZParams;
import redis.clients.jedis.params.ZRangeParams;
import redis.clients.jedis.resps.ScanResult;
import redis.clients.jedis.util.KeyValue;

@NullUnmarked
class JedisZSetCommands
implements RedisZSetCommands {
    private final JedisConnection connection;

    JedisZSetCommands(@NonNull JedisConnection connection) {
        this.connection = connection;
    }

    @Override
    public Boolean zAdd(byte @NonNull [] key, double score, byte @NonNull [] value, @NonNull RedisZSetCommands.ZAddArgs args) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        Assert.notNull((Object)value, (String)"Value must not be null");
        return (Boolean)this.connection.invoke().from(Jedis::zadd, SortedSetPipelineBinaryCommands::zadd, key, score, value, JedisConverters.toZAddParams(args)).get(Converters::toBoolean);
    }

    @Override
    public Long zAdd(byte @NonNull [] key, @NonNull Set<@NonNull Tuple> tuples, @NonNull RedisZSetCommands.ZAddArgs args) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        Assert.notNull(tuples, (String)"Tuples must not be null");
        Long count = this.connection.invoke().just(Jedis::zadd, SortedSetPipelineBinaryCommands::zadd, key, JedisConverters.toTupleMap(tuples), JedisConverters.toZAddParams(args));
        return count != null ? count : 0L;
    }

    @Override
    public Long zRem(byte @NonNull [] key, byte[] ... values) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        Assert.notNull((Object)values, (String)"Values must not be null");
        Assert.noNullElements((Object[])values, (String)"Values must not contain null elements");
        return this.connection.invoke().just(Jedis::zrem, SortedSetPipelineBinaryCommands::zrem, key, values);
    }

    @Override
    public Double zIncrBy(byte @NonNull [] key, double increment, byte @NonNull [] value) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        Assert.notNull((Object)value, (String)"Value must not be null");
        return this.connection.invoke().just(Jedis::zincrby, SortedSetPipelineBinaryCommands::zincrby, key, increment, value);
    }

    @Override
    public byte[] zRandMember(byte @NonNull [] key) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        return this.connection.invoke().just(Jedis::zrandmember, SortedSetPipelineBinaryCommands::zrandmember, key);
    }

    @Override
    public List<byte @NonNull []> zRandMember(byte @NonNull [] key, long count) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        return this.connection.invoke().fromMany(Jedis::zrandmember, SortedSetPipelineBinaryCommands::zrandmember, key, count).toList();
    }

    @Override
    public Tuple zRandMemberWithScore(byte @NonNull [] key) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        return (Tuple)this.connection.invoke().from(Jedis::zrandmemberWithScores, SortedSetPipelineBinaryCommands::zrandmemberWithScores, key, 1L).get(it -> {
            if (it.isEmpty()) {
                return null;
            }
            return JedisConverters.toTuple((redis.clients.jedis.resps.Tuple)it.iterator().next());
        });
    }

    @Override
    public List<@NonNull Tuple> zRandMemberWithScore(byte @NonNull [] key, long count) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        return this.connection.invoke().fromMany(Jedis::zrandmemberWithScores, SortedSetPipelineBinaryCommands::zrandmemberWithScores, key, count).toList(JedisConverters::toTuple);
    }

    @Override
    public Long zRank(byte @NonNull [] key, byte @NonNull [] value) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        Assert.notNull((Object)value, (String)"Value must not be null");
        return this.connection.invoke().just(Jedis::zrank, SortedSetPipelineBinaryCommands::zrank, key, value);
    }

    @Override
    public Long zRevRank(byte @NonNull [] key, byte @NonNull [] value) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        return this.connection.invoke().just(Jedis::zrevrank, SortedSetPipelineBinaryCommands::zrevrank, key, value);
    }

    @Override
    public Set<byte @NonNull []> zRange(byte @NonNull [] key, long start, long end) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        return this.connection.invoke().fromMany(Jedis::zrange, SortedSetPipelineBinaryCommands::zrange, key, start, end).toSet();
    }

    @Override
    public Set<@NonNull Tuple> zRangeWithScores(byte @NonNull [] key, long start, long end) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        return this.connection.invoke().fromMany(Jedis::zrangeWithScores, SortedSetPipelineBinaryCommands::zrangeWithScores, key, start, end).toSet(JedisConverters::toTuple);
    }

    @Override
    public Set<@NonNull Tuple> zRangeByScoreWithScores(byte @NonNull [] key, @NonNull Range<? extends Number> range, @NonNull Limit limit) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        Assert.notNull(range, (String)"Range for ZRANGEBYSCOREWITHSCORES must not be null");
        Assert.notNull((Object)limit, (String)"Limit must not be null Use Limit.unlimited() instead");
        byte[] min = JedisConverters.boundaryToBytesForZRange(range.getLowerBound(), JedisConverters.NEGATIVE_INFINITY_BYTES);
        byte[] max = JedisConverters.boundaryToBytesForZRange(range.getUpperBound(), JedisConverters.POSITIVE_INFINITY_BYTES);
        if (!limit.isUnlimited()) {
            return this.connection.invoke().fromMany(Jedis::zrangeByScoreWithScores, SortedSetPipelineBinaryCommands::zrangeByScoreWithScores, key, min, max, limit.getOffset(), limit.getCount()).toSet(JedisConverters::toTuple);
        }
        return this.connection.invoke().fromMany(Jedis::zrangeByScoreWithScores, SortedSetPipelineBinaryCommands::zrangeByScoreWithScores, key, min, max).toSet(JedisConverters::toTuple);
    }

    @Override
    public Set<byte @NonNull []> zRevRange(byte @NonNull [] key, long start, long end) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        return this.connection.invoke().fromMany(Jedis::zrevrange, SortedSetPipelineBinaryCommands::zrevrange, key, start, end).toSet();
    }

    @Override
    public Set<@NonNull Tuple> zRevRangeWithScores(byte @NonNull [] key, long start, long end) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        return this.connection.invoke().fromMany(Jedis::zrevrangeWithScores, SortedSetPipelineBinaryCommands::zrevrangeWithScores, key, start, end).toSet(JedisConverters::toTuple);
    }

    @Override
    public Set<byte @NonNull []> zRevRangeByScore(byte @NonNull [] key, @NonNull Range<? extends Number> range, @NonNull Limit limit) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        Assert.notNull(range, (String)"Range for ZREVRANGEBYSCORE must not be null");
        Assert.notNull((Object)limit, (String)"Limit must not be null Use Limit.unlimited() instead");
        byte[] min = JedisConverters.boundaryToBytesForZRange(range.getLowerBound(), JedisConverters.NEGATIVE_INFINITY_BYTES);
        byte[] max = JedisConverters.boundaryToBytesForZRange(range.getUpperBound(), JedisConverters.POSITIVE_INFINITY_BYTES);
        if (!limit.isUnlimited()) {
            return this.connection.invoke().fromMany(Jedis::zrevrangeByScore, SortedSetPipelineBinaryCommands::zrevrangeByScore, key, max, min, limit.getOffset(), limit.getCount()).toSet();
        }
        return this.connection.invoke().fromMany(Jedis::zrevrangeByScore, SortedSetPipelineBinaryCommands::zrevrangeByScore, key, max, min).toSet();
    }

    @Override
    public Set<Tuple> zRevRangeByScoreWithScores(byte @NonNull [] key, @NonNull Range<? extends Number> range, @NonNull Limit limit) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        Assert.notNull(range, (String)"Range for ZREVRANGEBYSCOREWITHSCORES must not be null");
        Assert.notNull((Object)limit, (String)"Limit must not be null Use Limit.unlimited() instead");
        byte[] min = JedisConverters.boundaryToBytesForZRange(range.getLowerBound(), JedisConverters.NEGATIVE_INFINITY_BYTES);
        byte[] max = JedisConverters.boundaryToBytesForZRange(range.getUpperBound(), JedisConverters.POSITIVE_INFINITY_BYTES);
        if (!limit.isUnlimited()) {
            return this.connection.invoke().fromMany(Jedis::zrevrangeByScoreWithScores, SortedSetPipelineBinaryCommands::zrevrangeByScoreWithScores, key, max, min, limit.getOffset(), limit.getCount()).toSet(JedisConverters::toTuple);
        }
        return this.connection.invoke().fromMany(Jedis::zrevrangeByScoreWithScores, SortedSetPipelineBinaryCommands::zrevrangeByScoreWithScores, key, max, min).toSet(JedisConverters::toTuple);
    }

    @Override
    public Long zCount(byte @NonNull [] key, double min, double max) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        return this.connection.invoke().just(Jedis::zcount, SortedSetPipelineBinaryCommands::zcount, key, min, max);
    }

    @Override
    public Long zCount(byte @NonNull [] key, @NonNull Range<? extends Number> range) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        Assert.notNull(range, (String)"Range must not be null");
        byte[] min = JedisConverters.boundaryToBytesForZRange(range.getLowerBound(), JedisConverters.NEGATIVE_INFINITY_BYTES);
        byte[] max = JedisConverters.boundaryToBytesForZRange(range.getUpperBound(), JedisConverters.POSITIVE_INFINITY_BYTES);
        return this.connection.invoke().just(Jedis::zcount, SortedSetPipelineBinaryCommands::zcount, key, min, max);
    }

    @Override
    public Long zLexCount(byte @NonNull [] key, @NonNull Range<byte[]> range) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        Assert.notNull(range, (String)"Range must not be null");
        byte[] min = JedisConverters.boundaryToBytesForZRangeByLex((Range.Bound<byte[]>)range.getLowerBound(), JedisConverters.MINUS_BYTES);
        byte[] max = JedisConverters.boundaryToBytesForZRangeByLex((Range.Bound<byte[]>)range.getUpperBound(), JedisConverters.PLUS_BYTES);
        return this.connection.invoke().just(Jedis::zlexcount, SortedSetPipelineBinaryCommands::zlexcount, key, min, max);
    }

    @Override
    public Tuple zPopMin(byte @NonNull [] key) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        return (Tuple)this.connection.invoke().from(Jedis::zpopmin, SortedSetPipelineBinaryCommands::zpopmin, key).get(JedisConverters::toTuple);
    }

    @Override
    public Set<Tuple> zPopMin(byte @NonNull [] key, long count) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        return this.connection.invoke().fromMany(Jedis::zpopmin, SortedSetPipelineBinaryCommands::zpopmin, key, Math.toIntExact(count)).toSet(JedisConverters::toTuple);
    }

    @Override
    public Tuple bZPopMin(byte @NonNull [] key, long timeout, @NonNull TimeUnit unit) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        Assert.notNull((Object)((Object)unit), (String)"TimeUnit must not be null");
        return (Tuple)this.connection.invoke().from((rec$, x$0, xva$1) -> rec$.bzpopmin(x$0.doubleValue(), (byte[][])new byte[][]{xva$1}), (rec$, x$0, xva$1) -> rec$.bzpopmin((double)x$0, new byte[][]{xva$1}), JedisConverters.toSeconds(timeout, unit), key).get(JedisZSetCommands::toTuple);
    }

    @Override
    public Tuple zPopMax(byte @NonNull [] key) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        return (Tuple)this.connection.invoke().from(Jedis::zpopmax, SortedSetPipelineBinaryCommands::zpopmax, key).get(JedisConverters::toTuple);
    }

    @Override
    public Set<@NonNull Tuple> zPopMax(byte @NonNull [] key, long count) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        return this.connection.invoke().fromMany(Jedis::zpopmax, SortedSetPipelineBinaryCommands::zpopmax, key, Math.toIntExact(count)).toSet(JedisConverters::toTuple);
    }

    @Override
    public Tuple bZPopMax(byte @NonNull [] key, long timeout, @NonNull TimeUnit unit) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        Assert.notNull((Object)((Object)unit), (String)"TimeUnit must not be null");
        return (Tuple)this.connection.invoke().from((rec$, x$0, xva$1) -> rec$.bzpopmax(x$0.doubleValue(), (byte[][])new byte[][]{xva$1}), (rec$, x$0, xva$1) -> rec$.bzpopmax((double)x$0, new byte[][]{xva$1}), JedisConverters.toSeconds(timeout, unit), key).get(JedisZSetCommands::toTuple);
    }

    @Override
    public Long zCard(byte @NonNull [] key) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        return this.connection.invoke().just(Jedis::zcard, SortedSetPipelineBinaryCommands::zcard, key);
    }

    @Override
    public Double zScore(byte @NonNull [] key, byte @NonNull [] value) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        Assert.notNull((Object)value, (String)"Value must not be null");
        return this.connection.invoke().just(Jedis::zscore, SortedSetPipelineBinaryCommands::zscore, key, value);
    }

    @Override
    public List<@NonNull Double> zMScore(byte @NonNull [] key, byte @NonNull [] @NonNull [] values) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        Assert.notNull((Object)values, (String)"Value must not be null");
        return this.connection.invoke().just(Jedis::zmscore, SortedSetPipelineBinaryCommands::zmscore, key, values);
    }

    @Override
    public Long zRemRange(byte @NonNull [] key, long start, long end) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        return this.connection.invoke().just(Jedis::zremrangeByRank, SortedSetPipelineBinaryCommands::zremrangeByRank, key, start, end);
    }

    @Override
    public Long zRemRangeByLex(byte @NonNull [] key, @NonNull Range<byte[]> range) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        Assert.notNull(range, (String)"Range must not be null for ZREMRANGEBYLEX");
        byte[] min = JedisConverters.boundaryToBytesForZRangeByLex((Range.Bound<byte[]>)range.getLowerBound(), JedisConverters.MINUS_BYTES);
        byte[] max = JedisConverters.boundaryToBytesForZRangeByLex((Range.Bound<byte[]>)range.getUpperBound(), JedisConverters.PLUS_BYTES);
        return this.connection.invoke().just(Jedis::zremrangeByLex, SortedSetPipelineBinaryCommands::zremrangeByLex, key, min, max);
    }

    @Override
    public Long zRemRangeByScore(byte @NonNull [] key, @NonNull Range<? extends Number> range) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        Assert.notNull(range, (String)"Range for ZREMRANGEBYSCORE must not be null");
        byte[] min = JedisConverters.boundaryToBytesForZRange(range.getLowerBound(), JedisConverters.NEGATIVE_INFINITY_BYTES);
        byte[] max = JedisConverters.boundaryToBytesForZRange(range.getUpperBound(), JedisConverters.POSITIVE_INFINITY_BYTES);
        return this.connection.invoke().just(Jedis::zremrangeByScore, SortedSetPipelineBinaryCommands::zremrangeByScore, key, min, max);
    }

    @Override
    public Set<byte @NonNull []> zDiff(byte[] ... sets) {
        Assert.notNull((Object)sets, (String)"Sets must not be null");
        return this.connection.invoke().fromMany(Jedis::zdiff, SortedSetPipelineBinaryCommands::zdiff, sets).toSet();
    }

    @Override
    public Set<@NonNull Tuple> zDiffWithScores(byte[] ... sets) {
        Assert.notNull((Object)sets, (String)"Sets must not be null");
        return this.connection.invoke().fromMany(Jedis::zdiffWithScores, SortedSetPipelineBinaryCommands::zdiffWithScores, sets).toSet(JedisConverters::toTuple);
    }

    @Override
    public Long zDiffStore(byte @NonNull [] destKey, byte[] ... sets) {
        Assert.notNull((Object)destKey, (String)"Destination key must not be null");
        Assert.notNull((Object)sets, (String)"Source sets must not be null");
        return this.connection.invoke().just(Jedis::zdiffStore, SortedSetPipelineBinaryCommands::zdiffStore, destKey, sets);
    }

    @Override
    public Set<byte @NonNull []> zInter(byte[] ... sets) {
        Assert.notNull((Object)sets, (String)"Sets must not be null");
        return this.connection.invoke().fromMany(Jedis::zinter, SortedSetPipelineBinaryCommands::zinter, new ZParams(), sets).toSet();
    }

    @Override
    public Set<@NonNull Tuple> zInterWithScores(byte[] ... sets) {
        Assert.notNull((Object)sets, (String)"Sets must not be null");
        return this.connection.invoke().fromMany(Jedis::zinterWithScores, SortedSetPipelineBinaryCommands::zinterWithScores, new ZParams(), sets).toSet(JedisConverters::toTuple);
    }

    @Override
    public Set<@NonNull Tuple> zInterWithScores(@NonNull Aggregate aggregate, @NonNull Weights weights, byte[] ... sets) {
        Assert.notNull((Object)sets, (String)"Sets must not be null");
        Assert.noNullElements((Object[])sets, (String)"Source sets must not contain null elements");
        Assert.isTrue((weights.size() == sets.length ? 1 : 0) != 0, (String)"The number of weights (%d) must match the number of source sets (%d)".formatted(weights.size(), sets.length));
        return this.connection.invoke().fromMany(Jedis::zinterWithScores, SortedSetPipelineBinaryCommands::zinterWithScores, JedisZSetCommands.toZParams(aggregate, weights), sets).toSet(JedisConverters::toTuple);
    }

    @Override
    public Long zInterStore(byte @NonNull [] destKey, @NonNull Aggregate aggregate, @NonNull Weights weights, byte[] ... sets) {
        Assert.notNull((Object)destKey, (String)"Destination key must not be null");
        Assert.notNull((Object)sets, (String)"Source sets must not be null");
        Assert.noNullElements((Object[])sets, (String)"Source sets must not contain null elements");
        Assert.isTrue((weights.size() == sets.length ? 1 : 0) != 0, (String)"The number of weights %d must match the number of source sets %d".formatted(weights.size(), sets.length));
        ZParams zparams = JedisZSetCommands.toZParams(aggregate, weights);
        return this.connection.invoke().just(Jedis::zinterstore, SortedSetPipelineBinaryCommands::zinterstore, destKey, zparams, sets);
    }

    @Override
    public Long zInterStore(byte @NonNull [] destKey, byte[] ... sets) {
        Assert.notNull((Object)destKey, (String)"Destination key must not be null");
        Assert.notNull((Object)sets, (String)"Source sets must not be null");
        Assert.noNullElements((Object[])sets, (String)"Source sets must not contain null elements");
        return this.connection.invoke().just(Jedis::zinterstore, SortedSetPipelineBinaryCommands::zinterstore, destKey, sets);
    }

    @Override
    public Set<byte @NonNull []> zUnion(byte[] ... sets) {
        Assert.notNull((Object)sets, (String)"Sets must not be null");
        return this.connection.invoke().fromMany(Jedis::zunion, SortedSetPipelineBinaryCommands::zunion, new ZParams(), sets).toSet();
    }

    @Override
    public Set<@NonNull Tuple> zUnionWithScores(byte[] ... sets) {
        Assert.notNull((Object)sets, (String)"Sets must not be null");
        return this.connection.invoke().fromMany(Jedis::zunionWithScores, SortedSetPipelineBinaryCommands::zunionWithScores, new ZParams(), sets).toSet(JedisConverters::toTuple);
    }

    @Override
    public Set<@NonNull Tuple> zUnionWithScores(@NonNull Aggregate aggregate, @NonNull Weights weights, byte[] ... sets) {
        Assert.notNull((Object)sets, (String)"Sets must not be null");
        Assert.noNullElements((Object[])sets, (String)"Source sets must not contain null elements");
        Assert.isTrue((weights.size() == sets.length ? 1 : 0) != 0, (String)"The number of weights %d must match the number of source sets %d".formatted(weights.size(), sets.length));
        return this.connection.invoke().fromMany(Jedis::zunionWithScores, SortedSetPipelineBinaryCommands::zunionWithScores, JedisZSetCommands.toZParams(aggregate, weights), sets).toSet(JedisConverters::toTuple);
    }

    @Override
    public Long zUnionStore(byte @NonNull [] destKey, @NonNull Aggregate aggregate, @NonNull Weights weights, byte[] ... sets) {
        Assert.notNull((Object)destKey, (String)"Destination key must not be null");
        Assert.notNull((Object)sets, (String)"Source sets must not be null");
        Assert.notNull((Object)weights, (String)"Weights must not be null");
        Assert.noNullElements((Object[])sets, (String)"Source sets must not contain null elements");
        Assert.isTrue((weights.size() == sets.length ? 1 : 0) != 0, (String)"The number of weights %d must match the number of source sets %d".formatted(weights.size(), sets.length));
        ZParams zparams = JedisZSetCommands.toZParams(aggregate, weights);
        return this.connection.invoke().just(Jedis::zunionstore, SortedSetPipelineBinaryCommands::zunionstore, destKey, zparams, sets);
    }

    @Override
    public Long zUnionStore(byte @NonNull [] destKey, byte[] ... sets) {
        Assert.notNull((Object)destKey, (String)"Destination key must not be null");
        Assert.notNull((Object)sets, (String)"Source sets must not be null");
        Assert.noNullElements((Object[])sets, (String)"Source sets must not contain null elements");
        return this.connection.invoke().just(Jedis::zunionstore, SortedSetPipelineBinaryCommands::zunionstore, destKey, sets);
    }

    @Override
    public Cursor<@NonNull Tuple> zScan(byte @NonNull [] key, @NonNull ScanOptions options) {
        return this.zScan(key, Cursor.CursorId.initial(), options);
    }

    public Cursor<@NonNull Tuple> zScan(byte @NonNull [] key, @NonNull Cursor.CursorId cursorId, @NonNull ScanOptions options) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        return new KeyBoundCursor<Tuple>(key, cursorId, options){

            @Override
            protected ScanIteration<Tuple> doScan(byte @NonNull [] key, @NonNull Cursor.CursorId cursorId, @NonNull ScanOptions options) {
                if (JedisZSetCommands.this.isQueueing() || JedisZSetCommands.this.isPipelined()) {
                    throw new InvalidDataAccessApiUsageException("'ZSCAN' cannot be called in pipeline / transaction mode");
                }
                ScanParams params = JedisConverters.toScanParams(options);
                ScanResult result = JedisZSetCommands.this.connection.getJedis().zscan(key, JedisConverters.toBytes(cursorId), params);
                return new ScanIteration<Tuple>(Cursor.CursorId.of(result.getCursor()), JedisConverters.tuplesToTuples().convert(result.getResult()));
            }

            @Override
            protected void doClose() {
                JedisZSetCommands.this.connection.close();
            }
        }.open();
    }

    @Override
    public Set<byte @NonNull []> zRangeByScore(byte @NonNull [] key, @NonNull String min, @NonNull String max) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        return this.connection.invoke().fromMany(Jedis::zrangeByScore, SortedSetPipelineBinaryCommands::zrangeByScore, key, JedisConverters.toBytes(min), JedisConverters.toBytes(max)).toSet();
    }

    @Override
    public Set<byte @NonNull []> zRangeByScore(byte @NonNull [] key, @NonNull String min, @NonNull String max, long offset, long count) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        if (offset > Integer.MAX_VALUE || count > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Offset and count must be less than Integer.MAX_VALUE for zRangeByScore in Jedis");
        }
        return this.connection.invoke().fromMany(Jedis::zrangeByScore, SortedSetPipelineBinaryCommands::zrangeByScore, key, JedisConverters.toBytes(min), JedisConverters.toBytes(max), (int)offset, (int)count).toSet();
    }

    @Override
    public Set<byte @NonNull []> zRangeByScore(byte @NonNull [] key, @NonNull Range<? extends Number> range, @NonNull Limit limit) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        Assert.notNull(range, (String)"Range for ZRANGEBYSCORE must not be null");
        Assert.notNull((Object)limit, (String)"Limit must not be null Use Limit.unlimited() instead");
        byte[] min = JedisConverters.boundaryToBytesForZRange(range.getLowerBound(), JedisConverters.NEGATIVE_INFINITY_BYTES);
        byte[] max = JedisConverters.boundaryToBytesForZRange(range.getUpperBound(), JedisConverters.POSITIVE_INFINITY_BYTES);
        if (!limit.isUnlimited()) {
            return this.connection.invoke().fromMany(Jedis::zrangeByScore, SortedSetPipelineBinaryCommands::zrangeByScore, key, min, max, limit.getOffset(), limit.getCount()).toSet();
        }
        return this.connection.invoke().fromMany(Jedis::zrangeByScore, SortedSetPipelineBinaryCommands::zrangeByScore, key, min, max).toSet();
    }

    @Override
    public Set<byte @NonNull []> zRangeByLex(byte @NonNull [] key, @NonNull Range<byte[]> range, @NonNull Limit limit) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        Assert.notNull(range, (String)"Range for ZRANGEBYLEX must not be null");
        Assert.notNull((Object)limit, (String)"Limit must not be null Use Limit.unlimited() instead");
        byte[] min = JedisConverters.boundaryToBytesForZRangeByLex((Range.Bound<byte[]>)range.getLowerBound(), JedisConverters.MINUS_BYTES);
        byte[] max = JedisConverters.boundaryToBytesForZRangeByLex((Range.Bound<byte[]>)range.getUpperBound(), JedisConverters.PLUS_BYTES);
        if (!limit.isUnlimited()) {
            return this.connection.invoke().fromMany(Jedis::zrangeByLex, SortedSetPipelineBinaryCommands::zrangeByLex, key, min, max, limit.getOffset(), limit.getCount()).toSet();
        }
        return this.connection.invoke().fromMany(Jedis::zrangeByLex, SortedSetPipelineBinaryCommands::zrangeByLex, key, min, max).toSet();
    }

    @Override
    public Set<byte @NonNull []> zRevRangeByLex(byte @NonNull [] key, @NonNull Range<byte[]> range, @NonNull Limit limit) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        Assert.notNull(range, (String)"Range for ZREVRANGEBYLEX must not be null");
        Assert.notNull((Object)limit, (String)"Limit must not be null Use Limit.unlimited() instead.");
        byte[] min = JedisConverters.boundaryToBytesForZRangeByLex((Range.Bound<byte[]>)range.getLowerBound(), JedisConverters.MINUS_BYTES);
        byte[] max = JedisConverters.boundaryToBytesForZRangeByLex((Range.Bound<byte[]>)range.getUpperBound(), JedisConverters.PLUS_BYTES);
        if (!limit.isUnlimited()) {
            return (Set)this.connection.invoke().from(Jedis::zrevrangeByLex, SortedSetPipelineBinaryCommands::zrevrangeByLex, key, max, min, limit.getOffset(), limit.getCount()).get(LinkedHashSet::new);
        }
        return (Set)this.connection.invoke().from(Jedis::zrevrangeByLex, SortedSetPipelineBinaryCommands::zrevrangeByLex, key, max, min).get(LinkedHashSet::new);
    }

    @Override
    public Long zRangeStoreByLex(byte @NonNull [] dstKey, byte @NonNull [] srcKey, @NonNull Range<byte[]> range, @NonNull Limit limit) {
        return this.zRangeStoreByLex(dstKey, srcKey, range, limit, false);
    }

    @Override
    public Long zRangeStoreRevByLex(byte @NonNull [] dstKey, byte @NonNull [] srcKey, @NonNull Range<byte[]> range, @NonNull Limit limit) {
        return this.zRangeStoreByLex(dstKey, srcKey, range, limit, true);
    }

    private Long zRangeStoreByLex(byte @NonNull [] dstKey, byte @NonNull [] srcKey, @NonNull Range<byte[]> range, @NonNull Limit limit, boolean rev) {
        Assert.notNull((Object)dstKey, (String)"Destination key must not be null");
        Assert.notNull((Object)srcKey, (String)"Source key must not be null");
        Assert.notNull(range, (String)"Range must not be null");
        Assert.notNull((Object)limit, (String)"Limit must not be null. Use Limit.unlimited() instead.");
        byte[] min = JedisConverters.boundaryToBytesForZRangeByLex((Range.Bound<byte[]>)range.getLowerBound(), JedisConverters.MINUS_BYTES);
        byte[] max = JedisConverters.boundaryToBytesForZRangeByLex((Range.Bound<byte[]>)range.getUpperBound(), JedisConverters.PLUS_BYTES);
        ZRangeParams zRangeParams = JedisZSetCommands.toZRangeParams(Protocol.Keyword.BYLEX, min, max, limit, rev);
        return this.connection.invoke().just(Jedis::zrangestore, SortedSetPipelineBinaryCommands::zrangestore, dstKey, srcKey, zRangeParams);
    }

    @Override
    public Long zRangeStoreByScore(byte @NonNull [] dstKey, byte @NonNull [] srcKey, @NonNull Range<? extends Number> range, @NonNull Limit limit) {
        return this.zRangeStoreByScore(dstKey, srcKey, range, limit, false);
    }

    @Override
    public Long zRangeStoreRevByScore(byte @NonNull [] dstKey, byte @NonNull [] srcKey, @NonNull Range<? extends Number> range, @NonNull Limit limit) {
        return this.zRangeStoreByScore(dstKey, srcKey, range, limit, true);
    }

    private Long zRangeStoreByScore(byte @NonNull [] dstKey, byte @NonNull [] srcKey, @NonNull Range<? extends Number> range, @NonNull Limit limit, boolean rev) {
        Assert.notNull((Object)dstKey, (String)"Destination key must not be null");
        Assert.notNull((Object)srcKey, (String)"Source key must not be null");
        Assert.notNull(range, (String)"Range must not be null");
        Assert.notNull((Object)limit, (String)"Limit must not be null. Use Limit.unlimited() instead.");
        byte[] min = JedisConverters.boundaryToBytesForZRange(range.getLowerBound(), JedisConverters.NEGATIVE_INFINITY_BYTES);
        byte[] max = JedisConverters.boundaryToBytesForZRange(range.getUpperBound(), JedisConverters.POSITIVE_INFINITY_BYTES);
        ZRangeParams zRangeParams = JedisZSetCommands.toZRangeParams(Protocol.Keyword.BYSCORE, min, max, limit, rev);
        return this.connection.invoke().just(Jedis::zrangestore, SortedSetPipelineBinaryCommands::zrangestore, dstKey, srcKey, zRangeParams);
    }

    private boolean isPipelined() {
        return this.connection.isPipelined();
    }

    private boolean isQueueing() {
        return this.connection.isQueueing();
    }

    private static ZParams toZParams(Aggregate aggregate, Weights weights) {
        return new ZParams().weights(weights.toArray()).aggregate(ZParams.Aggregate.valueOf((String)aggregate.name()));
    }

    static ZRangeParams toZRangeParams(Protocol.Keyword by, byte[] min, byte[] max, Limit limit, boolean rev) {
        ZRangeParams zRangeParams = rev ? new ZRangeParams(by, max, min).rev() : new ZRangeParams(by, min, max);
        if (limit.isLimited()) {
            zRangeParams = zRangeParams.limit(limit.getOffset(), limit.getCount());
        }
        return zRangeParams;
    }

    private static @Nullable Tuple toTuple(@Nullable KeyValue<?, redis.clients.jedis.resps.Tuple> keyValue) {
        return keyValue != null ? JedisConverters.toTuple((redis.clients.jedis.resps.Tuple)keyValue.getValue()) : null;
    }
}

