/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection;

import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.NullUnmarked;
import org.jspecify.annotations.Nullable;
import org.springframework.data.domain.Range;
import org.springframework.data.redis.connection.Limit;
import org.springframework.data.redis.connection.stream.ByteRecord;
import org.springframework.data.redis.connection.stream.Consumer;
import org.springframework.data.redis.connection.stream.MapRecord;
import org.springframework.data.redis.connection.stream.PendingMessages;
import org.springframework.data.redis.connection.stream.PendingMessagesSummary;
import org.springframework.data.redis.connection.stream.ReadOffset;
import org.springframework.data.redis.connection.stream.RecordId;
import org.springframework.data.redis.connection.stream.StreamInfo;
import org.springframework.data.redis.connection.stream.StreamOffset;
import org.springframework.data.redis.connection.stream.StreamReadOptions;
import org.springframework.data.redis.connection.stream.StreamRecords;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@NullUnmarked
public interface RedisStreamCommands {
    default public Long xAck(byte @NonNull [] key, @NonNull String group, String ... recordIds) {
        return this.xAck(key, group, (RecordId[])Arrays.stream(recordIds).map(RecordId::of).toArray(RecordId[]::new));
    }

    public Long xAck(byte @NonNull [] var1, @NonNull String var2, RecordId ... var3);

    default public RecordId xAdd(byte @NonNull [] key, @NonNull Map<byte @NonNull [], byte @NonNull []> content) {
        return this.xAdd(StreamRecords.newRecord().in(key).ofMap(content));
    }

    default public RecordId xAdd(@NonNull MapRecord<byte[], byte[], byte[]> record) {
        return this.xAdd(record, XAddOptions.none());
    }

    public RecordId xAdd(MapRecord<byte[], byte[], byte[]> var1, @NonNull XAddOptions var2);

    public List<@NonNull RecordId> xClaimJustId(byte @NonNull [] var1, @NonNull String var2, @NonNull String var3, @NonNull XClaimOptions var4);

    default public List<@NonNull ByteRecord> xClaim(byte @NonNull [] key, @NonNull String group, @NonNull String newOwner, @NonNull Duration minIdleTime, RecordId ... recordIds) {
        return this.xClaim(key, group, newOwner, XClaimOptions.minIdle(minIdleTime).ids(recordIds));
    }

    public List<@NonNull ByteRecord> xClaim(byte @NonNull [] var1, @NonNull String var2, @NonNull String var3, @NonNull XClaimOptions var4);

    default public Long xDel(byte @NonNull [] key, String ... recordIds) {
        return this.xDel(key, (RecordId[])Arrays.stream(recordIds).map(RecordId::of).toArray(RecordId[]::new));
    }

    public Long xDel(byte @NonNull [] var1, RecordId ... var2);

    public String xGroupCreate(byte @NonNull [] var1, @NonNull String var2, @NonNull ReadOffset var3);

    public String xGroupCreate(byte @NonNull [] var1, @NonNull String var2, @NonNull ReadOffset var3, boolean var4);

    default public Boolean xGroupDelConsumer(byte @NonNull [] key, @NonNull String groupName, @NonNull String consumerName) {
        return this.xGroupDelConsumer(key, Consumer.from(groupName, consumerName));
    }

    public Boolean xGroupDelConsumer(byte @NonNull [] var1, @NonNull Consumer var2);

    public Boolean xGroupDestroy(byte @NonNull [] var1, @NonNull String var2);

    public StreamInfo.XInfoStream xInfo(byte @NonNull [] var1);

    public StreamInfo.XInfoGroups xInfoGroups(byte @NonNull [] var1);

    public StreamInfo.XInfoConsumers xInfoConsumers(byte @NonNull [] var1, @NonNull String var2);

    public Long xLen(byte @NonNull [] var1);

    public @Nullable PendingMessagesSummary xPending(byte @NonNull [] var1, @NonNull String var2);

    default public PendingMessages xPending(byte @NonNull [] key, @NonNull Consumer consumer) {
        return this.xPending(key, consumer.getGroup(), consumer.getName());
    }

    default public PendingMessages xPending(byte @NonNull [] key, @NonNull String groupName, @NonNull String consumerName) {
        return this.xPending(key, groupName, XPendingOptions.unbounded().consumer(consumerName));
    }

    default public PendingMessages xPending(byte @NonNull [] key, @NonNull String groupName, @NonNull Range<?> range, @NonNull Long count) {
        return this.xPending(key, groupName, XPendingOptions.range(range, count));
    }

    default public PendingMessages xPending(byte[] key, String groupName, Range<?> range, Long count, Duration idle) {
        return this.xPending(key, groupName, XPendingOptions.range(range, count).minIdleTime(idle));
    }

    default public PendingMessages xPending(byte @NonNull [] key, @NonNull Consumer consumer, @NonNull Range<?> range, @NonNull Long count) {
        return this.xPending(key, consumer.getGroup(), consumer.getName(), range, count);
    }

    default public PendingMessages xPending(byte[] key, Consumer consumer, Range<?> range, Long count, Duration minIdleTime) {
        return this.xPending(key, consumer.getGroup(), consumer.getName(), range, count, minIdleTime);
    }

    default public PendingMessages xPending(byte @NonNull [] key, @NonNull String groupName, @NonNull String consumerName, @NonNull Range<?> range, @NonNull Long count) {
        return this.xPending(key, groupName, XPendingOptions.range(range, count).consumer(consumerName));
    }

    default public PendingMessages xPending(byte[] key, String groupName, String consumerName, Range<?> range, Long count, Duration idle) {
        return this.xPending(key, groupName, XPendingOptions.range(range, count).consumer(consumerName).minIdleTime(idle));
    }

    public PendingMessages xPending(byte @NonNull [] var1, @NonNull String var2, @NonNull XPendingOptions var3);

    default public List<@NonNull ByteRecord> xRange(byte @NonNull [] key, @NonNull Range<@NonNull String> range) {
        return this.xRange(key, range, Limit.unlimited());
    }

    public List<@NonNull ByteRecord> xRange(byte @NonNull [] var1, @NonNull Range<@NonNull String> var2, @NonNull Limit var3);

    default public List<@NonNull ByteRecord> xRead(StreamOffset<byte[]> ... streams) {
        return this.xRead(StreamReadOptions.empty(), streams);
    }

    public List<@NonNull ByteRecord> xRead(@NonNull StreamReadOptions var1, StreamOffset<byte[]> ... var2);

    default public List<@NonNull ByteRecord> xReadGroup(@NonNull Consumer consumer, StreamOffset<byte[]> ... streams) {
        return this.xReadGroup(consumer, StreamReadOptions.empty(), streams);
    }

    public List<@NonNull ByteRecord> xReadGroup(@NonNull Consumer var1, @NonNull StreamReadOptions var2, StreamOffset<byte[]> ... var3);

    default public List<@NonNull ByteRecord> xRevRange(byte @NonNull [] key, @NonNull Range<@NonNull String> range) {
        return this.xRevRange(key, range, Limit.unlimited());
    }

    public List<@NonNull ByteRecord> xRevRange(byte @NonNull [] var1, @NonNull Range<@NonNull String> var2, @NonNull Limit var3);

    public Long xTrim(byte @NonNull [] var1, long var2);

    public Long xTrim(byte @NonNull [] var1, long var2, boolean var4);

    @NullMarked
    public static class XAddOptions {
        private static final XAddOptions NONE = new XAddOptions(null, false, false, null);
        private final @Nullable Long maxlen;
        private final boolean nomkstream;
        private final boolean approximateTrimming;
        private final @Nullable RecordId minId;

        private XAddOptions(@Nullable Long maxlen, boolean nomkstream, boolean approximateTrimming, @Nullable RecordId minId) {
            this.maxlen = maxlen;
            this.nomkstream = nomkstream;
            this.approximateTrimming = approximateTrimming;
            this.minId = minId;
        }

        public static XAddOptions none() {
            return NONE;
        }

        public static XAddOptions makeNoStream() {
            return new XAddOptions(null, true, false, null);
        }

        public static XAddOptions makeNoStream(boolean makeNoStream) {
            return new XAddOptions(null, makeNoStream, false, null);
        }

        public static XAddOptions maxlen(long maxlen) {
            return new XAddOptions(maxlen, false, false, null);
        }

        public XAddOptions minId(RecordId minId) {
            return new XAddOptions(this.maxlen, this.nomkstream, this.approximateTrimming, minId);
        }

        public XAddOptions approximateTrimming(boolean approximateTrimming) {
            return new XAddOptions(this.maxlen, this.nomkstream, approximateTrimming, this.minId);
        }

        public boolean isNoMkStream() {
            return this.nomkstream;
        }

        public @Nullable Long getMaxlen() {
            return this.maxlen;
        }

        public boolean hasMaxlen() {
            return this.maxlen != null;
        }

        public boolean isApproximateTrimming() {
            return this.approximateTrimming;
        }

        public @Nullable RecordId getMinId() {
            return this.minId;
        }

        public boolean hasMinId() {
            return this.minId != null;
        }

        public boolean equals(@Nullable Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof XAddOptions)) {
                return false;
            }
            XAddOptions that = (XAddOptions)o;
            if (this.nomkstream != that.nomkstream) {
                return false;
            }
            if (this.approximateTrimming != that.approximateTrimming) {
                return false;
            }
            if (!ObjectUtils.nullSafeEquals((Object)this.maxlen, (Object)that.maxlen)) {
                return false;
            }
            return ObjectUtils.nullSafeEquals((Object)this.minId, (Object)that.minId);
        }

        public int hashCode() {
            int result = ObjectUtils.nullSafeHashCode((Object)this.maxlen);
            result = 31 * result + (this.nomkstream ? 1 : 0);
            result = 31 * result + (this.approximateTrimming ? 1 : 0);
            result = 31 * result + ObjectUtils.nullSafeHashCode((Object)this.minId);
            return result;
        }
    }

    @NullMarked
    public static class XClaimOptions {
        private final List<RecordId> ids;
        private final Duration minIdleTime;
        private final @Nullable Duration idleTime;
        private final @Nullable Instant unixTime;
        private final @Nullable Long retryCount;
        private final boolean force;

        private XClaimOptions(List<RecordId> ids, Duration minIdleTime, @Nullable Duration idleTime, @Nullable Instant unixTime, @Nullable Long retryCount, boolean force) {
            this.ids = new ArrayList<RecordId>(ids);
            this.minIdleTime = minIdleTime;
            this.idleTime = idleTime;
            this.unixTime = unixTime;
            this.retryCount = retryCount;
            this.force = force;
        }

        public static XClaimOptionsBuilder minIdle(Duration minIdleTime) {
            return new XClaimOptionsBuilder(minIdleTime);
        }

        public static XClaimOptionsBuilder minIdleMs(long millis) {
            return XClaimOptions.minIdle(Duration.ofMillis(millis));
        }

        public XClaimOptions idle(Duration idleTime) {
            return new XClaimOptions(this.ids, this.minIdleTime, idleTime, this.unixTime, this.retryCount, this.force);
        }

        public XClaimOptions time(Instant unixTime) {
            return new XClaimOptions(this.ids, this.minIdleTime, this.idleTime, unixTime, this.retryCount, this.force);
        }

        public XClaimOptions retryCount(long retryCount) {
            return new XClaimOptions(this.ids, this.minIdleTime, this.idleTime, this.unixTime, retryCount, this.force);
        }

        public XClaimOptions force() {
            return new XClaimOptions(this.ids, this.minIdleTime, this.idleTime, this.unixTime, this.retryCount, true);
        }

        public List<RecordId> getIds() {
            return this.ids;
        }

        public String[] getIdsAsStringArray() {
            return (String[])this.getIds().stream().map(RecordId::getValue).toArray(String[]::new);
        }

        public Duration getMinIdleTime() {
            return this.minIdleTime;
        }

        public @Nullable Duration getIdleTime() {
            return this.idleTime;
        }

        public @Nullable Instant getUnixTime() {
            return this.unixTime;
        }

        public @Nullable Long getRetryCount() {
            return this.retryCount;
        }

        public boolean isForce() {
            return this.force;
        }

        @NullMarked
        public static class XClaimOptionsBuilder {
            private final Duration minIdleTime;

            XClaimOptionsBuilder(Duration minIdleTime) {
                Assert.notNull((Object)minIdleTime, (String)"Min idle time must not be null");
                this.minIdleTime = minIdleTime;
            }

            public XClaimOptions ids(List<?> ids) {
                List<RecordId> idList = ids.stream().map(it -> it instanceof RecordId ? (RecordId)it : RecordId.of(it.toString())).collect(Collectors.toList());
                return new XClaimOptions(idList, this.minIdleTime, null, null, null, false);
            }

            public XClaimOptions ids(RecordId ... ids) {
                return this.ids(Arrays.asList(ids));
            }

            public XClaimOptions ids(String ... ids) {
                return this.ids(Arrays.asList(ids));
            }
        }
    }

    @NullMarked
    public static class XPendingOptions {
        private final @Nullable String consumerName;
        private final Range<?> range;
        private final @Nullable Long count;
        private final @Nullable Duration minIdleTime;

        private XPendingOptions(@Nullable String consumerName, Range<?> range, @Nullable Long count, @Nullable Duration minIdleTime) {
            this.range = range;
            this.count = count;
            this.consumerName = consumerName;
            this.minIdleTime = minIdleTime;
        }

        public static XPendingOptions unbounded() {
            return new XPendingOptions(null, Range.unbounded(), null, null);
        }

        public static XPendingOptions unbounded(Long count) {
            Assert.isTrue((count > -1L ? 1 : 0) != 0, (String)"Count must not be negative");
            return new XPendingOptions(null, Range.unbounded(), count, null);
        }

        public static XPendingOptions range(Range<?> range, Long count) {
            Assert.notNull(range, (String)"Range must not be null");
            Assert.isTrue((count > -1L ? 1 : 0) != 0, (String)"Count must not be negative");
            return new XPendingOptions(null, range, count, null);
        }

        public XPendingOptions consumer(String consumerName) {
            Assert.notNull((Object)consumerName, (String)"Consumer name must not be null");
            return new XPendingOptions(consumerName, this.range, this.count, this.minIdleTime);
        }

        public XPendingOptions minIdleTime(@Nullable Duration minIdleTime) {
            Assert.notNull((Object)minIdleTime, (String)"Idle must not be null");
            return new XPendingOptions(this.consumerName, this.range, this.count, minIdleTime);
        }

        XPendingOptions withRange(Range<?> range, Long count) {
            return new XPendingOptions(this.consumerName, range, count, this.minIdleTime);
        }

        public Range<?> getRange() {
            return this.range;
        }

        public @Nullable Long getCount() {
            return this.count;
        }

        public @Nullable String getConsumerName() {
            return this.consumerName;
        }

        public @Nullable Duration getMinIdleTime() {
            return this.minIdleTime;
        }

        public boolean hasConsumer() {
            return StringUtils.hasText((String)this.consumerName);
        }

        public boolean isLimited() {
            return this.count != null;
        }

        public boolean hasMinIdleTime() {
            return this.minIdleTime != null;
        }
    }
}

