/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection;

import org.jspecify.annotations.Nullable;
import org.springframework.data.redis.connection.RedisConfiguration;
import org.springframework.data.redis.connection.RedisPassword;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public class RedisSocketConfiguration
implements RedisConfiguration,
RedisConfiguration.DomainSocketConfiguration {
    private static final String DEFAULT_SOCKET = "/tmp/redis.sock";
    private String socket = "/tmp/redis.sock";
    private int database;
    private @Nullable String username = null;
    private RedisPassword password = RedisPassword.none();

    public RedisSocketConfiguration() {
    }

    public RedisSocketConfiguration(String socket) {
        Assert.hasText((String)socket, (String)"Socket path must not be null nor empty");
        this.socket = socket;
    }

    @Override
    public String getSocket() {
        return this.socket;
    }

    @Override
    public void setSocket(String socket) {
        Assert.hasText((String)socket, (String)"Socket must not be null nor empty");
        this.socket = socket;
    }

    @Override
    public int getDatabase() {
        return this.database;
    }

    @Override
    public void setDatabase(int index) {
        Assert.isTrue((index >= 0 ? 1 : 0) != 0, () -> "Invalid DB index '%s'; non-negative index required".formatted(index));
        this.database = index;
    }

    @Override
    public void setUsername(@Nullable String username) {
        this.username = username;
    }

    @Override
    public @Nullable String getUsername() {
        return this.username;
    }

    @Override
    public RedisPassword getPassword() {
        return this.password;
    }

    @Override
    public void setPassword(RedisPassword password) {
        Assert.notNull((Object)password, (String)"RedisPassword must not be null");
        this.password = password;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RedisSocketConfiguration)) {
            return false;
        }
        RedisSocketConfiguration that = (RedisSocketConfiguration)o;
        if (this.database != that.database) {
            return false;
        }
        if (!ObjectUtils.nullSafeEquals((Object)this.socket, (Object)that.socket)) {
            return false;
        }
        if (!ObjectUtils.nullSafeEquals((Object)this.username, (Object)that.username)) {
            return false;
        }
        return ObjectUtils.nullSafeEquals((Object)this.password, (Object)that.password);
    }

    public int hashCode() {
        int result = ObjectUtils.nullSafeHashCode((Object)this.socket);
        result = 31 * result + this.database;
        result = 31 * result + ObjectUtils.nullSafeHashCode((Object)this.username);
        result = 31 * result + ObjectUtils.nullSafeHashCode((Object)this.password);
        return result;
    }
}

