/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection;

import java.nio.ByteBuffer;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.jspecify.annotations.Nullable;
import org.reactivestreams.Publisher;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.data.redis.connection.ExpirationOptions;
import org.springframework.data.redis.connection.ReactiveRedisConnection;
import org.springframework.data.redis.connection.RedisHashCommands;
import org.springframework.data.redis.core.ScanOptions;
import org.springframework.data.redis.core.types.Expiration;
import org.springframework.util.Assert;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public interface ReactiveHashCommands {
    default public Mono<Boolean> hSet(ByteBuffer key, ByteBuffer field, ByteBuffer value) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        Assert.notNull((Object)field, (String)"Field must not be null");
        Assert.notNull((Object)value, (String)"Value must not be null");
        return this.hSet((Publisher<HSetCommand>)Mono.just((Object)HSetCommand.value(value).ofField(field).forKey(key))).next().map(ReactiveRedisConnection.CommandResponse::getOutput);
    }

    default public Mono<Boolean> hSetNX(ByteBuffer key, ByteBuffer field, ByteBuffer value) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        Assert.notNull((Object)field, (String)"Field must not be null");
        Assert.notNull((Object)value, (String)"Value must not be null");
        return this.hSet((Publisher<HSetCommand>)Mono.just((Object)HSetCommand.value(value).ofField(field).forKey(key).ifValueNotExists())).next().map(ReactiveRedisConnection.CommandResponse::getOutput);
    }

    default public Mono<Boolean> hMSet(ByteBuffer key, Map<ByteBuffer, ByteBuffer> fieldValueMap) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        Assert.notNull(fieldValueMap, (String)"Field must not be null");
        return this.hSet((Publisher<HSetCommand>)Mono.just((Object)HSetCommand.fieldValues(fieldValueMap).forKey(key))).next().map(it -> true);
    }

    public Flux<ReactiveRedisConnection.BooleanResponse<HSetCommand>> hSet(Publisher<HSetCommand> var1);

    default public Mono<ByteBuffer> hGet(ByteBuffer key, ByteBuffer field) {
        return this.hMGet(key, Collections.singletonList(field)).filter(it -> !it.contains(null)).flatMapIterable(Function.identity()).next();
    }

    default public Mono<List<ByteBuffer>> hMGet(ByteBuffer key, Collection<ByteBuffer> fields) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        Assert.notNull(fields, (String)"Fields must not be null");
        return this.hMGet((Publisher<HGetCommand>)Mono.just((Object)HGetCommand.fields(fields).from(key))).next().map(ReactiveRedisConnection.CommandResponse::getOutput);
    }

    public Flux<ReactiveRedisConnection.MultiValueResponse<HGetCommand, ByteBuffer>> hMGet(Publisher<HGetCommand> var1);

    default public Mono<Boolean> hExists(ByteBuffer key, ByteBuffer field) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        Assert.notNull((Object)field, (String)"Field must not be null");
        return this.hExists((Publisher<HExistsCommand>)Mono.just((Object)HExistsCommand.field(field).in(key))).next().map(ReactiveRedisConnection.CommandResponse::getOutput);
    }

    public Flux<ReactiveRedisConnection.BooleanResponse<HExistsCommand>> hExists(Publisher<HExistsCommand> var1);

    default public Mono<Boolean> hDel(ByteBuffer key, ByteBuffer field) {
        Assert.notNull((Object)field, (String)"Field must not be null");
        return this.hDel(key, Collections.singletonList(field)).map(val -> val > 0L ? Boolean.TRUE : Boolean.FALSE);
    }

    default public Mono<Long> hDel(ByteBuffer key, Collection<ByteBuffer> fields) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        Assert.notNull(fields, (String)"Fields must not be null");
        return this.hDel((Publisher<HDelCommand>)Mono.just((Object)HDelCommand.fields(fields).from(key))).next().map(ReactiveRedisConnection.CommandResponse::getOutput);
    }

    public Flux<ReactiveRedisConnection.NumericResponse<HDelCommand, Long>> hDel(Publisher<HDelCommand> var1);

    default public Mono<Long> hLen(ByteBuffer key) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        return this.hLen((Publisher<ReactiveRedisConnection.KeyCommand>)Mono.just((Object)new ReactiveRedisConnection.KeyCommand(key))).next().map(ReactiveRedisConnection.CommandResponse::getOutput);
    }

    public Flux<ReactiveRedisConnection.NumericResponse<ReactiveRedisConnection.KeyCommand, Long>> hLen(Publisher<ReactiveRedisConnection.KeyCommand> var1);

    default public Mono<ByteBuffer> hRandField(ByteBuffer key) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        return this.hRandField((Publisher<HRandFieldCommand>)Mono.just((Object)HRandFieldCommand.key(key).count(1L))).flatMap(ReactiveRedisConnection.CommandResponse::getOutput).next();
    }

    default public Mono<Map.Entry<ByteBuffer, ByteBuffer>> hRandFieldWithValues(ByteBuffer key) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        return this.hRandFieldWithValues((Publisher<HRandFieldCommand>)Mono.just((Object)HRandFieldCommand.key(key).count(1L))).flatMap(ReactiveRedisConnection.CommandResponse::getOutput).next();
    }

    default public Flux<ByteBuffer> hRandField(ByteBuffer key, long count) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        return this.hRandField((Publisher<HRandFieldCommand>)Mono.just((Object)HRandFieldCommand.key(key).count(count))).flatMap(ReactiveRedisConnection.CommandResponse::getOutput);
    }

    default public Flux<Map.Entry<ByteBuffer, ByteBuffer>> hRandFieldWithValues(ByteBuffer key, long count) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        return this.hRandFieldWithValues((Publisher<HRandFieldCommand>)Mono.just((Object)HRandFieldCommand.key(key).count(count))).flatMap(ReactiveRedisConnection.CommandResponse::getOutput);
    }

    public Flux<ReactiveRedisConnection.CommandResponse<HRandFieldCommand, Flux<ByteBuffer>>> hRandField(Publisher<HRandFieldCommand> var1);

    public Flux<ReactiveRedisConnection.CommandResponse<HRandFieldCommand, Flux<Map.Entry<ByteBuffer, ByteBuffer>>>> hRandFieldWithValues(Publisher<HRandFieldCommand> var1);

    default public Flux<ByteBuffer> hKeys(ByteBuffer key) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        return this.hKeys((Publisher<ReactiveRedisConnection.KeyCommand>)Mono.just((Object)new ReactiveRedisConnection.KeyCommand(key))).flatMap(ReactiveRedisConnection.CommandResponse::getOutput);
    }

    public Flux<ReactiveRedisConnection.CommandResponse<ReactiveRedisConnection.KeyCommand, Flux<ByteBuffer>>> hKeys(Publisher<ReactiveRedisConnection.KeyCommand> var1);

    default public Flux<ByteBuffer> hVals(ByteBuffer key) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        return this.hVals((Publisher<ReactiveRedisConnection.KeyCommand>)Mono.just((Object)new ReactiveRedisConnection.KeyCommand(key))).flatMap(ReactiveRedisConnection.CommandResponse::getOutput);
    }

    public Flux<ReactiveRedisConnection.CommandResponse<ReactiveRedisConnection.KeyCommand, Flux<ByteBuffer>>> hVals(Publisher<ReactiveRedisConnection.KeyCommand> var1);

    default public Flux<Map.Entry<ByteBuffer, ByteBuffer>> hGetAll(ByteBuffer key) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        return this.hGetAll((Publisher<ReactiveRedisConnection.KeyCommand>)Mono.just((Object)new ReactiveRedisConnection.KeyCommand(key))).flatMap(ReactiveRedisConnection.CommandResponse::getOutput);
    }

    public Flux<ReactiveRedisConnection.CommandResponse<ReactiveRedisConnection.KeyCommand, Flux<Map.Entry<ByteBuffer, ByteBuffer>>>> hGetAll(Publisher<ReactiveRedisConnection.KeyCommand> var1);

    default public Flux<Map.Entry<ByteBuffer, ByteBuffer>> hScan(ByteBuffer key) {
        return this.hScan(key, ScanOptions.NONE);
    }

    default public Flux<Map.Entry<ByteBuffer, ByteBuffer>> hScan(ByteBuffer key, ScanOptions options) {
        return this.hScan((Publisher<ReactiveRedisConnection.KeyScanCommand>)Mono.just((Object)ReactiveRedisConnection.KeyScanCommand.key(key).withOptions(options))).map(ReactiveRedisConnection.CommandResponse::getOutput).flatMap(it -> it);
    }

    public Flux<ReactiveRedisConnection.CommandResponse<ReactiveRedisConnection.KeyCommand, Flux<Map.Entry<ByteBuffer, ByteBuffer>>>> hScan(Publisher<ReactiveRedisConnection.KeyScanCommand> var1);

    default public Mono<Long> hStrLen(ByteBuffer key, ByteBuffer field) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        Assert.notNull((Object)field, (String)"Field must not be null");
        return this.hStrLen((Publisher<HStrLenCommand>)Mono.just((Object)HStrLenCommand.lengthOf(field).from(key))).next().map(ReactiveRedisConnection.CommandResponse::getOutput);
    }

    public Flux<ReactiveRedisConnection.NumericResponse<HStrLenCommand, Long>> hStrLen(Publisher<HStrLenCommand> var1);

    default public Mono<Long> hExpire(ByteBuffer key, Duration duration, ByteBuffer field) {
        Assert.notNull((Object)duration, (String)"Duration must not be null");
        return this.hExpire(key, duration, Collections.singletonList(field)).singleOrEmpty();
    }

    default public Flux<Long> hExpire(ByteBuffer key, Duration duration, List<ByteBuffer> fields) {
        Assert.notNull((Object)duration, (String)"Duration must not be null");
        return this.applyHashFieldExpiration((Publisher<HashExpireCommand>)Flux.just((Object)HashExpireCommand.expire(fields, duration).from(key))).mapNotNull(ReactiveRedisConnection.CommandResponse::getOutput);
    }

    public Flux<ReactiveRedisConnection.NumericResponse<HashExpireCommand, Long>> applyHashFieldExpiration(Publisher<HashExpireCommand> var1);

    default public Mono<Long> hpExpire(ByteBuffer key, Duration duration, ByteBuffer field) {
        Assert.notNull((Object)duration, (String)"Duration must not be null");
        return this.hpExpire(key, duration, Collections.singletonList(field)).singleOrEmpty();
    }

    default public Flux<Long> hpExpire(ByteBuffer key, Duration duration, List<ByteBuffer> fields) {
        Assert.notNull((Object)duration, (String)"Duration must not be null");
        return this.applyHashFieldExpiration((Publisher<HashExpireCommand>)Flux.just((Object)new HashExpireCommand(key, fields, Expiration.from(duration.toMillis(), TimeUnit.MILLISECONDS), ExpirationOptions.none()))).mapNotNull(ReactiveRedisConnection.CommandResponse::getOutput);
    }

    default public Mono<Long> hExpireAt(ByteBuffer key, Instant expireAt, ByteBuffer field) {
        Assert.notNull((Object)expireAt, (String)"Duration must not be null");
        return this.hExpireAt(key, expireAt, Collections.singletonList(field)).singleOrEmpty();
    }

    default public Flux<Long> hExpireAt(ByteBuffer key, Instant expireAt, List<ByteBuffer> fields) {
        Assert.notNull((Object)expireAt, (String)"Duration must not be null");
        return this.applyHashFieldExpiration((Publisher<HashExpireCommand>)Flux.just((Object)HashExpireCommand.expireAt(fields, expireAt, TimeUnit.SECONDS).from(key))).mapNotNull(ReactiveRedisConnection.CommandResponse::getOutput);
    }

    default public Mono<Long> hpExpireAt(ByteBuffer key, Instant expireAt, ByteBuffer field) {
        Assert.notNull((Object)expireAt, (String)"Duration must not be null");
        return this.hpExpireAt(key, expireAt, Collections.singletonList(field)).singleOrEmpty();
    }

    default public Flux<Long> hpExpireAt(ByteBuffer key, Instant expireAt, List<ByteBuffer> fields) {
        Assert.notNull((Object)expireAt, (String)"Duration must not be null");
        return this.applyHashFieldExpiration((Publisher<HashExpireCommand>)Flux.just((Object)HashExpireCommand.expireAt(fields, expireAt, TimeUnit.MILLISECONDS).from(key))).mapNotNull(ReactiveRedisConnection.CommandResponse::getOutput);
    }

    default public Mono<Long> hPersist(ByteBuffer key, ByteBuffer field) {
        return this.hPersist(key, Collections.singletonList(field)).singleOrEmpty();
    }

    default public Flux<Long> hPersist(ByteBuffer key, List<ByteBuffer> fields) {
        return this.hPersist((Publisher<HashFieldsCommand>)Flux.just((Object)new HashFieldsCommand(key, fields))).mapNotNull(ReactiveRedisConnection.CommandResponse::getOutput);
    }

    public Flux<ReactiveRedisConnection.NumericResponse<HashFieldsCommand, Long>> hPersist(Publisher<HashFieldsCommand> var1);

    default public Mono<Long> hTtl(ByteBuffer key, ByteBuffer field) {
        return this.hTtl(key, Collections.singletonList(field)).singleOrEmpty();
    }

    default public Flux<Long> hTtl(ByteBuffer key, List<ByteBuffer> fields) {
        return this.hTtl((Publisher<HashFieldsCommand>)Flux.just((Object)new HashFieldsCommand(key, fields))).mapNotNull(ReactiveRedisConnection.CommandResponse::getOutput);
    }

    public Flux<ReactiveRedisConnection.NumericResponse<HashFieldsCommand, Long>> hTtl(Publisher<HashFieldsCommand> var1);

    default public Mono<Long> hpTtl(ByteBuffer key, ByteBuffer field) {
        return this.hpTtl(key, Collections.singletonList(field)).singleOrEmpty();
    }

    default public Flux<Long> hpTtl(ByteBuffer key, List<ByteBuffer> fields) {
        return this.hpTtl((Publisher<HashFieldsCommand>)Flux.just((Object)new HashFieldsCommand(key, fields))).mapNotNull(ReactiveRedisConnection.CommandResponse::getOutput);
    }

    public Flux<ReactiveRedisConnection.NumericResponse<HashFieldsCommand, Long>> hpTtl(Publisher<HashFieldsCommand> var1);

    default public Mono<List<ByteBuffer>> hGetDel(ByteBuffer key, Collection<ByteBuffer> fields) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        Assert.notNull(fields, (String)"Fields must not be null");
        return this.hGetDel((Publisher<HGetDelCommand>)Mono.just((Object)HGetDelCommand.fields(fields).from(key))).next().map(ReactiveRedisConnection.CommandResponse::getOutput);
    }

    public Flux<ReactiveRedisConnection.MultiValueResponse<HGetDelCommand, ByteBuffer>> hGetDel(Publisher<HGetDelCommand> var1);

    default public Mono<List<ByteBuffer>> hGetEx(ByteBuffer key, Expiration expiration, List<ByteBuffer> fields) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        Assert.notNull(fields, (String)"Fields must not be null");
        return this.hGetEx((Publisher<HGetExCommand>)Mono.just((Object)HGetExCommand.expire(fields, expiration).from(key))).next().map(ReactiveRedisConnection.CommandResponse::getOutput);
    }

    public Flux<ReactiveRedisConnection.MultiValueResponse<HGetExCommand, ByteBuffer>> hGetEx(Publisher<HGetExCommand> var1);

    default public Mono<Boolean> hSetEx(ByteBuffer key, Map<ByteBuffer, ByteBuffer> fieldValueMap, RedisHashCommands.HashFieldSetOption condition, Expiration expiration) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        Assert.notNull(fieldValueMap, (String)"Field-value map must not be null");
        Assert.notNull((Object)((Object)condition), (String)"Condition must not be null");
        Assert.notNull((Object)expiration, (String)"Expiration must not be null");
        return this.hSetEx((Publisher<HSetExCommand>)Mono.just((Object)HSetExCommand.setWithConditionAndExpiration(fieldValueMap, condition, expiration).from(key))).next().map(ReactiveRedisConnection.CommandResponse::getOutput);
    }

    public Flux<ReactiveRedisConnection.BooleanResponse<HSetExCommand>> hSetEx(Publisher<HSetExCommand> var1);

    public static class HSetCommand
    extends ReactiveRedisConnection.KeyCommand {
        private static final ByteBuffer SINGLE_VALUE_KEY = ByteBuffer.allocate(0);
        private final Map<ByteBuffer, ByteBuffer> fieldValueMap;
        private final boolean upsert;

        private HSetCommand(@Nullable ByteBuffer key, Map<ByteBuffer, ByteBuffer> keyValueMap, boolean upsert) {
            super(key);
            this.fieldValueMap = keyValueMap;
            this.upsert = upsert;
        }

        public static HSetCommand value(ByteBuffer value) {
            Assert.notNull((Object)value, (String)"Value must not be null");
            return new HSetCommand(null, Collections.singletonMap(SINGLE_VALUE_KEY, value), Boolean.TRUE);
        }

        public static HSetCommand fieldValues(Map<ByteBuffer, ByteBuffer> fieldValueMap) {
            Assert.notNull(fieldValueMap, (String)"Field values map must not be null");
            return new HSetCommand(null, fieldValueMap, Boolean.TRUE);
        }

        public HSetCommand ofField(ByteBuffer field) {
            if (!this.fieldValueMap.containsKey(SINGLE_VALUE_KEY)) {
                throw new InvalidDataAccessApiUsageException("Value has not been set.");
            }
            Assert.notNull((Object)field, (String)"Field not be null");
            return new HSetCommand(this.getKey(), Collections.singletonMap(field, this.fieldValueMap.get(SINGLE_VALUE_KEY)), this.upsert);
        }

        public HSetCommand forKey(ByteBuffer key) {
            Assert.notNull((Object)key, (String)"Key not be null");
            return new HSetCommand(key, this.fieldValueMap, this.upsert);
        }

        public HSetCommand ifValueNotExists() {
            return new HSetCommand(this.getKey(), this.fieldValueMap, Boolean.FALSE);
        }

        public boolean isUpsert() {
            return this.upsert;
        }

        public Map<ByteBuffer, ByteBuffer> getFieldValueMap() {
            return this.fieldValueMap;
        }
    }

    public static class HGetCommand
    extends HashFieldsCommand {
        private HGetCommand(@Nullable ByteBuffer key, List<ByteBuffer> fields) {
            super(key, fields);
        }

        public static HGetCommand field(ByteBuffer field) {
            Assert.notNull((Object)field, (String)"Field must not be null");
            return new HGetCommand(null, Collections.singletonList(field));
        }

        public static HGetCommand fields(Collection<ByteBuffer> fields) {
            Assert.notNull(fields, (String)"Fields must not be null");
            return new HGetCommand(null, new ArrayList<ByteBuffer>(fields));
        }

        public HGetCommand from(ByteBuffer key) {
            Assert.notNull((Object)key, (String)"Key must not be null");
            return new HGetCommand(key, this.getFields());
        }
    }

    public static class HExistsCommand
    extends ReactiveRedisConnection.KeyCommand {
        private final ByteBuffer field;

        private HExistsCommand(@Nullable ByteBuffer key, ByteBuffer field) {
            super(key);
            this.field = field;
        }

        public static HExistsCommand field(ByteBuffer field) {
            Assert.notNull((Object)field, (String)"Field must not be null");
            return new HExistsCommand(null, field);
        }

        public HExistsCommand in(ByteBuffer key) {
            Assert.notNull((Object)key, (String)"Key must not be null");
            return new HExistsCommand(key, this.field);
        }

        public ByteBuffer getField() {
            return this.field;
        }
    }

    public static class HDelCommand
    extends HashFieldsCommand {
        private HDelCommand(@Nullable ByteBuffer key, List<ByteBuffer> fields) {
            super(key, fields);
        }

        public static HDelCommand field(ByteBuffer field) {
            Assert.notNull((Object)field, (String)"Field must not be null");
            return new HDelCommand(null, Collections.singletonList(field));
        }

        public static HDelCommand fields(Collection<ByteBuffer> fields) {
            Assert.notNull(fields, (String)"Fields must not be null");
            return new HDelCommand(null, new ArrayList<ByteBuffer>(fields));
        }

        public HDelCommand from(ByteBuffer key) {
            Assert.notNull((Object)key, (String)"Key must not be null");
            return new HDelCommand(key, this.getFields());
        }
    }

    public static class HRandFieldCommand
    extends ReactiveRedisConnection.KeyCommand {
        private long count;

        private HRandFieldCommand(@Nullable ByteBuffer key, long count) {
            super(key);
            this.count = count;
        }

        public static HRandFieldCommand key(ByteBuffer key) {
            Assert.notNull((Object)key, (String)"Key must not be null");
            return new HRandFieldCommand(key, 1L);
        }

        public HRandFieldCommand count(long count) {
            return new HRandFieldCommand(this.getKey(), count);
        }

        public long getCount() {
            return this.count;
        }
    }

    public static class HStrLenCommand
    extends ReactiveRedisConnection.KeyCommand {
        private ByteBuffer field;

        private HStrLenCommand(@Nullable ByteBuffer key, ByteBuffer field) {
            super(key);
            this.field = field;
        }

        public static HStrLenCommand lengthOf(ByteBuffer field) {
            Assert.notNull((Object)field, (String)"Field must not be null");
            return new HStrLenCommand(null, field);
        }

        public HStrLenCommand from(ByteBuffer key) {
            return new HStrLenCommand(key, this.field);
        }

        public ByteBuffer getField() {
            return this.field;
        }
    }

    public static class HashExpireCommand
    extends HashFieldsCommand {
        private final Expiration expiration;
        private final ExpirationOptions options;

        private HashExpireCommand(@Nullable ByteBuffer key, List<ByteBuffer> fields, Expiration expiration, ExpirationOptions options) {
            super(key, fields);
            this.expiration = expiration;
            this.options = options;
        }

        public static HashExpireCommand expire(List<ByteBuffer> fields, long timeout, TimeUnit unit) {
            Assert.notNull(fields, (String)"Field must not be null");
            return HashExpireCommand.expire(fields, Expiration.from(timeout, unit));
        }

        public static HashExpireCommand expire(List<ByteBuffer> fields, Duration ttl) {
            Assert.notNull(fields, (String)"Field must not be null");
            return HashExpireCommand.expire(fields, Expiration.from(ttl));
        }

        public static HashExpireCommand expire(List<ByteBuffer> fields, Expiration expiration) {
            return new HashExpireCommand(null, fields, expiration, ExpirationOptions.none());
        }

        public static HashExpireCommand expireAt(List<ByteBuffer> fields, Instant ttl, TimeUnit precision) {
            if (precision.compareTo(TimeUnit.MILLISECONDS) > 0) {
                return HashExpireCommand.expire(fields, Expiration.unixTimestamp(ttl.getEpochSecond(), TimeUnit.SECONDS));
            }
            return HashExpireCommand.expire(fields, Expiration.unixTimestamp(ttl.toEpochMilli(), TimeUnit.MILLISECONDS));
        }

        public HashExpireCommand from(ByteBuffer key) {
            return new HashExpireCommand(key, this.getFields(), this.expiration, this.options);
        }

        public HashExpireCommand withOptions(ExpirationOptions options) {
            return new HashExpireCommand(this.getKey(), this.getFields(), this.getExpiration(), options);
        }

        public Expiration getExpiration() {
            return this.expiration;
        }

        public ExpirationOptions getOptions() {
            return this.options;
        }
    }

    public static class HashFieldsCommand
    extends ReactiveRedisConnection.KeyCommand {
        private final List<ByteBuffer> fields;

        private HashFieldsCommand(@Nullable ByteBuffer key, List<ByteBuffer> fields) {
            super(key);
            this.fields = fields;
        }

        public List<ByteBuffer> getFields() {
            return this.fields;
        }
    }

    public static class HGetDelCommand
    extends HashFieldsCommand {
        private HGetDelCommand(@Nullable ByteBuffer key, List<ByteBuffer> fields) {
            super(key, fields);
        }

        public static HGetDelCommand field(ByteBuffer field) {
            Assert.notNull((Object)field, (String)"Field must not be null");
            return new HGetDelCommand(null, Collections.singletonList(field));
        }

        public static HGetDelCommand fields(Collection<ByteBuffer> fields) {
            Assert.notNull(fields, (String)"Fields must not be null");
            return new HGetDelCommand(null, new ArrayList<ByteBuffer>(fields));
        }

        public HGetDelCommand from(ByteBuffer key) {
            Assert.notNull((Object)key, (String)"Key must not be null");
            return new HGetDelCommand(key, this.getFields());
        }
    }

    public static class HGetExCommand
    extends HashFieldsCommand {
        private final Expiration expiration;

        private HGetExCommand(@Nullable ByteBuffer key, List<ByteBuffer> fields, Expiration expiration) {
            super(key, fields);
            this.expiration = expiration;
        }

        public static HGetExCommand expire(List<ByteBuffer> fields, Expiration expiration) {
            return new HGetExCommand(null, fields, expiration);
        }

        public HGetExCommand from(ByteBuffer key) {
            return new HGetExCommand(key, this.getFields(), this.expiration);
        }

        public HGetExCommand fields(Collection<ByteBuffer> fields) {
            return new HGetExCommand(this.getKey(), new ArrayList<ByteBuffer>(fields), this.expiration);
        }

        public Expiration getExpiration() {
            return this.expiration;
        }
    }

    public static class HSetExCommand
    extends ReactiveRedisConnection.KeyCommand {
        private final Map<ByteBuffer, ByteBuffer> fieldValueMap;
        private final RedisHashCommands.HashFieldSetOption condition;
        private final Expiration expiration;

        private HSetExCommand(@Nullable ByteBuffer key, Map<ByteBuffer, ByteBuffer> fieldValueMap, RedisHashCommands.HashFieldSetOption condition, Expiration expiration) {
            super(key);
            this.fieldValueMap = fieldValueMap;
            this.condition = condition;
            this.expiration = expiration;
        }

        public static HSetExCommand setWithConditionAndExpiration(Map<ByteBuffer, ByteBuffer> fieldValueMap, RedisHashCommands.HashFieldSetOption condition, Expiration expiration) {
            return new HSetExCommand(null, fieldValueMap, condition, expiration);
        }

        public HSetExCommand from(ByteBuffer key) {
            Assert.notNull((Object)key, (String)"Key must not be null");
            return new HSetExCommand(key, this.fieldValueMap, this.condition, this.expiration);
        }

        public Map<ByteBuffer, ByteBuffer> getFieldValueMap() {
            return this.fieldValueMap;
        }

        public RedisHashCommands.HashFieldSetOption getCondition() {
            return this.condition;
        }

        public Expiration getExpiration() {
            return this.expiration;
        }
    }
}

