/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.repository.query;

import java.util.Collection;
import java.util.Iterator;
import org.jspecify.annotations.Nullable;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.data.domain.Sort;
import org.springframework.data.geo.Circle;
import org.springframework.data.geo.Distance;
import org.springframework.data.geo.Metric;
import org.springframework.data.geo.Metrics;
import org.springframework.data.geo.Point;
import org.springframework.data.keyvalue.core.query.KeyValueQuery;
import org.springframework.data.redis.repository.query.RedisOperationChain;
import org.springframework.data.repository.query.ParameterAccessor;
import org.springframework.data.repository.query.parser.AbstractQueryCreator;
import org.springframework.data.repository.query.parser.Part;
import org.springframework.data.repository.query.parser.PartTree;
import org.springframework.util.ClassUtils;
import org.springframework.util.CollectionUtils;

public class RedisQueryCreator
extends AbstractQueryCreator<KeyValueQuery<RedisOperationChain>, RedisOperationChain> {
    public RedisQueryCreator(PartTree tree, ParameterAccessor parameters) {
        super(tree, parameters);
    }

    protected RedisOperationChain create(Part part, Iterator<Object> iterator) {
        return this.from(part, iterator, new RedisOperationChain());
    }

    private RedisOperationChain from(Part part, Iterator<Object> iterator, RedisOperationChain sink) {
        switch (part.getType()) {
            case SIMPLE_PROPERTY: {
                sink.sismember(part.getProperty().toDotPath(), iterator.next());
                break;
            }
            case TRUE: {
                sink.sismember(part.getProperty().toDotPath(), true);
                break;
            }
            case FALSE: {
                sink.sismember(part.getProperty().toDotPath(), false);
                break;
            }
            case WITHIN: 
            case NEAR: {
                sink.near(this.getNearPath(part, iterator));
                break;
            }
            default: {
                throw new IllegalArgumentException("%s is not supported for Redis query derivation".formatted(part.getType()));
            }
        }
        return sink;
    }

    protected RedisOperationChain and(Part part, RedisOperationChain base, Iterator<Object> iterator) {
        return this.from(part, iterator, base);
    }

    protected RedisOperationChain or(RedisOperationChain base, RedisOperationChain criteria) {
        base.orSismember(criteria.getSismember());
        return base;
    }

    protected KeyValueQuery<RedisOperationChain> complete(@Nullable RedisOperationChain criteria, Sort sort) {
        KeyValueQuery query = new KeyValueQuery((Object)criteria);
        if (criteria != null && RedisQueryCreator.containsExactlyOne(criteria.getSismember()) && RedisQueryCreator.containsExactlyOne(criteria.getOrSismember())) {
            criteria.getOrSismember().addAll(criteria.getSismember());
            criteria.getSismember().clear();
        }
        if (sort.isSorted()) {
            query.setSort(sort);
        }
        return query;
    }

    private RedisOperationChain.NearPath getNearPath(Part part, Iterator<Object> iterator) {
        String path = part.getProperty().toDotPath();
        Object value = iterator.next();
        if (value instanceof Circle) {
            Circle circle = (Circle)value;
            return new RedisOperationChain.NearPath(path, circle.getCenter(), circle.getRadius());
        }
        if (value instanceof Point) {
            Distance distance;
            Point point = (Point)value;
            if (!iterator.hasNext()) {
                throw new InvalidDataAccessApiUsageException("Expected to find distance value for geo query; Are you missing a parameter?");
            }
            Object distObject = iterator.next();
            if (distObject instanceof Distance) {
                Distance dist;
                distance = dist = (Distance)distObject;
            } else if (distObject instanceof Number) {
                Number num = (Number)distObject;
                distance = new Distance(num.doubleValue(), (Metric)Metrics.KILOMETERS);
            } else {
                throw new InvalidDataAccessApiUsageException("Expected to find Distance or Numeric value for geo query but was %s".formatted(ClassUtils.getDescriptiveType((Object)distObject)));
            }
            return new RedisOperationChain.NearPath(path, point, distance);
        }
        throw new InvalidDataAccessApiUsageException("Expected to find a Circle or Point/Distance for geo query but was %s".formatted(ClassUtils.getDescriptiveType(value.getClass())));
    }

    private static boolean containsExactlyOne(Collection<?> collection) {
        return !CollectionUtils.isEmpty(collection) && collection.size() == 1;
    }
}

