/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.core.convert;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jspecify.annotations.Nullable;
import org.springframework.data.redis.core.convert.IndexResolver;
import org.springframework.data.redis.core.convert.IndexedData;
import org.springframework.data.util.TypeInformation;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

public class CompositeIndexResolver
implements IndexResolver {
    private final List<IndexResolver> resolvers;

    public CompositeIndexResolver(Collection<IndexResolver> resolvers) {
        Assert.notNull(resolvers, (String)"Resolvers must not be null");
        if (CollectionUtils.contains(resolvers.iterator(), null)) {
            throw new IllegalArgumentException("Resolvers must no contain null values");
        }
        this.resolvers = new ArrayList<IndexResolver>(resolvers);
    }

    @Override
    public Set<IndexedData> resolveIndexesFor(TypeInformation<?> typeInformation, @Nullable Object value) {
        if (this.resolvers.isEmpty()) {
            return Collections.emptySet();
        }
        LinkedHashSet<IndexedData> data = new LinkedHashSet<IndexedData>();
        for (IndexResolver resolver : this.resolvers) {
            data.addAll(resolver.resolveIndexesFor(typeInformation, value));
        }
        return data;
    }

    @Override
    public Set<IndexedData> resolveIndexesFor(String keyspace, String path, TypeInformation<?> typeInformation, @Nullable Object value) {
        LinkedHashSet<IndexedData> data = new LinkedHashSet<IndexedData>();
        for (IndexResolver resolver : this.resolvers) {
            data.addAll(resolver.resolveIndexesFor(keyspace, path, typeInformation, value));
        }
        return data;
    }
}

