/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.core;

import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.NullUnmarked;
import org.springframework.data.domain.Range;
import org.springframework.data.redis.connection.Limit;
import org.springframework.data.redis.connection.RedisStreamCommands;
import org.springframework.data.redis.connection.stream.ByteRecord;
import org.springframework.data.redis.connection.stream.Consumer;
import org.springframework.data.redis.connection.stream.MapRecord;
import org.springframework.data.redis.connection.stream.ObjectRecord;
import org.springframework.data.redis.connection.stream.PendingMessages;
import org.springframework.data.redis.connection.stream.PendingMessagesSummary;
import org.springframework.data.redis.connection.stream.ReadOffset;
import org.springframework.data.redis.connection.stream.Record;
import org.springframework.data.redis.connection.stream.RecordId;
import org.springframework.data.redis.connection.stream.StreamInfo;
import org.springframework.data.redis.connection.stream.StreamOffset;
import org.springframework.data.redis.connection.stream.StreamReadOptions;
import org.springframework.data.redis.connection.stream.StreamRecords;
import org.springframework.data.redis.core.HashMapperProvider;
import org.springframework.data.redis.core.StreamObjectMapper;
import org.springframework.data.redis.hash.HashMapper;
import org.springframework.util.Assert;

@NullUnmarked
public interface StreamOperations<K, HK, HV>
extends HashMapperProvider<HK, HV> {
    public Long acknowledge(@NonNull K var1, @NonNull String var2, String ... var3);

    default public Long acknowledge(@NonNull K key, @NonNull String group, RecordId ... recordIds) {
        return this.acknowledge(key, group, (String[])Arrays.stream(recordIds).map(RecordId::getValue).toArray(String[]::new));
    }

    default public Long acknowledge(@NonNull String group, @NonNull Record<@NonNull K, ?> record) {
        return this.acknowledge(record.getRequiredStream(), group, record.getId());
    }

    default public RecordId add(@NonNull K key, @NonNull Map<? extends @NonNull HK, ? extends HV> content,  @NonNull RedisStreamCommands.XAddOptions xAddOptions) {
        return this.add(StreamRecords.newRecord().in(key).ofMap(content), xAddOptions);
    }

    default public RecordId add(@NonNull MapRecord<K, ? extends HK, ? extends HV> record,  @NonNull RedisStreamCommands.XAddOptions xAddOptions) {
        return this.add((Record<K, ?>)record, xAddOptions);
    }

    public RecordId add(@NonNull Record<K, ?> var1,  @NonNull RedisStreamCommands.XAddOptions var2);

    default public RecordId add(@NonNull K key, @NonNull Map<? extends @NonNull HK, ? extends HV> content) {
        return this.add(StreamRecords.newRecord().in(key).ofMap(content));
    }

    default public RecordId add(@NonNull MapRecord<K, ? extends HK, ? extends HV> record) {
        return this.add((Record<K, ?>)record);
    }

    public RecordId add(@NonNull Record<K, ?> var1);

    default public List<@NonNull MapRecord<K, HK, HV>> claim(@NonNull K key, @NonNull String consumerGroup, @NonNull String newOwner, @NonNull Duration minIdleTime, RecordId ... recordIds) {
        return this.claim(key, consumerGroup, newOwner, RedisStreamCommands.XClaimOptions.minIdle(minIdleTime).ids(recordIds));
    }

    public List<@NonNull MapRecord<K, HK, HV>> claim(@NonNull K var1, @NonNull String var2, @NonNull String var3,  @NonNull RedisStreamCommands.XClaimOptions var4);

    default public Long delete(@NonNull K key, String ... recordIds) {
        return this.delete(key, (RecordId[])Arrays.stream(recordIds).map(RecordId::of).toArray(RecordId[]::new));
    }

    default public Long delete(@NonNull Record<K, ?> record) {
        return this.delete(record.getStream(), record.getId());
    }

    public Long delete(@NonNull K var1, RecordId ... var2);

    default public String createGroup(@NonNull K key, @NonNull String group) {
        return this.createGroup(key, ReadOffset.latest(), group);
    }

    public String createGroup(@NonNull K var1, @NonNull ReadOffset var2, @NonNull String var3);

    public Boolean deleteConsumer(@NonNull K var1, @NonNull Consumer var2);

    public Boolean destroyGroup(@NonNull K var1, @NonNull String var2);

    public StreamInfo.XInfoConsumers consumers(@NonNull K var1, @NonNull String var2);

    public StreamInfo.XInfoGroups groups(@NonNull K var1);

    public StreamInfo.XInfoStream info(@NonNull K var1);

    public PendingMessagesSummary pending(@NonNull K var1, @NonNull String var2);

    default public PendingMessages pending(@NonNull K key, @NonNull Consumer consumer) {
        return this.pending(key, consumer, Range.unbounded(), -1L);
    }

    public PendingMessages pending(@NonNull K var1, @NonNull String var2, @NonNull Range<?> var3, long var4);

    public PendingMessages pending(@NonNull K var1, @NonNull String var2, @NonNull Range<?> var3, long var4, @NonNull Duration var6);

    public PendingMessages pending(@NonNull K var1, @NonNull Consumer var2, @NonNull Range<?> var3, long var4);

    public PendingMessages pending(@NonNull K var1, @NonNull Consumer var2, @NonNull Range<?> var3, long var4, @NonNull Duration var6);

    public Long size(@NonNull K var1);

    default public List<MapRecord<K, HK, HV>> range(@NonNull K key, @NonNull Range<String> range) {
        return this.range(key, range, Limit.unlimited());
    }

    public List<MapRecord<K, HK, HV>> range(@NonNull K var1, @NonNull Range<String> var2, @NonNull Limit var3);

    default public <V> List<@NonNull ObjectRecord<K, V>> range(@NonNull Class<V> targetType, @NonNull K key, @NonNull Range<String> range) {
        return this.range(targetType, key, range, Limit.unlimited());
    }

    default public <V> List<@NonNull ObjectRecord<K, V>> range(@NonNull Class<V> targetType, @NonNull K key, @NonNull Range<String> range, @NonNull Limit limit) {
        Assert.notNull(targetType, (String)"Target type must not be null");
        return this.map(this.range(key, range, limit), targetType);
    }

    default public List<@NonNull MapRecord<K, HK, HV>> read(StreamOffset<K> ... streams) {
        return this.read(StreamReadOptions.empty(), streams);
    }

    default public <V> List<@NonNull ObjectRecord<K, V>> read(@NonNull Class<V> targetType, StreamOffset<K> ... streams) {
        return this.read(targetType, StreamReadOptions.empty(), streams);
    }

    public List<@NonNull MapRecord<K, HK, HV>> read(@NonNull StreamReadOptions var1, StreamOffset<K> ... var2);

    default public <V> List<@NonNull ObjectRecord<K, V>> read(@NonNull Class<V> targetType, @NonNull StreamReadOptions readOptions, StreamOffset<K> ... streams) {
        Assert.notNull(targetType, (String)"Target type must not be null");
        return this.map(this.read(readOptions, streams), targetType);
    }

    default public List<@NonNull MapRecord<K, HK, HV>> read(@NonNull Consumer consumer, StreamOffset<K> ... streams) {
        return this.read(consumer, StreamReadOptions.empty(), streams);
    }

    default public <V> List<ObjectRecord<K, V>> read(@NonNull Class<V> targetType, @NonNull Consumer consumer, StreamOffset<K> ... streams) {
        return this.read(targetType, consumer, StreamReadOptions.empty(), streams);
    }

    public List<@NonNull MapRecord<K, HK, HV>> read(@NonNull Consumer var1, @NonNull StreamReadOptions var2, StreamOffset<K> ... var3);

    default public <V> List<ObjectRecord<K, V>> read(@NonNull Class<V> targetType, @NonNull Consumer consumer, @NonNull StreamReadOptions readOptions, StreamOffset<K> ... streams) {
        Assert.notNull(targetType, (String)"Target type must not be null");
        return this.map(this.read(consumer, readOptions, streams), targetType);
    }

    default public List<@NonNull MapRecord<K, HK, HV>> reverseRange(@NonNull K key, @NonNull Range<String> range) {
        return this.reverseRange(key, range, Limit.unlimited());
    }

    public List<@NonNull MapRecord<K, HK, HV>> reverseRange(@NonNull K var1, @NonNull Range<String> var2, @NonNull Limit var3);

    default public <V> List<@NonNull ObjectRecord<K, V>> reverseRange(@NonNull Class<V> targetType, @NonNull K key, @NonNull Range<String> range) {
        return this.reverseRange(targetType, key, range, Limit.unlimited());
    }

    default public <V> List<@NonNull ObjectRecord<K, V>> reverseRange(@NonNull Class<V> targetType, @NonNull K key, @NonNull Range<String> range, @NonNull Limit limit) {
        Assert.notNull(targetType, (String)"Target type must not be null");
        return this.map(this.reverseRange(key, range, limit), targetType);
    }

    public Long trim(@NonNull K var1, long var2);

    public Long trim(@NonNull K var1, long var2, boolean var4);

    @Override
    public <V> @NonNull HashMapper<V, HK, HV> getHashMapper(@NonNull Class<V> var1);

    default public <V> ObjectRecord<K, V> map(@NonNull MapRecord<K, HK, HV> record, @NonNull Class<V> targetType) {
        Assert.notNull(record, (String)"Record must not be null");
        Assert.notNull(targetType, (String)"Target type must not be null");
        return StreamObjectMapper.toObjectRecord(record, this, targetType);
    }

    default public <V> List<@NonNull ObjectRecord<K, V>> map(@NonNull List<@NonNull MapRecord<K, HK, HV>> records, @NonNull Class<V> targetType) {
        Assert.notNull(records, (String)"Records must not be null");
        Assert.notNull(targetType, (String)"Target type must not be null");
        return StreamObjectMapper.toObjectRecords(records, this, targetType);
    }

    public @NonNull MapRecord<K, HK, HV> deserializeRecord(@NonNull ByteRecord var1);
}

