/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.core;

import java.util.List;
import java.util.Map;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.NullUnmarked;
import org.springframework.data.domain.Range;
import org.springframework.data.redis.connection.Limit;
import org.springframework.data.redis.connection.stream.Consumer;
import org.springframework.data.redis.connection.stream.MapRecord;
import org.springframework.data.redis.connection.stream.ReadOffset;
import org.springframework.data.redis.connection.stream.RecordId;
import org.springframework.data.redis.connection.stream.StreamReadOptions;

@NullUnmarked
public interface BoundStreamOperations<K, HK, HV> {
    public Long acknowledge(@NonNull String var1, String ... var2);

    public RecordId add(@NonNull Map<@NonNull HK, HV> var1);

    public RecordId add(@NonNull Map<@NonNull HK, HV> var1,  @NonNull RedisStreamCommands.XAddOptions var2);

    public Long delete(String ... var1);

    public String createGroup(@NonNull ReadOffset var1, @NonNull String var2);

    public Boolean deleteConsumer(@NonNull Consumer var1);

    public Boolean destroyGroup(@NonNull String var1);

    public Long size();

    default public List<@NonNull MapRecord<K, HK, HV>> range(@NonNull Range<String> range) {
        return this.range(range, Limit.unlimited());
    }

    public List<@NonNull MapRecord<K, HK, HV>> range(@NonNull Range<String> var1, @NonNull Limit var2);

    default public List<@NonNull MapRecord<K, HK, HV>> read(@NonNull ReadOffset readOffset) {
        return this.read(StreamReadOptions.empty(), readOffset);
    }

    public List<@NonNull MapRecord<K, HK, HV>> read(@NonNull StreamReadOptions var1, @NonNull ReadOffset var2);

    default public List<@NonNull MapRecord<K, HK, HV>> read(@NonNull Consumer consumer, @NonNull ReadOffset readOffset) {
        return this.read(consumer, StreamReadOptions.empty(), readOffset);
    }

    public List<@NonNull MapRecord<K, HK, HV>> read(@NonNull Consumer var1, @NonNull StreamReadOptions var2, @NonNull ReadOffset var3);

    default public List<@NonNull MapRecord<K, HK, HV>> reverseRange(@NonNull Range<String> range) {
        return this.reverseRange(range, Limit.unlimited());
    }

    public List<@NonNull MapRecord<K, HK, HV>> reverseRange(@NonNull Range<String> var1, @NonNull Limit var2);

    public Long trim(long var1);

    public Long trim(long var1, boolean var3);
}

