/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.core;

import java.time.Duration;
import java.time.Instant;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import org.jspecify.annotations.Nullable;
import org.springframework.data.redis.connection.DataType;
import org.springframework.data.redis.core.BoundKeyExpirationOperations;
import org.springframework.data.redis.core.DefaultBoundKeyExpirationOperations;
import org.springframework.data.redis.core.RedisOperations;
import org.springframework.util.Assert;

public interface BoundKeyOperations<K> {
    public K getKey();

    public @Nullable DataType getType();

    default public BoundKeyExpirationOperations expiration() {
        return new DefaultBoundKeyExpirationOperations<K>(this.getOperations(), this.getKey());
    }

    public @Nullable Long getExpire();

    default public @Nullable Boolean expire(Duration timeout) {
        Assert.notNull((Object)timeout, (String)"Timeout must not be null");
        return this.expire(timeout.toMillis(), TimeUnit.MILLISECONDS);
    }

    public @Nullable Boolean expire(long var1, TimeUnit var3);

    public @Nullable Boolean expireAt(Date var1);

    default public @Nullable Boolean expireAt(Instant expireAt) {
        Assert.notNull((Object)expireAt, (String)"ExpireAt must not be null");
        return this.expireAt(Date.from(expireAt));
    }

    public @Nullable Boolean persist();

    public void rename(K var1);

    public RedisOperations<K, ?> getOperations();
}

