/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.hash;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.deser.std.UntypedObjectDeserializer;
import com.fasterxml.jackson.databind.jsontype.PolymorphicTypeValidator;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.fasterxml.jackson.databind.jsontype.TypeResolverBuilder;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.std.CalendarSerializer;
import com.fasterxml.jackson.databind.ser.std.DateSerializer;
import java.io.IOException;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import org.jspecify.annotations.Nullable;
import org.springframework.data.mapping.MappingException;
import org.springframework.data.redis.hash.FlatEric;
import org.springframework.data.redis.hash.HashMapper;
import org.springframework.data.util.DirectFieldAccessFallbackBeanWrapper;
import org.springframework.util.Assert;
import org.springframework.util.NumberUtils;

@Deprecated(since="4.0", forRemoval=true)
public class Jackson2HashMapper
implements HashMapper<Object, String, Object> {
    private final ObjectMapper typingMapper;
    private final ObjectMapper untypedMapper;
    private final boolean flatten;

    public Jackson2HashMapper(final boolean flatten) {
        this(new ObjectMapper(){

            protected TypeResolverBuilder<?> _constructDefaultTypeResolverBuilder(ObjectMapper.DefaultTyping applicability, PolymorphicTypeValidator typeValidator) {
                return new ObjectMapper.DefaultTypeResolverBuilder(this, applicability, typeValidator){
                    final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = this$1;
                        super(t, ptv);
                    }

                    public boolean useForType(JavaType type) {
                        if (type.isPrimitive()) {
                            return false;
                        }
                        if (flatten && (type.isTypeOrSubTypeOf(Number.class) || type.isEnumType())) {
                            return false;
                        }
                        if (ObjectMapper.DefaultTyping.EVERYTHING.equals((Object)this._appliesFor)) {
                            return !TreeNode.class.isAssignableFrom(type.getRawClass());
                        }
                        return super.useForType(type);
                    }
                };
            }
        }.findAndRegisterModules(), flatten);
        this.typingMapper.activateDefaultTyping(this.typingMapper.getPolymorphicTypeValidator(), ObjectMapper.DefaultTyping.EVERYTHING, JsonTypeInfo.As.PROPERTY);
        this.typingMapper.configure(SerializationFeature.WRITE_NULL_MAP_VALUES, false);
        if (flatten) {
            this.typingMapper.disable(new MapperFeature[]{MapperFeature.REQUIRE_TYPE_ID_FOR_SUBTYPES});
        }
        this.typingMapper.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
        this.typingMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        this.typingMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        this.typingMapper.registerModule((Module)new HashMapperModule());
    }

    public Jackson2HashMapper(ObjectMapper mapper, boolean flatten) {
        Assert.notNull((Object)mapper, (String)"Mapper must not be null");
        this.flatten = flatten;
        this.typingMapper = mapper;
        this.untypedMapper = new ObjectMapper();
        this.untypedMapper.configure(SerializationFeature.WRITE_NULL_MAP_VALUES, false);
        this.untypedMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        this.untypedMapper.findAndRegisterModules();
    }

    @Override
    public Map<String, Object> toHash(@Nullable Object source) {
        JsonNode tree = this.typingMapper.valueToTree(source);
        return this.flatten ? FlatEric.flatten(Jackson2AdapterFactory.INSTANCE, tree.properties()) : (Map)this.untypedMapper.convertValue((Object)tree, Map.class);
    }

    @Override
    public @Nullable Object fromHash(Map<String, Object> hash) {
        try {
            if (this.flatten) {
                Map<String, Object> unflattenedHash = FlatEric.unflatten(hash);
                byte[] unflattenedHashedBytes = this.untypedMapper.writeValueAsBytes(unflattenedHash);
                Object hashedObject = this.typingMapper.reader().forType(Object.class).readValue(unflattenedHashedBytes);
                return hashedObject;
            }
            return this.typingMapper.treeToValue((TreeNode)this.untypedMapper.valueToTree(hash), Object.class);
        }
        catch (IOException ex) {
            throw new MappingException(ex.getMessage(), (Throwable)ex);
        }
    }

    private static class HashMapperModule
    extends SimpleModule {
        HashMapperModule() {
            this.addSerializer(Date.class, new UntypedSerializer(new DateToTimestampSerializer()));
            this.addSerializer(Calendar.class, new UntypedSerializer(new CalendarToTimestampSerializer()));
            this.addDeserializer(Date.class, new UntypedDateDeserializer());
            this.addDeserializer(Calendar.class, new UntypedCalendarDeserializer());
        }
    }

    private static enum Jackson2AdapterFactory implements FlatEric.JsonNodeAdapterFactory
    {
        INSTANCE;


        @Override
        public FlatEric.JsonNodeAdapter adapt(Object node) {
            FlatEric.JsonNodeAdapter jsonNodeAdapter;
            if (node instanceof FlatEric.JsonNodeAdapter) {
                FlatEric.JsonNodeAdapter na = (FlatEric.JsonNodeAdapter)node;
                jsonNodeAdapter = na;
            } else {
                jsonNodeAdapter = new Jackson2JsonNodeAdapter((JsonNode)node);
            }
            return jsonNodeAdapter;
        }

        @Override
        public boolean isJsonNode(Object value) {
            return value instanceof JsonNode || value instanceof FlatEric.JsonNodeAdapter;
        }
    }

    private record Jackson2JsonNodeAdapter(JsonNode node) implements FlatEric.JsonNodeAdapter
    {
        @Override
        public FlatEric.JsonNodeType getNodeType() {
            return FlatEric.JsonNodeType.valueOf(this.node().getNodeType().name());
        }

        @Override
        public boolean isArray() {
            return this.node().isArray();
        }

        @Override
        public Collection<? extends FlatEric.JsonNodeAdapter> values() {
            return this.node().valueStream().map(Jackson2JsonNodeAdapter::new).toList();
        }

        @Override
        public String asString() {
            return this.node().asText();
        }

        @Override
        public boolean isNumber() {
            return this.node().isNumber();
        }

        @Override
        public Number numberValue() {
            return this.node().numberValue();
        }

        @Override
        public boolean isString() {
            return this.node().isTextual();
        }

        @Override
        public String stringValue() {
            return this.node().asText();
        }

        @Override
        public boolean isBoolean() {
            return this.node().isBoolean();
        }

        @Override
        public boolean booleanValue() {
            return this.node().booleanValue();
        }

        @Override
        public boolean isBinary() {
            return this.node().isBinary();
        }

        @Override
        public byte[] binaryValue() {
            try {
                return this.node().binaryValue();
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }

        @Override
        public boolean isObject() {
            return this.node().isObject();
        }

        @Override
        public Collection<Map.Entry<String, FlatEric.JsonNodeAdapter>> properties() {
            return this.node().propertyStream().map(it -> Map.entry((String)it.getKey(), new Jackson2JsonNodeAdapter((JsonNode)it.getValue()))).toList();
        }

        @Override
        public Object getDirectValue() {
            return new DirectFieldAccessFallbackBeanWrapper((Object)this.node()).getPropertyValue("_value");
        }
    }

    private static class CalendarToTimestampSerializer
    extends CalendarSerializer {
        private CalendarToTimestampSerializer() {
        }

        protected boolean _asTimestamp(SerializerProvider serializers) {
            return true;
        }
    }

    private static class DateToTimestampSerializer
    extends DateSerializer {
        private DateToTimestampSerializer() {
        }

        protected boolean _asTimestamp(SerializerProvider serializers) {
            return true;
        }
    }

    private static class UntypedSerializer<T>
    extends JsonSerializer<T> {
        private final JsonSerializer<T> delegate;

        UntypedSerializer(JsonSerializer<T> delegate) {
            this.delegate = delegate;
        }

        public void serializeWithType(T value, JsonGenerator jsonGenerator, SerializerProvider serializers, TypeSerializer typeSerializer) throws IOException {
            this.serialize(value, jsonGenerator, serializers);
        }

        public void serialize(@Nullable T value, JsonGenerator jsonGenerator, SerializerProvider serializers) throws IOException {
            if (value != null) {
                this.delegate.serialize(value, jsonGenerator, serializers);
            } else {
                serializers.defaultSerializeNull(jsonGenerator);
            }
        }
    }

    private static class UntypedCalendarDeserializer
    extends JsonDeserializer<Calendar> {
        private final UntypedDateDeserializer dateDeserializer = new UntypedDateDeserializer();

        private UntypedCalendarDeserializer() {
        }

        public @Nullable Object deserializeWithType(JsonParser p, DeserializationContext ctxt, TypeDeserializer typeDeserializer) throws IOException {
            return this.deserialize(p, ctxt);
        }

        public @Nullable Calendar deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            Date date = this.dateDeserializer.deserialize(p, ctxt);
            if (date != null) {
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(date);
                return calendar;
            }
            return null;
        }
    }

    private static class UntypedDateDeserializer
    extends JsonDeserializer<Date> {
        private final JsonDeserializer<?> delegate = new UntypedObjectDeserializer(null, null);

        private UntypedDateDeserializer() {
        }

        public Object deserializeWithType(JsonParser p, DeserializationContext ctxt, TypeDeserializer typeDeserializer) throws IOException {
            return this.deserialize(p, ctxt);
        }

        public Date deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            Object value = this.delegate.deserialize(p, ctxt);
            if (value instanceof Date) {
                return (Date)value;
            }
            try {
                return ctxt.getConfig().getDateFormat().parse(value.toString());
            }
            catch (ParseException ignore) {
                return new Date((Long)NumberUtils.parseNumber((String)value.toString(), Long.class));
            }
        }
    }
}

