/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection;

import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.NullUnmarked;
import org.jspecify.annotations.Nullable;
import org.springframework.data.domain.Range;
import org.springframework.data.redis.connection.zset.Aggregate;
import org.springframework.data.redis.connection.zset.Tuple;
import org.springframework.data.redis.connection.zset.Weights;
import org.springframework.data.redis.core.Cursor;
import org.springframework.data.redis.core.ScanOptions;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

@NullUnmarked
public interface RedisZSetCommands {
    default public Boolean zAdd(byte @NonNull [] key, double score, byte @NonNull [] value) {
        return this.zAdd(key, score, value, ZAddArgs.NONE);
    }

    public Boolean zAdd(byte @NonNull [] var1, double var2, byte @NonNull [] var4, @NonNull ZAddArgs var5);

    default public Long zAdd(byte @NonNull [] key, @NonNull Set<@NonNull Tuple> tuples) {
        return this.zAdd(key, tuples, ZAddArgs.NONE);
    }

    public Long zAdd(byte @NonNull [] var1, @NonNull Set<@NonNull Tuple> var2, @NonNull ZAddArgs var3);

    public Long zRem(byte @NonNull [] var1, byte[] ... var2);

    public Double zIncrBy(byte @NonNull [] var1, double var2, byte @NonNull [] var4);

    public byte @NonNull [] zRandMember(byte @NonNull [] var1);

    public List<byte @NonNull []> zRandMember(byte @NonNull [] var1, long var2);

    public Tuple zRandMemberWithScore(byte @NonNull [] var1);

    public List<@NonNull Tuple> zRandMemberWithScore(byte @NonNull [] var1, long var2);

    public Long zRank(byte @NonNull [] var1, byte @NonNull [] var2);

    public Long zRevRank(byte @NonNull [] var1, byte @NonNull [] var2);

    public Set<byte @NonNull []> zRange(byte @NonNull [] var1, long var2, long var4);

    public Set<@NonNull Tuple> zRangeWithScores(byte @NonNull [] var1, long var2, long var4);

    default public Set<byte @NonNull []> zRangeByScore(byte @NonNull [] key, double min, double max) {
        return this.zRangeByScore(key, (org.springframework.data.domain.Range<? extends Number>)org.springframework.data.domain.Range.closed((Object)min, (Object)max));
    }

    default public Set<@NonNull Tuple> zRangeByScoreWithScores(byte @NonNull [] key, @NonNull org.springframework.data.domain.Range<? extends @NonNull Number> range) {
        return this.zRangeByScoreWithScores(key, range, Limit.unlimited());
    }

    default public Set<@NonNull Tuple> zRangeByScoreWithScores(byte @NonNull [] key, double min, double max) {
        return this.zRangeByScoreWithScores(key, (org.springframework.data.domain.Range<? extends Number>)org.springframework.data.domain.Range.closed((Object)min, (Object)max));
    }

    default public Set<byte @NonNull []> zRangeByScore(byte @NonNull [] key, double min, double max, long offset, long count) {
        return this.zRangeByScore(key, (org.springframework.data.domain.Range<? extends Number>)org.springframework.data.domain.Range.closed((Object)min, (Object)max), new org.springframework.data.redis.connection.Limit().offset(Long.valueOf(offset).intValue()).count(Long.valueOf(count).intValue()));
    }

    default public Set<@NonNull Tuple> zRangeByScoreWithScores(byte @NonNull [] key, double min, double max, long offset, long count) {
        return this.zRangeByScoreWithScores(key, (org.springframework.data.domain.Range<? extends Number>)org.springframework.data.domain.Range.closed((Object)min, (Object)max), new org.springframework.data.redis.connection.Limit().offset(Long.valueOf(offset).intValue()).count(Long.valueOf(count).intValue()));
    }

    public Set<@NonNull Tuple> zRangeByScoreWithScores(byte @NonNull [] var1, @NonNull org.springframework.data.domain.Range<? extends @NonNull Number> var2, @NonNull org.springframework.data.redis.connection.Limit var3);

    public Set<byte @NonNull []> zRevRange(byte @NonNull [] var1, long var2, long var4);

    public Set<@NonNull Tuple> zRevRangeWithScores(byte @NonNull [] var1, long var2, long var4);

    default public Set<byte @NonNull []> zRevRangeByScore(byte @NonNull [] key, double min, double max) {
        return this.zRevRangeByScore(key, (org.springframework.data.domain.Range<? extends Number>)org.springframework.data.domain.Range.closed((Object)min, (Object)max));
    }

    default public Set<byte @NonNull []> zRevRangeByScore(byte @NonNull [] key, @NonNull org.springframework.data.domain.Range<? extends @NonNull Number> range) {
        return this.zRevRangeByScore(key, range, Limit.unlimited());
    }

    default public Set<@NonNull Tuple> zRevRangeByScoreWithScores(byte @NonNull [] key, double min, double max) {
        return this.zRevRangeByScoreWithScores(key, (org.springframework.data.domain.Range<? extends Number>)org.springframework.data.domain.Range.closed((Object)min, (Object)max), Limit.unlimited());
    }

    default public Set<byte @NonNull []> zRevRangeByScore(byte @NonNull [] key, double min, double max, long offset, long count) {
        return this.zRevRangeByScore(key, (org.springframework.data.domain.Range<? extends Number>)org.springframework.data.domain.Range.closed((Object)min, (Object)max), new Limit().offset(Long.valueOf(offset).intValue()).count(Long.valueOf(count).intValue()));
    }

    public Set<byte @NonNull []> zRevRangeByScore(byte @NonNull [] var1, @NonNull org.springframework.data.domain.Range<? extends @NonNull Number> var2, @NonNull org.springframework.data.redis.connection.Limit var3);

    default public Set<@NonNull Tuple> zRevRangeByScoreWithScores(byte @NonNull [] key, double min, double max, long offset, long count) {
        return this.zRevRangeByScoreWithScores(key, (org.springframework.data.domain.Range<? extends Number>)org.springframework.data.domain.Range.closed((Object)min, (Object)max), new org.springframework.data.redis.connection.Limit().offset(Long.valueOf(offset).intValue()).count(Long.valueOf(count).intValue()));
    }

    default public Set<@NonNull Tuple> zRevRangeByScoreWithScores(byte @NonNull [] key, @NonNull org.springframework.data.domain.Range<? extends @NonNull Number> range) {
        return this.zRevRangeByScoreWithScores(key, range, Limit.unlimited());
    }

    public Set<@NonNull Tuple> zRevRangeByScoreWithScores(byte @NonNull [] var1, @NonNull org.springframework.data.domain.Range<? extends @NonNull Number> var2, @NonNull org.springframework.data.redis.connection.Limit var3);

    default public Long zCount(byte @NonNull [] key, double min, double max) {
        return this.zCount(key, (org.springframework.data.domain.Range<? extends Number>)org.springframework.data.domain.Range.closed((Object)min, (Object)max));
    }

    public Long zCount(byte @NonNull [] var1, @NonNull org.springframework.data.domain.Range<? extends @NonNull Number> var2);

    public Long zLexCount(byte @NonNull [] var1, @NonNull org.springframework.data.domain.Range<byte @NonNull []> var2);

    public Tuple zPopMin(byte @NonNull [] var1);

    public Set<@NonNull Tuple> zPopMin(byte @NonNull [] var1, long var2);

    public Tuple bZPopMin(byte @NonNull [] var1, long var2, @NonNull TimeUnit var4);

    public Tuple zPopMax(byte @NonNull [] var1);

    public Set<@NonNull Tuple> zPopMax(byte @NonNull [] var1, long var2);

    public Tuple bZPopMax(byte @NonNull [] var1, long var2, @NonNull TimeUnit var4);

    public Long zCard(byte @NonNull [] var1);

    public Double zScore(byte @NonNull [] var1, byte @NonNull [] var2);

    public List<@NonNull Double> zMScore(byte @NonNull [] var1, byte[] ... var2);

    public Long zRemRange(byte @NonNull [] var1, long var2, long var4);

    public Long zRemRangeByLex(byte @NonNull [] var1, @NonNull org.springframework.data.domain.Range<byte @NonNull []> var2);

    default public Long zRemRangeByScore(byte @NonNull [] key, double min, double max) {
        return this.zRemRangeByScore(key, (org.springframework.data.domain.Range<? extends Number>)org.springframework.data.domain.Range.closed((Object)min, (Object)max));
    }

    public Long zRemRangeByScore(byte @NonNull [] var1, @NonNull org.springframework.data.domain.Range<? extends @NonNull Number> var2);

    public Set<byte[]> zDiff(byte[] ... var1);

    public Set<@NonNull Tuple> zDiffWithScores(byte[] ... var1);

    public Long zDiffStore(byte @NonNull [] var1, byte[] ... var2);

    public Set<byte @NonNull []> zInter(byte[] ... var1);

    public Set<@NonNull Tuple> zInterWithScores(byte[] ... var1);

    default public Set<@NonNull Tuple> zInterWithScores(@NonNull Aggregate aggregate, int[] weights, byte[] ... sets) {
        return this.zInterWithScores(aggregate, Weights.of(weights), sets);
    }

    public Set<@NonNull Tuple> zInterWithScores(@NonNull Aggregate var1, @NonNull Weights var2, byte[] ... var3);

    public Long zInterStore(byte @NonNull [] var1, byte[] ... var2);

    default public Long zInterStore(byte @NonNull [] destKey, @NonNull Aggregate aggregate, int @NonNull [] weights, byte[] ... sets) {
        return this.zInterStore(destKey, aggregate, Weights.of(weights), sets);
    }

    public Long zInterStore(byte @NonNull [] var1, @NonNull Aggregate var2, @NonNull Weights var3, byte[] ... var4);

    public Set<byte @NonNull []> zUnion(byte[] ... var1);

    public Set<@NonNull Tuple> zUnionWithScores(byte[] ... var1);

    default public @Nullable Set<@NonNull Tuple> zUnionWithScores(@NonNull Aggregate aggregate, int @NonNull [] weights, byte[] ... sets) {
        return this.zUnionWithScores(aggregate, Weights.of(weights), sets);
    }

    public Set<@NonNull Tuple> zUnionWithScores(@NonNull Aggregate var1, @NonNull Weights var2, byte[] ... var3);

    public Long zUnionStore(byte @NonNull [] var1, byte[] ... var2);

    default public Long zUnionStore(byte @NonNull [] destKey, @NonNull Aggregate aggregate, int @NonNull [] weights, byte[] ... sets) {
        return this.zUnionStore(destKey, aggregate, Weights.of(weights), sets);
    }

    public Long zUnionStore(byte @NonNull [] var1, @NonNull Aggregate var2, @NonNull Weights var3, byte[] ... var4);

    public Cursor<@NonNull Tuple> zScan(byte @NonNull [] var1, @Nullable ScanOptions var2);

    @Deprecated
    default public Set<byte @NonNull []> zRangeByScore(byte @NonNull [] key, @NonNull String min, @NonNull String max) {
        return this.zRangeByScore(key, new Range().gte(min).lte(max).toRange());
    }

    default public Set<byte @NonNull []> zRangeByScore(byte @NonNull [] key, @NonNull org.springframework.data.domain.Range<? extends @NonNull Number> range) {
        return this.zRangeByScore(key, range, Limit.unlimited());
    }

    public Set<byte @NonNull []> zRangeByScore(byte @NonNull [] var1, @NonNull String var2, @NonNull String var3, long var4, long var6);

    public Set<byte @NonNull []> zRangeByScore(byte @NonNull [] var1, @NonNull org.springframework.data.domain.Range<? extends @NonNull Number> var2, @NonNull org.springframework.data.redis.connection.Limit var3);

    default public Set<byte @NonNull []> zRangeByLex(byte @NonNull [] key) {
        return this.zRangeByLex(key, (org.springframework.data.domain.Range<byte[]>)org.springframework.data.domain.Range.unbounded());
    }

    default public Set<byte @NonNull []> zRangeByLex(byte @NonNull [] key, @NonNull org.springframework.data.domain.Range<byte @NonNull []> range) {
        return this.zRangeByLex(key, range, Limit.unlimited());
    }

    public Set<byte @NonNull []> zRangeByLex(byte @NonNull [] var1, @NonNull org.springframework.data.domain.Range<byte @NonNull []> var2, @NonNull org.springframework.data.redis.connection.Limit var3);

    default public Set<byte @NonNull []> zRevRangeByLex(byte @NonNull [] key) {
        return this.zRevRangeByLex(key, (org.springframework.data.domain.Range<byte[]>)org.springframework.data.domain.Range.unbounded());
    }

    default public Set<byte @NonNull []> zRevRangeByLex(byte @NonNull [] key, @NonNull org.springframework.data.domain.Range<byte @NonNull []> range) {
        return this.zRevRangeByLex(key, range, org.springframework.data.redis.connection.Limit.unlimited());
    }

    public Set<byte @NonNull []> zRevRangeByLex(byte @NonNull [] var1, @NonNull org.springframework.data.domain.Range<byte @NonNull []> var2, @NonNull org.springframework.data.redis.connection.Limit var3);

    default public Long zRangeStoreByLex(byte @NonNull [] dstKey, byte @NonNull [] srcKey, @NonNull org.springframework.data.domain.Range<byte @NonNull []> range) {
        return this.zRangeStoreByLex(dstKey, srcKey, range, org.springframework.data.redis.connection.Limit.unlimited());
    }

    public Long zRangeStoreByLex(byte @NonNull [] var1, byte @NonNull [] var2, @NonNull org.springframework.data.domain.Range<byte @NonNull []> var3, @NonNull org.springframework.data.redis.connection.Limit var4);

    default public Long zRangeStoreRevByLex(byte @NonNull [] dstKey, byte @NonNull [] srcKey, @NonNull org.springframework.data.domain.Range<byte @NonNull []> range) {
        return this.zRangeStoreRevByLex(dstKey, srcKey, range, org.springframework.data.redis.connection.Limit.unlimited());
    }

    public Long zRangeStoreRevByLex(byte @NonNull [] var1, byte @NonNull [] var2, @NonNull org.springframework.data.domain.Range<byte @NonNull []> var3, @NonNull org.springframework.data.redis.connection.Limit var4);

    default public Long zRangeStoreByScore(byte @NonNull [] dstKey, byte @NonNull [] srcKey, @NonNull org.springframework.data.domain.Range<? extends @NonNull Number> range) {
        return this.zRangeStoreByScore(dstKey, srcKey, range, org.springframework.data.redis.connection.Limit.unlimited());
    }

    public Long zRangeStoreByScore(byte @NonNull [] var1, byte @NonNull [] var2, @NonNull org.springframework.data.domain.Range<? extends @NonNull Number> var3, @NonNull org.springframework.data.redis.connection.Limit var4);

    default public Long zRangeStoreRevByScore(byte @NonNull [] dstKey, byte @NonNull [] srcKey, @NonNull org.springframework.data.domain.Range<? extends @NonNull Number> range) {
        return this.zRangeStoreRevByScore(dstKey, srcKey, range, org.springframework.data.redis.connection.Limit.unlimited());
    }

    public Long zRangeStoreRevByScore(byte @NonNull [] var1, byte @NonNull [] var2, @NonNull org.springframework.data.domain.Range<? extends @NonNull Number> var3, @NonNull org.springframework.data.redis.connection.Limit var4);

    @NullMarked
    public static class ZAddArgs {
        private static final ZAddArgs NONE = new ZAddArgs(EnumSet.noneOf(Flag.class));
        private final Set<Flag> flags;

        private ZAddArgs(Set<Flag> flags) {
            this.flags = flags;
        }

        public static ZAddArgs empty() {
            return new ZAddArgs(EnumSet.noneOf(Flag.class));
        }

        public static ZAddArgs ifNotExists() {
            return ZAddArgs.empty().nx();
        }

        public static ZAddArgs ifExists() {
            return ZAddArgs.empty().xx();
        }

        public ZAddArgs nx() {
            this.flags.add(Flag.NX);
            return this;
        }

        public ZAddArgs xx() {
            this.flags.add(Flag.XX);
            return this;
        }

        public ZAddArgs lt() {
            this.flags.add(Flag.LT);
            return this;
        }

        public ZAddArgs gt() {
            this.flags.add(Flag.GT);
            return this;
        }

        public ZAddArgs ch() {
            this.flags.add(Flag.CH);
            return this;
        }

        public boolean contains(Flag flag) {
            return this.flags.contains((Object)flag);
        }

        public boolean isEmpty() {
            return this.flags.isEmpty();
        }

        public boolean equals(@Nullable Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ZAddArgs zAddArgs = (ZAddArgs)o;
            return ObjectUtils.nullSafeEquals(this.flags, zAddArgs.flags);
        }

        public int hashCode() {
            return ObjectUtils.nullSafeHashCode(this.flags);
        }

        public static enum Flag {
            XX,
            NX,
            GT,
            LT,
            CH;

        }
    }

    @Deprecated
    @NullMarked
    public static class Limit
    extends org.springframework.data.redis.connection.Limit {
    }

    @Deprecated
    @NullMarked
    public static class Range {
        @Nullable Boundary min;
        @Nullable Boundary max;

        public static Range range() {
            return new Range();
        }

        public static Range unbounded() {
            Range range = new Range();
            range.min = Boundary.infinite();
            range.max = Boundary.infinite();
            return range;
        }

        public Range gte(Object min) {
            Assert.notNull((Object)min, (String)"Min already set for range.");
            this.min = new Boundary(min, true);
            return this;
        }

        public Range gt(Object min) {
            Assert.notNull((Object)min, (String)"Min already set for range.");
            this.min = new Boundary(min, false);
            return this;
        }

        public Range lte(Object max) {
            Assert.notNull((Object)max, (String)"Max already set for range.");
            this.max = new Boundary(max, true);
            return this;
        }

        public Range lt(Object max) {
            Assert.notNull((Object)max, (String)"Max already set for range.");
            this.max = new Boundary(max, false);
            return this;
        }

        public @Nullable Boundary getMin() {
            return this.min;
        }

        public @Nullable Boundary getMax() {
            return this.max;
        }

        public <T> org.springframework.data.domain.Range<@NonNull T> toRange() {
            Range.Bound<Object> lower = this.toBound(this.min);
            Range.Bound<Object> upper = this.toBound(this.max);
            return org.springframework.data.domain.Range.from(lower).to(upper);
        }

        private Range.Bound<Object> toBound(@Nullable Boundary boundary) {
            if (boundary == null || boundary.getValue() == null) {
                return Range.Bound.unbounded();
            }
            return boundary.isIncluding() ? Range.Bound.inclusive((Object)boundary.getValue()) : Range.Bound.exclusive((Object)boundary.getValue());
        }

        public static class Boundary {
            @Nullable Object value;
            boolean including;

            static Boundary infinite() {
                return new Boundary(null, true);
            }

            Boundary(@Nullable Object value, boolean including) {
                this.value = value;
                this.including = including;
            }

            public @Nullable Object getValue() {
                return this.value;
            }

            public boolean isIncluding() {
                return this.including;
            }
        }
    }
}

